/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchFieldValueOverFieldValueRule
extends ValueComputationRule<Value, Map<Value, ValueCompensation>, FieldValue> {
    @Nonnull
    private static final BindingMatcher<FieldValue> childFieldMatcher = ValueMatchers.anyFieldValue();
    @Nonnull
    private static final BindingMatcher<FieldValue> rootMatcher = ValueMatchers.fieldValue(childFieldMatcher);

    public MatchFieldValueOverFieldValueRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(FieldValue.class);
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Value, Map<Value, ValueCompensation>> call) {
        Map<Value, ValueCompensation> childMatchedValuesMap;
        Map<Value, ValueCompensation> matchedValuesMap;
        PlannerBindings bindings = call.getBindings();
        FieldValue rootValue = bindings.get(rootMatcher);
        FieldValue childValue = bindings.get(childFieldMatcher);
        NonnullPair<Value, Map<Value, ValueCompensation>> resultPair = call.getResult(rootValue);
        Map<Value, ValueCompensation> map = matchedValuesMap = resultPair == null ? null : resultPair.getRight();
        if (matchedValuesMap != null && !matchedValuesMap.isEmpty()) {
            return;
        }
        NonnullPair<Value, Map<Value, ValueCompensation>> childResultPair = call.getResult(childValue);
        Map<Value, ValueCompensation> map2 = childMatchedValuesMap = childResultPair == null ? null : childResultPair.getRight();
        if (childMatchedValuesMap == null || childMatchedValuesMap.isEmpty()) {
            return;
        }
        FieldValue fusedFieldValue = FieldValue.ofFieldsAndFuseIfPossible(childValue, rootValue.getFieldPath());
        LinkedIdentityMap<FieldValue, ValueCompensation> newMatchedValuesMap = new LinkedIdentityMap<FieldValue, ValueCompensation>();
        newMatchedValuesMap.put(fusedFieldValue, ValueCompensation.noCompensation());
        call.yieldResultBuilder().addConstraintsFrom(rootValue).yieldResult(NonnullPair.of(fusedFieldValue, newMatchedValuesMap));
    }
}

