/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.FieldValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchOrCompensateFieldValueRule
extends ValueComputationRule<Iterable<? extends Value>, Map<Value, ValueCompensation>, FieldValue> {
    @Nonnull
    private static final CollectionMatcher<Integer> fieldPathOrdinalsMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final CollectionMatcher<Type> fieldPathTypesMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final BindingMatcher<FieldValue> rootMatcher = ValueMatchers.fieldValueWithFieldPath(ValueMatchers.anyValue(), fieldPathOrdinalsMatcher, fieldPathTypesMatcher);

    public MatchOrCompensateFieldValueRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Iterable<? extends Value>, Map<Value, ValueCompensation>> call) {
        PlannerBindings bindings = call.getBindings();
        FieldValue fieldValue = bindings.get(rootMatcher);
        Iterable<? extends Value> toBePulledUpValues = Objects.requireNonNull(call.getArgument());
        NonnullPair<Value, Map<Value, ValueCompensation>> resultPairFromChild = call.getResult(fieldValue.getChild());
        Map<Value, ValueCompensation> matchedValuesMap = resultPairFromChild == null ? null : resultPairFromChild.getRight();
        LinkedIdentityMap newMatchedValuesMap = new LinkedIdentityMap();
        for (Value value : toBePulledUpValues) {
            if (!(value instanceof FieldValue)) continue;
            if (matchedValuesMap == null || !matchedValuesMap.containsKey(value)) {
                FieldValue toBePulledUpFieldValue = (FieldValue)value;
                if (!fieldValue.getChild().semanticEquals((Object)toBePulledUpFieldValue.getChild(), call.getEquivalenceMap())) continue;
                Optional<FieldValue.FieldPath> pathSuffixOptional = FieldValue.stripFieldPrefixMaybe(toBePulledUpFieldValue.getFieldPath(), fieldValue.getFieldPath());
                pathSuffixOptional.ifPresent(pathSuffix -> {
                    if (pathSuffix.isEmpty()) {
                        newMatchedValuesMap.put(toBePulledUpValue, ValueCompensation.noCompensation());
                    } else {
                        newMatchedValuesMap.put(toBePulledUpValue, new FieldValueCompensation((FieldValue.FieldPath)pathSuffix));
                    }
                });
                continue;
            }
            ValueCompensation compensation = matchedValuesMap.get(value);
            if (!(compensation instanceof FieldValueCompensation)) continue;
            FieldValueCompensation fieldValueCompensation = (FieldValueCompensation)compensation;
            Optional<FieldValue.FieldPath> pathSuffixOptional = FieldValue.stripFieldPrefixMaybe(fieldValueCompensation.getFieldPath(), fieldValue.getFieldPath());
            pathSuffixOptional.ifPresent(pathSuffix -> newMatchedValuesMap.put(toBePulledUpValue, fieldValueCompensation.withSuffix((FieldValue.FieldPath)pathSuffix)));
        }
        call.yieldValue(fieldValue, newMatchedValuesMap);
    }
}

