/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchSimpleFieldValueRule
extends ValueComputationRule<Value, Map<Value, ValueCompensation>, FieldValue> {
    @Nonnull
    private static final BindingMatcher<FieldValue> rootMatcher = ValueMatchers.fieldValue(ValueMatchers.quantifiedObjectValue());

    public MatchSimpleFieldValueRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(FieldValue.class);
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Value, Map<Value, ValueCompensation>> call) {
        PlannerBindings bindings = call.getBindings();
        FieldValue rootValue = bindings.get(rootMatcher);
        Value baseValue = Objects.requireNonNull(call.getArgument());
        NonnullPair<Value, Map<Value, ValueCompensation>> resultPair = call.getResult(rootValue);
        Map<Value, ValueCompensation> matchedValuesMap = resultPair == null ? null : resultPair.getRight();
        Verify.verify(matchedValuesMap == null || matchedValuesMap.isEmpty() || matchedValuesMap.size() == 1 && matchedValuesMap.containsKey(rootValue));
        if (!rootValue.isFunctionallyDependentOn(baseValue)) {
            return;
        }
        LinkedIdentityMap<FieldValue, ValueCompensation> newMatchedValuesMap = new LinkedIdentityMap<FieldValue, ValueCompensation>();
        newMatchedValuesMap.put(rootValue, ValueCompensation.noCompensation());
        call.yieldValue(rootValue, newMatchedValuesMap);
    }
}

