/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MatchValueAgainstQuantifiedObjectValueRule
extends ValueComputationRule<Iterable<? extends Value>, Map<Value, ValueCompensation>, QuantifiedObjectValue> {
    @Nonnull
    private static final BindingMatcher<QuantifiedObjectValue> rootMatcher = ValueMatchers.quantifiedObjectValue();

    public MatchValueAgainstQuantifiedObjectValueRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Iterable<? extends Value>, Map<Value, ValueCompensation>> call) {
        PlannerBindings bindings = call.getBindings();
        QuantifiedObjectValue quantifiedObjectValue = bindings.get(rootMatcher);
        Iterable<? extends Value> toBePulledUpValues = Objects.requireNonNull(call.getArgument());
        NonnullPair<Value, Map<Value, ValueCompensation>> resultPairFromChild = call.getResult(quantifiedObjectValue);
        Map<Value, ValueCompensation> matchedValuesMap = resultPairFromChild == null ? null : resultPairFromChild.getRight();
        LinkedIdentityMap<Value, ValueCompensation> newMatchedValuesMap = new LinkedIdentityMap<Value, ValueCompensation>();
        for (Value value2 : toBePulledUpValues) {
            if (value2 instanceof FieldValue || value2 instanceof QuantifiedObjectValue) {
                MatchValueAgainstQuantifiedObjectValueRule.inheritMatchedMapEntry(matchedValuesMap, newMatchedValuesMap, value2);
                continue;
            }
            Set<CorrelationIdentifier> correlatedTo = value2.getCorrelatedTo();
            if (correlatedTo.isEmpty()) {
                MatchValueAgainstQuantifiedObjectValueRule.inheritMatchedMapEntry(matchedValuesMap, newMatchedValuesMap, value2);
                continue;
            }
            if (correlatedTo.size() > 1) continue;
            CorrelationIdentifier alias = Iterables.getOnlyElement(correlatedTo);
            newMatchedValuesMap.put(value2, value -> {
                RegularTranslationMap.Builder translationMapBuilder = TranslationMap.regularBuilder();
                translationMapBuilder.when(alias).then((sourceAlias, leafValue) -> value);
                return toBePulledUpValue.translateCorrelations(translationMapBuilder.build());
            });
        }
        call.yieldValue(quantifiedObjectValue, newMatchedValuesMap);
    }

    private static void inheritMatchedMapEntry(@Nullable Map<Value, ValueCompensation> matchedValuesMap, @Nonnull Map<Value, ValueCompensation> newMatchedValuesMap, @Nonnull Value toBePulledUpValue) {
        if (matchedValuesMap != null && matchedValuesMap.containsKey(toBePulledUpValue)) {
            newMatchedValuesMap.put(toBePulledUpValue, matchedValuesMap.get(toBePulledUpValue));
        }
    }
}

