/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ComputeToOrderedBytesValueRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultOrderingPartRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.EliminateArithmeticValueWithConstantRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleSet;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class OrderingValueComputationRuleSet<O extends OrderingPart.SortOrder, P extends OrderingPart<O>>
extends ValueComputationRuleSet<OrderingPart.OrderingPartCreator<O, P>, P> {
    private static final LoadingCache<OrderingPart.ProvidedSortOrder, OrderingValueComputationRuleSet<OrderingPart.ProvidedSortOrder, OrderingPart.ProvidedOrderingPart>> providedOrderingComputationRuleSetCache = CacheBuilder.newBuilder().maximumSize(OrderingPart.ProvidedSortOrder.values().length).build(new CacheLoader<OrderingPart.ProvidedSortOrder, OrderingValueComputationRuleSet<OrderingPart.ProvidedSortOrder, OrderingPart.ProvidedOrderingPart>>(){

        @Override
        @Nonnull
        public OrderingValueComputationRuleSet<OrderingPart.ProvidedSortOrder, OrderingPart.ProvidedOrderingPart> load(@Nonnull OrderingPart.ProvidedSortOrder providedSortOrder) throws Exception {
            return OrderingValueComputationRuleSet.computeUsingProvidedOrderingParts(providedSortOrder);
        }
    });
    private static final LoadingCache<OrderingPart.MatchedSortOrder, OrderingValueComputationRuleSet<OrderingPart.MatchedSortOrder, OrderingPart.MatchedOrderingPart>> matchedOrderingComputationRuleSetCache = CacheBuilder.newBuilder().maximumSize(OrderingPart.ProvidedSortOrder.values().length).build(new CacheLoader<OrderingPart.MatchedSortOrder, OrderingValueComputationRuleSet<OrderingPart.MatchedSortOrder, OrderingPart.MatchedOrderingPart>>(){

        @Override
        @Nonnull
        public OrderingValueComputationRuleSet<OrderingPart.MatchedSortOrder, OrderingPart.MatchedOrderingPart> load(@Nonnull OrderingPart.MatchedSortOrder matchedSortOrder) {
            return OrderingValueComputationRuleSet.computeUsingMatchedOrderingParts(matchedSortOrder);
        }
    });
    private static final LoadingCache<OrderingPart.RequestedSortOrder, OrderingValueComputationRuleSet<OrderingPart.RequestedSortOrder, OrderingPart.RequestedOrderingPart>> requestedOrderingComputationRuleSetCache = CacheBuilder.newBuilder().maximumSize(OrderingPart.ProvidedSortOrder.values().length).build(new CacheLoader<OrderingPart.RequestedSortOrder, OrderingValueComputationRuleSet<OrderingPart.RequestedSortOrder, OrderingPart.RequestedOrderingPart>>(){

        @Override
        @Nonnull
        public OrderingValueComputationRuleSet<OrderingPart.RequestedSortOrder, OrderingPart.RequestedOrderingPart> load(@Nonnull OrderingPart.RequestedSortOrder requestedSortOrder) {
            return OrderingValueComputationRuleSet.computeUsingRequestedOrderingParts(requestedSortOrder);
        }
    });

    private OrderingValueComputationRuleSet(@Nonnull Set<? extends AbstractValueRule<NonnullPair<Value, P>, ValueComputationRuleCall<OrderingPart.OrderingPartCreator<O, P>, P>, ? extends Value>> rules, @Nonnull SetMultimap<? extends AbstractValueRule<NonnullPair<Value, P>, ValueComputationRuleCall<OrderingPart.OrderingPartCreator<O, P>, P>, ? extends Value>, ? extends AbstractValueRule<NonnullPair<Value, P>, ValueComputationRuleCall<OrderingPart.OrderingPartCreator<O, P>, P>, ? extends Value>> dependsOn) {
        super(rules, dependsOn);
    }

    @Nonnull
    protected static <O extends OrderingPart.SortOrder, P extends OrderingPart<O>> ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, ArithmeticValue> eliminateArithmeticValueWithConstantRule(@Nonnull O sortOrder) {
        return ValueComputationRule.fromSimplificationRule(new EliminateArithmeticValueWithConstantRule(), (creator, value, ignored) -> Objects.requireNonNull(creator).create(value, sortOrder));
    }

    @Nonnull
    protected static <O extends OrderingPart.SortOrder, P extends OrderingPart<O>> ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, ToOrderedBytesValue> computeToOrderedBytesValueRule(@Nonnull Function<TupleOrdering.Direction, O> directionToSortOrderFunction) {
        return new ComputeToOrderedBytesValueRule(directionToSortOrderFunction);
    }

    @Nonnull
    protected static <O extends OrderingPart.SortOrder, P extends OrderingPart<O>> ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, Value> defaultOrderingPartRule(@Nonnull O sortOrder) {
        return new DefaultOrderingPartRule(sortOrder);
    }

    private static <O extends OrderingPart.SortOrder, P extends OrderingPart<O>> OrderingValueComputationRuleSet<O, P> ruleSet(@Nonnull O sortOrder, @Nonnull ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, ArithmeticValue> eliminateArithmeticValueWithConstantRule, @Nonnull ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, ToOrderedBytesValue> computeToOrderedBytesValueRule, @Nonnull ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, Value> defaultOrderingPartRule) {
        ValueComputationRuleSet.TransformedRules<OrderingPart.OrderingPartCreator, OrderingPart> transformedRules = ValueComputationRuleSet.fromSimplificationRules(DefaultValueSimplificationRuleSet.SIMPLIFICATION_RULES, DefaultValueSimplificationRuleSet.SIMPLIFICATION_DEPENDS_ON, (creator, value, ignored) -> Objects.requireNonNull(creator).create(value, sortOrder));
        ImmutableCollection localOrderingRules = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(eliminateArithmeticValueWithConstantRule)).add(computeToOrderedBytesValueRule)).add(defaultOrderingPartRule)).build();
        ImmutableCollection orderingRules = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(transformedRules.getComputationRules())).addAll((Iterable)localOrderingRules)).build();
        ImmutableSetMultimap.Builder dependsOnBuilder = ImmutableSetMultimap.builder();
        dependsOnBuilder.putAll(transformedRules.getComputationDependsOn());
        for (ValueComputationRule localOrderingRule : localOrderingRules) {
            for (ValueComputationRule<OrderingPart.OrderingPartCreator, OrderingPart, Value> orderingRule : transformedRules.getComputationRules()) {
                dependsOnBuilder.put(localOrderingRule, orderingRule);
            }
        }
        dependsOnBuilder.put(computeToOrderedBytesValueRule, eliminateArithmeticValueWithConstantRule);
        dependsOnBuilder.put(defaultOrderingPartRule, computeToOrderedBytesValueRule);
        return new OrderingValueComputationRuleSet<O, P>(orderingRules, dependsOnBuilder.build());
    }

    @Nonnull
    private static OrderingValueComputationRuleSet<OrderingPart.ProvidedSortOrder, OrderingPart.ProvidedOrderingPart> computeUsingProvidedOrderingParts(@Nonnull OrderingPart.ProvidedSortOrder providedSortOrder) {
        return OrderingValueComputationRuleSet.ruleSet(providedSortOrder, OrderingValueComputationRuleSet.eliminateArithmeticValueWithConstantRule(providedSortOrder), OrderingValueComputationRuleSet.computeToOrderedBytesValueRule(OrderingPart.ProvidedSortOrder::fromDirection), OrderingValueComputationRuleSet.defaultOrderingPartRule(providedSortOrder));
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.ProvidedSortOrder, OrderingPart.ProvidedOrderingPart> usingProvidedOrderingParts() {
        return OrderingValueComputationRuleSet.usingProvidedOrderingParts(OrderingPart.ProvidedSortOrder.ASCENDING);
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.ProvidedSortOrder, OrderingPart.ProvidedOrderingPart> usingProvidedOrderingParts(@Nonnull OrderingPart.ProvidedSortOrder providedSortOrder) {
        return providedOrderingComputationRuleSetCache.getUnchecked(providedSortOrder);
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.MatchedSortOrder, OrderingPart.MatchedOrderingPart> computeUsingMatchedOrderingParts(@Nonnull OrderingPart.MatchedSortOrder matchedSortOrder) {
        return OrderingValueComputationRuleSet.ruleSet(matchedSortOrder, OrderingValueComputationRuleSet.eliminateArithmeticValueWithConstantRule(matchedSortOrder), OrderingValueComputationRuleSet.computeToOrderedBytesValueRule(OrderingPart.MatchedSortOrder::fromDirection), OrderingValueComputationRuleSet.defaultOrderingPartRule(matchedSortOrder));
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.MatchedSortOrder, OrderingPart.MatchedOrderingPart> usingMatchedOrderingParts() {
        return OrderingValueComputationRuleSet.usingMatchedOrderingParts(OrderingPart.MatchedSortOrder.ASCENDING);
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.MatchedSortOrder, OrderingPart.MatchedOrderingPart> usingMatchedOrderingParts(@Nonnull OrderingPart.MatchedSortOrder matchedSortOrder) {
        return matchedOrderingComputationRuleSetCache.getUnchecked(matchedSortOrder);
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.RequestedSortOrder, OrderingPart.RequestedOrderingPart> computeUsingRequestedOrderingParts(@Nonnull OrderingPart.RequestedSortOrder requestedSortOrder) {
        return OrderingValueComputationRuleSet.ruleSet(requestedSortOrder, OrderingValueComputationRuleSet.eliminateArithmeticValueWithConstantRule(requestedSortOrder), OrderingValueComputationRuleSet.computeToOrderedBytesValueRule(OrderingPart.RequestedSortOrder::fromDirection), OrderingValueComputationRuleSet.defaultOrderingPartRule(requestedSortOrder));
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.RequestedSortOrder, OrderingPart.RequestedOrderingPart> usingRequestedOrderingParts() {
        return OrderingValueComputationRuleSet.usingRequestedOrderingParts(OrderingPart.RequestedSortOrder.ASCENDING);
    }

    @Nonnull
    public static OrderingValueComputationRuleSet<OrderingPart.RequestedSortOrder, OrderingPart.RequestedOrderingPart> usingRequestedOrderingParts(@Nonnull OrderingPart.RequestedSortOrder requestedSortOrder) {
        return requestedOrderingComputationRuleSetCache.getUnchecked(requestedSortOrder);
    }
}

