/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Constrained;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Simplification {
    @Nonnull
    public static Constrained<Value> simplify(@Nonnull Value root, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull AbstractValueRuleSet<Value, ValueSimplificationRuleCall> ruleSet) {
        LinkedHashMap constraintsMap = Maps.newLinkedHashMap();
        Value simplifiedValue = root.mapMaybe((current, mappedChildren) -> {
            boolean isRoot = current == root;
            current = Simplification.computeCurrent(current, mappedChildren);
            ExecutionResult<Value> executionResult = Simplification.executeRuleSetIteratively(isRoot ? current : root, current, ruleSet, (rule, r, c, plannerBindings) -> new ValueSimplificationRuleCall(rule, (Value)r, (Value)c, evaluationContext, plannerBindings, aliasMap, constantAliases, constraintsMap::get), (results, queryPlanConstraint) -> (Value)Simplification.onResultsFunctionForSimplification(constraintsMap, results, queryPlanConstraint));
            Verify.verify(!executionResult.shouldReExplore());
            return executionResult.getBase();
        }).orElseThrow(() -> new RecordCoreException("expected a mapped tree", new Object[0]));
        return Constrained.ofConstrainedObject(simplifiedValue, Simplification.collectAndComposeConstraints(simplifiedValue, constraintsMap));
    }

    @Nonnull
    private static <BASE extends TreeLike<BASE>> QueryPlanConstraint collectAndComposeConstraints(@Nonnull BASE root, @Nonnull Map<BASE, QueryPlanConstraint> constraintMap) {
        return root.postOrderStream().flatMap(current -> {
            QueryPlanConstraint constraint = (QueryPlanConstraint)constraintMap.get(current);
            return Stream.ofNullable(constraint);
        }).filter(QueryPlanConstraint::isConstrained).reduce(QueryPlanConstraint::compose).orElse(QueryPlanConstraint.noConstraint());
    }

    @Nonnull
    public static List<Constrained<Value>> simplifyCurrent(@Nonnull Value current, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull AbstractValueRuleSet<Value, ValueSimplificationRuleCall> ruleSet) {
        LinkedHashMap constraintsMap = Maps.newLinkedHashMap();
        List<ExecutionResult<Value>> executionResults = Simplification.executeRuleSet(current, current, ruleSet, (rule, r, c, plannerBindings) -> new ValueSimplificationRuleCall(rule, (Value)r, (Value)c, evaluationContext, plannerBindings, aliasMap, constantAliases, constraintsMap::get), (results, queryPlanConstraint) -> (Value)Simplification.onResultsFunctionForSimplification(constraintsMap, results, queryPlanConstraint));
        return executionResults.stream().map(ExecutionResult::getBase).map(value -> Constrained.ofConstrainedObject(value, Simplification.collectAndComposeConstraints(value, constraintsMap))).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static <RESULT, CALL extends AbstractRuleCall<RESULT, CALL, BASE>, BASE> List<ExecutionResult<BASE>> executeRuleSet(@Nonnull BASE root, @Nonnull BASE current, @Nonnull AbstractRuleSet<CALL, BASE> ruleSet, @Nonnull RuleCallCreator<RESULT, CALL, BASE> ruleCallCreator, @Nonnull BiFunction<Collection<RESULT>, QueryPlanConstraint, BASE> onResultsFunction) {
        boolean isRoot = current == root;
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        Iterator ruleIterator = ruleSet.getRules(current).iterator();
        while (ruleIterator.hasNext()) {
            PlannerRule rule = (PlannerRule)ruleIterator.next();
            BindingMatcher matcher = rule.getMatcher();
            Iterator matchIterator = matcher.bindMatches(RecordQueryPlannerConfiguration.defaultPlannerConfiguration(), PlannerBindings.empty(), current).iterator();
            while (matchIterator.hasNext()) {
                BASE newCurrent;
                PlannerBindings plannerBindings = (PlannerBindings)matchIterator.next();
                CALL ruleCall = ruleCallCreator.create(rule, isRoot ? current : root, current, plannerBindings);
                rule.onMatch(ruleCall);
                Collection<RESULT> results = ((AbstractRuleCall)ruleCall).getResults();
                QueryPlanConstraint queryPlanConstraint = ((AbstractRuleCall)ruleCall).getResultQueryPlanConstraint();
                if (results.isEmpty() || current == (newCurrent = onResultsFunction.apply(results, queryPlanConstraint))) continue;
                resultsBuilder.add(new ExecutionResult<BASE>(newCurrent, ((AbstractRuleCall)ruleCall).shouldReExplore()));
            }
        }
        return resultsBuilder.build();
    }

    @Nullable
    public static <ARGUMENT, RESULT> NonnullPair<Constrained<Value>, RESULT> compute(@Nonnull Value root, @Nonnull EvaluationContext evaluationContext, @Nonnull ARGUMENT argument, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull ValueComputationRuleSet<ARGUMENT, RESULT> ruleSet) {
        LinkedIdentityMap resultsMap = new LinkedIdentityMap();
        LinkedHashMap constraintsMap = Maps.newLinkedHashMap();
        Value newRoot = root.mapMaybe((current, mappedChildren) -> {
            boolean isRoot = current == root;
            current = Simplification.computeCurrent(current, mappedChildren);
            ExecutionResult<Value> executionResult = Simplification.executeRuleSetIteratively(isRoot ? current : root, current, ruleSet, (rule, r, c, plannerBindings) -> new ValueComputationRuleCall(rule, (Value)r, (Value)c, evaluationContext, argument, plannerBindings, aliasMap, constantAliases, constraintsMap::get, resultsMap::get), (results, queryPlanConstraint) -> (Value)Simplification.onResultsFunctionForComputation(constraintsMap, resultsMap, results, queryPlanConstraint));
            Verify.verify(!executionResult.shouldReExplore());
            return executionResult.getBase();
        }).orElseThrow(() -> new RecordCoreException("expected a mapped tree", new Object[0]));
        NonnullPair simplifiedPair = (NonnullPair)resultsMap.get(newRoot);
        return simplifiedPair == null ? null : NonnullPair.of(Constrained.ofConstrainedObject(newRoot, Simplification.collectAndComposeConstraints(newRoot, constraintsMap)), simplifiedPair.getRight());
    }

    @Nonnull
    private static <BASE extends TreeLike<BASE>> BASE computeCurrent(@Nonnull BASE current, @Nonnull Iterable<? extends BASE> mappedChildren) {
        Iterable<BASE> children = current.getChildren();
        Iterator<BASE> childrenIterator = children.iterator();
        Iterator<BASE> mappedChildrenIterator = mappedChildren.iterator();
        boolean isSame = true;
        while (childrenIterator.hasNext() && mappedChildrenIterator.hasNext()) {
            TreeLike mappedChild;
            TreeLike child = (TreeLike)childrenIterator.next();
            if (child == (mappedChild = (TreeLike)mappedChildrenIterator.next())) continue;
            isSame = false;
            break;
        }
        Verify.verify(childrenIterator.hasNext() == mappedChildrenIterator.hasNext());
        return isSame ? current : current.withChildren(mappedChildren);
    }

    @Nonnull
    private static <BASE> BASE onResultsFunctionForSimplification(@Nonnull Map<BASE, QueryPlanConstraint> constrainstsMap, @Nonnull Collection<BASE> results, @Nonnull QueryPlanConstraint queryPlanConstraint) {
        Verify.verify(results.size() <= 1);
        BASE result = Iterables.getOnlyElement(results);
        constrainstsMap.put(result, queryPlanConstraint);
        return result;
    }

    @Nonnull
    private static <BASE, R> BASE onResultsFunctionForComputation(@Nonnull Map<BASE, QueryPlanConstraint> constrainstsMap, @Nonnull Map<BASE, NonnullPair<BASE, R>> resultsMap, @Nonnull Collection<NonnullPair<BASE, R>> results, @Nonnull QueryPlanConstraint queryPlanConstraint) {
        Verify.verify(results.size() <= 1);
        NonnullPair<BASE, R> resultPair = Iterables.getOnlyElement(results);
        BASE value = resultPair.getLeft();
        constrainstsMap.put(value, queryPlanConstraint);
        resultsMap.put(value, resultPair);
        return value;
    }

    @Nonnull
    private static <RESULT, CALL extends AbstractRuleCall<RESULT, CALL, BASE>, BASE> ExecutionResult<BASE> executeRuleSetIteratively(@Nonnull BASE root, @Nonnull BASE current, @Nonnull AbstractRuleSet<CALL, BASE> ruleSet, @Nonnull RuleCallCreator<RESULT, CALL, BASE> ruleCallCreator, @Nonnull BiFunction<Collection<RESULT>, QueryPlanConstraint, BASE> onResultsFunction) {
        boolean isRoot = current == root;
        BASE newCurrent = current;
        block0: do {
            current = newCurrent;
            Iterator ruleIterator = ruleSet.getRules(current).iterator();
            while (ruleIterator.hasNext()) {
                PlannerRule rule = (PlannerRule)ruleIterator.next();
                BindingMatcher matcher = rule.getMatcher();
                Iterator matchIterator = matcher.bindMatches(RecordQueryPlannerConfiguration.defaultPlannerConfiguration(), PlannerBindings.empty(), current).iterator();
                while (matchIterator.hasNext()) {
                    PlannerBindings plannerBindings = (PlannerBindings)matchIterator.next();
                    CALL ruleCall = ruleCallCreator.create(rule, isRoot ? current : root, current, plannerBindings);
                    rule.onMatch(ruleCall);
                    Collection<RESULT> results = ((AbstractRuleCall)ruleCall).getResults();
                    QueryPlanConstraint queryPlanConstraint = ((AbstractRuleCall)ruleCall).getResultQueryPlanConstraint();
                    if (results.isEmpty() || current == (newCurrent = onResultsFunction.apply(results, queryPlanConstraint))) continue;
                    if (!((AbstractRuleCall)ruleCall).shouldReExplore()) break;
                    return new ExecutionResult<BASE>(newCurrent, true);
                }
                if (current == newCurrent) continue;
                continue block0;
            }
        } while (current != newCurrent);
        return new ExecutionResult<BASE>(current, false);
    }

    @Nonnull
    public static Constrained<QueryPredicate> optimize(@Nonnull QueryPredicate root, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull AbstractRuleSet<QueryPredicateSimplificationRuleCall, QueryPredicate> ruleSet) {
        LinkedHashMap constraintsMap = Maps.newLinkedHashMap();
        QueryPredicate simplifiedPredicate = Simplification.simplifyWithReExploration(root, root, constraintsMap, ruleSet, (rule, r, c, plannerBindings) -> new QueryPredicateSimplificationRuleCall(rule, (QueryPredicate)r, (QueryPredicate)c, evaluationContext, plannerBindings, aliasMap, constantAliases, constraintsMap::get));
        return simplifiedPredicate == root ? Constrained.unconstrained(root) : Constrained.ofConstrainedObject(simplifiedPredicate, Simplification.collectAndComposeConstraints(simplifiedPredicate, constraintsMap));
    }

    @Nonnull
    private static <CALL extends AbstractRuleCall<BASE, CALL, BASE>, BASE extends TreeLike<BASE>> BASE simplifyWithReExploration(@Nonnull BASE root, @Nonnull BASE current, @Nonnull Map<BASE, QueryPlanConstraint> constraintsMap, @Nonnull AbstractRuleSet<CALL, BASE> ruleSet, @Nonnull RuleCallCreator<BASE, CALL, BASE> ruleCallCreator) {
        ExecutionResult<TreeLike> executionResult;
        boolean isRoot = root == current;
        do {
            ArrayList<TreeLike> simplifiedChildren = Lists.newArrayList();
            for (TreeLike child : current.getChildren()) {
                simplifiedChildren.add(Simplification.simplifyWithReExploration(isRoot ? current : root, child, constraintsMap, ruleSet, ruleCallCreator));
            }
            current = Simplification.computeCurrent(current, simplifiedChildren);
            executionResult = Simplification.executeRuleSetIteratively(isRoot ? current : root, current, ruleSet, ruleCallCreator, (results, queryPlanConstraint) -> (TreeLike)Simplification.onResultsFunctionForSimplification(constraintsMap, results, queryPlanConstraint));
            TreeLike newCurrent = executionResult.getBase();
            Verify.verify(newCurrent != current || !executionResult.shouldReExplore());
            current = newCurrent;
        } while (executionResult.shouldReExplore());
        return (BASE)current;
    }

    @FunctionalInterface
    public static interface RuleCallCreator<RESULT, CALL extends AbstractRuleCall<RESULT, CALL, BASE>, BASE> {
        public CALL create(@Nonnull PlannerRule<CALL, ? extends BASE> var1, @Nonnull BASE var2, @Nonnull BASE var3, @Nonnull PlannerBindings var4);
    }

    private static class ExecutionResult<BASE> {
        @Nonnull
        private final BASE base;
        private final boolean shouldReExplore;

        public ExecutionResult(@Nonnull BASE base, boolean shouldReExplore) {
            this.base = base;
            this.shouldReExplore = shouldReExplore;
        }

        @Nonnull
        public BASE getBase() {
            return this.base;
        }

        public boolean shouldReExplore() {
            return this.shouldReExplore;
        }
    }
}

