/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class ValueComputationRule<A, R, T extends Value>
extends AbstractValueRule<NonnullPair<Value, R>, ValueComputationRuleCall<A, R>, T> {
    public ValueComputationRule(@Nonnull BindingMatcher<T> matcher) {
        super(matcher);
    }

    @Nonnull
    static <A, R, T extends Value> ValueComputationRule<A, R, T> fromSimplificationRule(final @Nonnull ValueSimplificationRule<T> simplificationRule, final @Nonnull OnMatchComputationFunction<A, R> onMatchComputationFunction) {
        return new ValueComputationRule<A, R, T>(simplificationRule.getMatcher()){

            @Override
            @Nonnull
            public Optional<Class<?>> getRootOperator() {
                return simplificationRule.getRootOperator();
            }

            @Override
            public void onMatch(@Nonnull ValueComputationRuleCall<A, R> call) {
                List childrenResults = Streams.stream(((Value)call.getCurrent()).getChildren()).map(value -> {
                    NonnullPair childResultPair = call.getResult((Value)value);
                    return childResultPair == null ? null : childResultPair.getValue();
                }).collect(Collectors.toList());
                ValueSimplificationRuleCall simplificationRuleCall = call.toValueSimplificationRuleCall(simplificationRule);
                simplificationRule.onMatch(simplificationRuleCall);
                Collection results = simplificationRuleCall.getResults();
                results.forEach(resultValue -> call.yieldValue((Value)resultValue, onMatchComputationFunction.apply(call.getArgument(), (Value)resultValue, childrenResults)));
                call.composeAdditionalConstraint(simplificationRuleCall.getResultQueryPlanConstraint());
            }
        };
    }

    @FunctionalInterface
    public static interface OnMatchComputationFunction<A, R> {
        public R apply(@Nullable A var1, @Nonnull Value var2, @Nonnull List<R> var3);
    }
}

