/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class ValueComputationRuleSet<A, R>
extends AbstractValueRuleSet<NonnullPair<Value, R>, ValueComputationRuleCall<A, R>> {
    public ValueComputationRuleSet(@Nonnull Set<? extends AbstractValueRule<NonnullPair<Value, R>, ValueComputationRuleCall<A, R>, ? extends Value>> abstractValueSimplificationRules, @Nonnull SetMultimap<? extends AbstractValueRule<NonnullPair<Value, R>, ValueComputationRuleCall<A, R>, ? extends Value>, ? extends AbstractValueRule<NonnullPair<Value, R>, ValueComputationRuleCall<A, R>, ? extends Value>> dependsOn) {
        super(abstractValueSimplificationRules, dependsOn);
    }

    @Nonnull
    static <A, R> TransformedRules<A, R> fromSimplificationRules(@Nonnull Set<ValueSimplificationRule<? extends Value>> simplificationRules, @Nonnull SetMultimap<ValueSimplificationRule<? extends Value>, ValueSimplificationRule<? extends Value>> simplificationDependsOn, @Nonnull ValueComputationRule.OnMatchComputationFunction<A, R> computationFunction) {
        LinkedIdentityMap simplificationToComputationRulesMap = new LinkedIdentityMap();
        for (ValueSimplificationRule<? extends Value> simplificationRule : simplificationRules) {
            simplificationToComputationRulesMap.put(simplificationRule, ValueComputationRule.fromSimplificationRule(simplificationRule, computationFunction));
        }
        ImmutableSetMultimap.Builder computationDependsOnBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : simplificationDependsOn.entries()) {
            computationDependsOnBuilder.put(Objects.requireNonNull((ValueComputationRule)simplificationToComputationRulesMap.get(entry.getKey())), Objects.requireNonNull(simplificationToComputationRulesMap.get(entry.getValue())));
        }
        return new TransformedRules((Set<ValueSimplificationRule<? extends Value>>)((Set<ValueSimplificationRule<Value>>)simplificationRules), (SetMultimap<ValueSimplificationRule<? extends Value>, ValueSimplificationRule<? extends Value>>)((SetMultimap<ValueSimplificationRule<Value>, ValueSimplificationRule<Value>>)simplificationDependsOn), ImmutableSet.copyOf(simplificationToComputationRulesMap.values()), computationDependsOnBuilder.build(), simplificationToComputationRulesMap);
    }

    public static class TransformedRules<A, R> {
        @Nonnull
        private final Set<ValueSimplificationRule<? extends Value>> simplificationRules;
        @Nonnull
        private final SetMultimap<ValueSimplificationRule<? extends Value>, ValueSimplificationRule<? extends Value>> simplificationDependsOn;
        @Nonnull
        private final Set<ValueComputationRule<A, R, ? extends Value>> computationRules;
        @Nonnull
        private final SetMultimap<ValueComputationRule<A, R, ? extends Value>, ValueComputationRule<A, R, ? extends Value>> computationDependsOn;
        @Nonnull
        private final LinkedIdentityMap<ValueSimplificationRule<? extends Value>, ValueComputationRule<A, R, ? extends Value>> simplificationToComputationRulesMap;

        public TransformedRules(@Nonnull Set<ValueSimplificationRule<? extends Value>> simplificationRules, @Nonnull SetMultimap<ValueSimplificationRule<? extends Value>, ValueSimplificationRule<? extends Value>> simplificationDependsOn, @Nonnull Set<ValueComputationRule<A, R, ? extends Value>> computationRules, @Nonnull SetMultimap<ValueComputationRule<A, R, ? extends Value>, ValueComputationRule<A, R, ? extends Value>> computationDependsOn, @Nonnull LinkedIdentityMap<ValueSimplificationRule<? extends Value>, ValueComputationRule<A, R, ? extends Value>> simplificationToComputationRulesMap) {
            this.simplificationRules = simplificationRules;
            this.simplificationDependsOn = simplificationDependsOn;
            this.computationRules = computationRules;
            this.computationDependsOn = computationDependsOn;
            this.simplificationToComputationRulesMap = simplificationToComputationRulesMap;
        }

        @Nonnull
        public Set<ValueSimplificationRule<? extends Value>> getSimplificationRules() {
            return this.simplificationRules;
        }

        @Nonnull
        public SetMultimap<ValueSimplificationRule<? extends Value>, ValueSimplificationRule<? extends Value>> getSimplificationDependsOn() {
            return this.simplificationDependsOn;
        }

        @Nonnull
        public Set<ValueComputationRule<A, R, ? extends Value>> getComputationRules() {
            return this.computationRules;
        }

        @Nonnull
        public SetMultimap<ValueComputationRule<A, R, ? extends Value>, ValueComputationRule<A, R, ? extends Value>> getComputationDependsOn() {
            return this.computationDependsOn;
        }
    }
}

