/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.translation;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Constrained;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedRecordValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.MaxMatchMapSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.Simplification;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxMatchMap {
    private static final Logger logger = LoggerFactory.getLogger(MaxMatchMap.class);
    @Nonnull
    private final Map<Value, Value> mapping;
    @Nonnull
    private final Value queryValue;
    @Nonnull
    private final Value candidateValue;
    @Nonnull
    private final Set<CorrelationIdentifier> rangedOverAliases;
    @Nonnull
    private final QueryPlanConstraint queryPlanConstraint;
    @Nonnull
    private final ValueEquivalence valueEquivalence;

    MaxMatchMap(@Nonnull Map<Value, Value> mapping, @Nonnull Value queryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases, @Nonnull QueryPlanConstraint queryPlanConstraint, @Nonnull ValueEquivalence valueEquivalence) {
        this.mapping = ImmutableMap.copyOf(mapping);
        this.queryValue = queryValue;
        this.candidateValue = candidateValue;
        this.rangedOverAliases = ImmutableSet.copyOf(rangedOverAliases);
        this.queryPlanConstraint = queryPlanConstraint;
        this.valueEquivalence = valueEquivalence;
    }

    @Nonnull
    public Map<Value, Value> getMap() {
        return this.mapping;
    }

    @Nonnull
    public Value getQueryValue() {
        return this.queryValue;
    }

    @Nonnull
    public Value getCandidateValue() {
        return this.candidateValue;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getRangedOverAliases() {
        return this.rangedOverAliases;
    }

    @Nonnull
    public QueryPlanConstraint getQueryPlanConstraint() {
        return this.queryPlanConstraint;
    }

    @Nonnull
    public ValueEquivalence getValueEquivalence() {
        return this.valueEquivalence;
    }

    @Nonnull
    public Optional<Value> translateQueryValueMaybe(@Nonnull CorrelationIdentifier candidateAlias) {
        Value candidateValue = this.getCandidateValue();
        Map<Value, Value> pulledUpCandidateValueMap = candidateValue.pullUp(ImmutableSet.copyOf(this.mapping.values()), EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), candidateAlias);
        ImmutableMap.Builder<Value, Value> pulledUpMaxMatchMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Value, Value> entry : this.mapping.entrySet()) {
            Value queryPart = entry.getKey();
            Value candidatePart = entry.getValue();
            Value pulledUpdateCandidatePart = pulledUpCandidateValueMap.get(candidatePart);
            if (pulledUpdateCandidatePart == null) {
                return Optional.empty();
            }
            pulledUpMaxMatchMapBuilder.put(queryPart, pulledUpdateCandidatePart);
        }
        ImmutableMap pulledUpMaxMatchMap = pulledUpMaxMatchMapBuilder.build();
        Value queryResultValueFromBelow = this.getQueryValue();
        Value translatedQueryResultValue = Objects.requireNonNull((Value)queryResultValueFromBelow.replace(value -> {
            Value maxMatchValue = (Value)pulledUpMaxMatchMap.get(value);
            return maxMatchValue == null ? value : maxMatchValue;
        }));
        if (!Sets.intersection(this.rangedOverAliases, translatedQueryResultValue.getCorrelatedTo()).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(translatedQueryResultValue);
    }

    @Nonnull
    public Optional<MaxMatchMap> adjustMaybe(@Nonnull CorrelationIdentifier upperCandidateAlias, @Nonnull Value upperCandidateResultValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
        Optional<Value> translatedQueryValueOptional = this.translateQueryValueMaybe(upperCandidateAlias);
        return translatedQueryValueOptional.map(value -> MaxMatchMap.compute(value, upperCandidateResultValue, rangedOverAliases));
    }

    @Nonnull
    public Optional<RegularTranslationMap> pullUpMaybe(@Nonnull CorrelationIdentifier queryAlias, @Nonnull CorrelationIdentifier candidateAlias) {
        Optional<Value> translatedQueryValueOptional = this.translateQueryValueMaybe(candidateAlias);
        return translatedQueryValueOptional.map(translatedQueryValue -> RegularTranslationMap.builder().when(queryAlias).then(TranslationMap.TranslationFunction.adjustValueType(translatedQueryValue)).build());
    }

    public String toString() {
        return "M\u00b3(mapping=" + String.valueOf(this.mapping) + ", queryValue=" + String.valueOf(this.queryValue) + ", candidateValue=" + String.valueOf(this.candidateValue) + ", queryPlanConstraint=" + String.valueOf(this.queryPlanConstraint) + ")";
    }

    @Nonnull
    public static MaxMatchMap compute(@Nonnull Value queryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
        return MaxMatchMap.compute(queryValue, candidateValue, rangedOverAliases, ValueEquivalence.empty());
    }

    @Nonnull
    public static MaxMatchMap compute(@Nonnull Value queryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases, @Nonnull ValueEquivalence valueEquivalence) {
        return MaxMatchMap.compute(queryValue, candidateValue, rangedOverAliases, valueEquivalence, ignored -> Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static MaxMatchMap compute(@Nonnull Value queryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases, @Nonnull ValueEquivalence valueEquivalence, @Nonnull Function<Value, Optional<Value>> unmatchedHandlerFunction) {
        if (logger.isTraceEnabled()) {
            logger.trace("calculate begin queryValue={}, candidateValue={}", (Object)queryValue, (Object)candidateValue);
        }
        MaxMatchMap bestMaxMatchMap = null;
        try {
            Optional<MaxMatchMap> maxMatchOptional = MaxMatchMap.shortCircuitMaybe(queryValue, candidateValue, rangedOverAliases, valueEquivalence);
            if (maxMatchOptional.isPresent()) {
                MaxMatchMap maxMatchMap = maxMatchOptional.get();
                return maxMatchMap;
            }
            Map<Value, MatchResult> resultsMap = MaxMatchMap.recurseQueryResultValue(queryValue, candidateValue, rangedOverAliases, valueEquivalence, unmatchedHandlerFunction, new IdentityHashMap<Value, Map<Value, MatchResult>>(), -1, new ArrayDeque<IncrementalValueMatcher>(), Integer.MAX_VALUE, new HashSet<Value>());
            int currentMaxDepth = Integer.MAX_VALUE;
            for (Map.Entry<Value, MatchResult> resultEntry : resultsMap.entrySet()) {
                MatchResult result = resultEntry.getValue();
                if (result.getMaxDepth() >= currentMaxDepth) continue;
                bestMaxMatchMap = new MaxMatchMap(result.getValueMap(), resultEntry.getKey(), candidateValue, rangedOverAliases, result.getQueryPlanConstraint(), valueEquivalence);
                currentMaxDepth = result.getMaxDepth();
            }
            if (bestMaxMatchMap == null) {
                bestMaxMatchMap = new MaxMatchMap(ImmutableMap.of(), queryValue, candidateValue, rangedOverAliases, QueryPlanConstraint.noConstraint(), valueEquivalence);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace("calculate end bestMaxMatchMap={}", (Object)bestMaxMatchMap);
            }
        }
        return bestMaxMatchMap;
    }

    @Nonnull
    private static Optional<MaxMatchMap> shortCircuitMaybe(@Nonnull Value queryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases, @Nonnull ValueEquivalence valueEquivalence) {
        if (rangedOverAliases.size() != 1) {
            return Optional.empty();
        }
        CorrelationIdentifier singularRangedOverAlias = Iterables.getOnlyElement(rangedOverAliases);
        if (!(candidateValue instanceof QuantifiedObjectValue) || !((QuantifiedObjectValue)candidateValue).getAlias().equals(singularRangedOverAlias)) {
            return Optional.empty();
        }
        if (!queryValue.getCorrelatedTo().contains(singularRangedOverAlias)) {
            return Optional.empty();
        }
        for (Value value : queryValue.preOrderIterable()) {
            if (!(value instanceof QuantifiedValue) || value instanceof QuantifiedObjectValue) continue;
            return Optional.empty();
        }
        return Optional.of(new MaxMatchMap(ImmutableMap.of(candidateValue, candidateValue), queryValue, candidateValue, rangedOverAliases, QueryPlanConstraint.noConstraint(), valueEquivalence));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static Map<Value, MatchResult> recurseQueryResultValue(@Nonnull Value currentQueryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases, @Nonnull ValueEquivalence valueEquivalence, @Nonnull Function<Value, Optional<Value>> unmatchedHandlerFunction, @Nonnull IdentityHashMap<Value, Map<Value, MatchResult>> knownValueMap, int descendOrdinal, @Nonnull Deque<IncrementalValueMatcher> matchers, int maxDepthBound, @Nonnull Set<Value> expandedValues) {
        if (maxDepthBound == 0) {
            return ImmutableMap.of(currentQueryValue, MatchResult.notMatched());
        }
        ArrayDeque<IncrementalValueMatcher> localMatchers = new ArrayDeque<IncrementalValueMatcher>();
        boolean anyParentsMatching = false;
        if (descendOrdinal >= 0) {
            for (IncrementalValueMatcher matcher : matchers) {
                anyParentsMatching |= matcher.anyMatches();
                IncrementalValueMatcher descendedMatcher = matcher.descend(currentQueryValue, descendOrdinal);
                localMatchers.addLast(descendedMatcher);
            }
        }
        if (!anyParentsMatching && knownValueMap.containsKey(currentQueryValue)) {
            if (logger.isTraceEnabled()) {
                logger.trace("getting memoized info value={}", (Object)currentQueryValue);
            }
            return knownValueMap.get(currentQueryValue);
        }
        IncrementalValueMatcher currentMatcher = IncrementalValueMatcher.initial(currentQueryValue, candidateValue);
        localMatchers.push(currentMatcher);
        boolean isCurrentMatching = currentMatcher.anyMatches();
        BestMatches bestMatches = new BestMatches(currentQueryValue, !anyParentsMatching);
        Iterable children = currentQueryValue.getChildren();
        if (Iterables.isEmpty(children)) {
            MatchResult resultForCurrent = MaxMatchMap.computeForCurrent(maxDepthBound, currentQueryValue, candidateValue, rangedOverAliases, valueEquivalence, unmatchedHandlerFunction, ImmutableList.of());
            bestMatches.put(currentQueryValue, resultForCurrent);
        } else {
            ConstrainedBoolean isFound;
            if (!anyParentsMatching && isCurrentMatching) {
                Pair<ConstrainedBoolean, Value> matchingPair = MaxMatchMap.findMatchingReachableCandidateValue(currentQueryValue, candidateValue, valueEquivalence, unmatchedHandlerFunction);
                isFound = Objects.requireNonNull(matchingPair.getLeft());
                if (isFound.isTrue()) {
                    bestMatches.put(currentQueryValue, MatchResult.of(ImmutableMap.of(currentQueryValue, Objects.requireNonNull(matchingPair.getRight())), 0, isFound.getConstraint()));
                }
            } else {
                isFound = ConstrainedBoolean.falseValue();
            }
            if (isFound.isFalse()) {
                int childrenMaxDepthBound = maxDepthBound == Integer.MAX_VALUE || localMatchers.stream().anyMatch(IncrementalValueMatcher::anyMatches) ? Integer.MAX_VALUE : maxDepthBound - 1;
                ImmutableList.Builder childrenResultsBuilder = ImmutableList.builder();
                int i = 0;
                for (Object child : children) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("recursing into child max_depth_bound={}, value={}", (Object)childrenMaxDepthBound, child);
                    }
                    Map<Value, MatchResult> map = MaxMatchMap.recurseQueryResultValue((Value)child, candidateValue, rangedOverAliases, valueEquivalence, unmatchedHandlerFunction, knownValueMap, i, localMatchers, childrenMaxDepthBound, expandedValues);
                    childrenResultsBuilder.add(map.entrySet());
                    ++i;
                }
                ImmutableCollection childrenResults = childrenResultsBuilder.build();
                for (List list : CrossProduct.crossProduct(childrenResults)) {
                    boolean areAllChildrenSame = true;
                    ImmutableList.Builder childrenValuesBuilder = ImmutableList.builder();
                    i = 0;
                    for (Value child : children) {
                        Map.Entry childrenResultsEntry;
                        Value key;
                        if (child != (key = (Value)(childrenResultsEntry = (Map.Entry)list.get(i)).getKey())) {
                            areAllChildrenSame = false;
                        }
                        childrenValuesBuilder.add(key);
                        ++i;
                    }
                    Verify.verify(i == list.size());
                    Value resultQueryValue = !areAllChildrenSame ? (Value)currentQueryValue.withChildren(childrenValuesBuilder.build()) : currentQueryValue;
                    MatchResult resultForCurrent = MaxMatchMap.computeForCurrent(maxDepthBound, resultQueryValue, candidateValue, rangedOverAliases, valueEquivalence, unmatchedHandlerFunction, list);
                    bestMatches.put(resultQueryValue, resultForCurrent);
                }
            }
        }
        Verify.verify(!bestMatches.isEmpty());
        Verify.verify(bestMatches.getCurrentMaxDepth() >= 0);
        if ((anyParentsMatching || bestMatches.getCurrentMaxDepth() > 0) && !expandedValues.contains(currentQueryValue)) {
            try {
                expandedValues.add(currentQueryValue);
                List<Constrained<Value>> constrainedExpandedCurrentQueryValues = Simplification.simplifyCurrent(currentQueryValue, EvaluationContext.empty(), AliasMap.emptyMap(), rangedOverAliases, MaxMatchMapSimplificationRuleSet.instance());
                for (Constrained<Value> constrainedExpandedCurrentQueryValue : constrainedExpandedCurrentQueryValues) {
                    int currentMaxDepthBound;
                    Value expandedCurrentQueryValue = constrainedExpandedCurrentQueryValue.getUnconstrained();
                    int n = anyParentsMatching ? Integer.MAX_VALUE : (currentMaxDepthBound = bestMatches.getCurrentMaxDepth() == Integer.MAX_VALUE ? maxDepthBound : bestMatches.getCurrentMaxDepth());
                    if (logger.isTraceEnabled()) {
                        logger.trace("recursing into variant max_depth_bound={}, value={}", (Object)currentMaxDepthBound, (Object)expandedCurrentQueryValue);
                    }
                    Map<Value, MatchResult> expandedResultsMap = MaxMatchMap.recurseQueryResultValue(expandedCurrentQueryValue, candidateValue, rangedOverAliases, valueEquivalence, unmatchedHandlerFunction, knownValueMap, descendOrdinal, matchers, currentMaxDepthBound, expandedValues);
                    for (Map.Entry<Value, MatchResult> expandedResultsEntry : expandedResultsMap.entrySet()) {
                        bestMatches.put(expandedResultsEntry.getKey(), expandedResultsEntry.getValue());
                    }
                }
            }
            finally {
                expandedValues.remove(currentQueryValue);
            }
        }
        Verify.verify(bestMatches.getCurrentMaxDepth() == Integer.MAX_VALUE || bestMatches.getCurrentMaxDepth() <= maxDepthBound);
        Map<Value, MatchResult> resultMap = bestMatches.toResultMap();
        if (!anyParentsMatching && !expandedValues.contains(currentQueryValue)) {
            if (logger.isTraceEnabled()) {
                logger.trace("memoizing value={}", (Object)currentQueryValue);
            }
            knownValueMap.put(currentQueryValue, resultMap);
        }
        return resultMap;
    }

    @Nonnull
    private static MatchResult computeForCurrent(int maxDepthBound, @Nonnull Value resultQueryValue, @Nonnull Value candidateValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases, @Nonnull ValueEquivalence valueEquivalence, @Nonnull Function<Value, Optional<Value>> unmatchedHandlerFunction, @Nonnull List<Map.Entry<Value, MatchResult>> childrenResultEntries) {
        Verify.verify(maxDepthBound > 0);
        Pair<ConstrainedBoolean, Value> matchingPair = MaxMatchMap.findMatchingReachableCandidateValue(resultQueryValue, candidateValue, valueEquivalence, unmatchedHandlerFunction);
        ConstrainedBoolean isFound = Objects.requireNonNull(matchingPair.getLeft());
        if (isFound.isTrue()) {
            return MatchResult.of(ImmutableMap.of(resultQueryValue, Objects.requireNonNull(matchingPair.getRight())), 0, isFound.getConstraint());
        }
        QueryPlanConstraint childrenConstraint = QueryPlanConstraint.noConstraint();
        LinkedHashMap<Value, Value> childrenResultsMap = new LinkedHashMap<Value, Value>();
        int childrenMaxDepth = -1;
        for (Map.Entry<Value, MatchResult> childrenResultsEntry : childrenResultEntries) {
            Value childValue = childrenResultsEntry.getKey();
            MatchResult childResult = childrenResultsEntry.getValue();
            Map<Value, Value> childValueMap = childResult.getValueMap();
            if (childValueMap.isEmpty()) {
                if (!Sets.intersection(childValue.getCorrelatedTo(), rangedOverAliases).isEmpty()) {
                    return MatchResult.notMatched();
                }
                childrenMaxDepth = Math.max(childrenMaxDepth, 0);
            } else {
                childrenMaxDepth = Math.max(childrenMaxDepth, childResult.getMaxDepth());
            }
            if (maxDepthBound < Integer.MAX_VALUE && maxDepthBound - 1 < childrenMaxDepth) {
                return MatchResult.notMatched();
            }
            childrenResultsMap.putAll(childValueMap);
            childrenConstraint = childrenConstraint.compose(childResult.getQueryPlanConstraint());
        }
        childrenMaxDepth = childrenMaxDepth == -1 ? Integer.MAX_VALUE : childrenMaxDepth;
        return MatchResult.of(childrenResultsMap, childrenMaxDepth == Integer.MAX_VALUE ? Integer.MAX_VALUE : childrenMaxDepth + 1, childrenConstraint);
    }

    @Nonnull
    private static Pair<ConstrainedBoolean, Value> findMatchingReachableCandidateValue(@Nonnull Value currentQueryValue, @Nonnull Value candidateValue, @Nonnull ValueEquivalence valueEquivalence, @Nonnull Function<Value, Optional<Value>> unmatchedHandlerFunction) {
        for (Value currentCandidateValue : candidateValue.preOrderIterable(v -> v instanceof RecordConstructorValue)) {
            if (currentCandidateValue == candidateValue && currentQueryValue instanceof QuantifiedRecordValue) {
                return Pair.of(ConstrainedBoolean.alwaysTrue(), currentCandidateValue);
            }
            ConstrainedBoolean semanticEquals = currentQueryValue.semanticEquals((Object)currentCandidateValue, valueEquivalence);
            if (!semanticEquals.isTrue()) continue;
            return Pair.of(semanticEquals, currentCandidateValue);
        }
        Optional<Value> unmatchedHandlerResult = unmatchedHandlerFunction.apply(currentQueryValue);
        return unmatchedHandlerResult.map(value -> Pair.of(ConstrainedBoolean.alwaysTrue(), value)).orElseGet(() -> Pair.of(ConstrainedBoolean.falseValue(), null));
    }

    private static class MatchResult {
        private static final MatchResult NOT_MATCHED = new MatchResult(ImmutableMap.of(), Integer.MAX_VALUE, QueryPlanConstraint.noConstraint());
        @Nonnull
        private final Map<Value, Value> valueMap;
        private final int maxDepth;
        @Nonnull
        private final QueryPlanConstraint queryPlanConstraint;

        private MatchResult(@Nonnull Map<Value, Value> valueMap, int maxDepth, @Nonnull QueryPlanConstraint queryPlanConstraint) {
            this.valueMap = valueMap;
            this.queryPlanConstraint = queryPlanConstraint;
            this.maxDepth = maxDepth;
        }

        @Nonnull
        public Map<Value, Value> getValueMap() {
            return this.valueMap;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isMatched() {
            return this.maxDepth < Integer.MAX_VALUE;
        }

        @Nonnull
        public QueryPlanConstraint getQueryPlanConstraint() {
            return this.queryPlanConstraint;
        }

        public static MatchResult of(@Nonnull Map<Value, Value> valueMap, int maxDepth, @Nonnull QueryPlanConstraint queryPlanConstraint) {
            Verify.verify(maxDepth >= 0);
            return new MatchResult(valueMap, maxDepth, queryPlanConstraint);
        }

        public static MatchResult notMatched() {
            return NOT_MATCHED;
        }
    }

    private static abstract class IncrementalValueMatcher {
        private static final ExplainTokensWithPrecedence UNMATCHED = ExplainTokensWithPrecedence.of(new ExplainTokens().addToString("\u25a0"));
        @Nonnull
        private final Value currentQueryValue;
        @Nonnull
        private final Supplier<List<NonnullPair<Value, QueryPlanConstraint>>> matchingCandidateValuesSupplier;

        private IncrementalValueMatcher(@Nonnull Value currentQueryValue) {
            this.currentQueryValue = currentQueryValue;
            this.matchingCandidateValuesSupplier = Suppliers.memoize(this::computeMatchingCandidateValues);
        }

        @Nonnull
        public Value getCurrentQueryValue() {
            return this.currentQueryValue;
        }

        @Nonnull
        public List<NonnullPair<Value, QueryPlanConstraint>> getMatchingCandidateValues() {
            return this.matchingCandidateValuesSupplier.get();
        }

        @Nonnull
        public abstract List<NonnullPair<Value, QueryPlanConstraint>> computeMatchingCandidateValues();

        @Nonnull
        public abstract ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> var1);

        public boolean anyMatches() {
            return !this.getMatchingCandidateValues().isEmpty();
        }

        public String toString() {
            ExplainTokens explainTokens = this.explain(Collections.nCopies(Iterables.size(this.currentQueryValue.getChildren()), () -> UNMATCHED)).getExplainTokens();
            String explainString = explainTokens.render(DefaultExplainFormatter.forDebugging()).toString();
            return this.anyMatches() ? explainString : explainString + " \u2192 \u2205";
        }

        @Nonnull
        public IncrementalValueMatcher descend(final @Nonnull Value currentQueryValue, final int descendOrdinal) {
            final IncrementalValueMatcher parent = this;
            return new IncrementalValueMatcher(currentQueryValue){

                @Override
                @Nonnull
                public List<NonnullPair<Value, QueryPlanConstraint>> computeMatchingCandidateValues() {
                    ImmutableList.Builder matchingCandidateValuesBuilder = ImmutableList.builder();
                    for (NonnullPair<Value, QueryPlanConstraint> matchingCandidateValuePair : parent.getMatchingCandidateValues()) {
                        ConstrainedBoolean currentEqualsWithoutChildren;
                        Value currentCandidateValue = Iterables.get(matchingCandidateValuePair.getLeft().getChildren(), descendOrdinal, null);
                        if (currentCandidateValue == null || !(currentEqualsWithoutChildren = currentQueryValue.equalsWithoutChildren(currentCandidateValue)).isTrue()) continue;
                        matchingCandidateValuesBuilder.add(NonnullPair.of(currentCandidateValue, matchingCandidateValuePair.getRight().compose(currentEqualsWithoutChildren.getConstraint())));
                    }
                    return matchingCandidateValuesBuilder.build();
                }

                @Override
                @Nonnull
                public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
                    Verify.verify(Iterables.size(explainSuppliers) == Iterables.size(currentQueryValue.getChildren()));
                    ImmutableList.Builder parentExplainFunctionsBuilder = ImmutableList.builder();
                    int parentSize = Iterables.size(parent.getCurrentQueryValue().getChildren());
                    for (int i = 0; i < parentSize; ++i) {
                        if (i != descendOrdinal) {
                            parentExplainFunctionsBuilder.add(() -> UNMATCHED);
                            continue;
                        }
                        parentExplainFunctionsBuilder.add(() -> currentQueryValue.explain(explainSuppliers));
                    }
                    return parent.explain(parentExplainFunctionsBuilder.build());
                }
            };
        }

        @Nonnull
        public static IncrementalValueMatcher initial(@Nonnull Value queryRootValue, final @Nonnull Value candidateRootValue) {
            return new IncrementalValueMatcher(queryRootValue){

                @Override
                @Nonnull
                public List<NonnullPair<Value, QueryPlanConstraint>> computeMatchingCandidateValues() {
                    return Streams.stream(candidateRootValue.preOrderIterable(candidateValue -> candidateValue instanceof RecordConstructorValue)).flatMap(candidateValue -> {
                        if (candidateValue == candidateRootValue && this.getCurrentQueryValue() instanceof QuantifiedRecordValue) {
                            return Stream.of(NonnullPair.of(candidateValue, QueryPlanConstraint.noConstraint()));
                        }
                        return this.getCurrentQueryValue().equalsWithoutChildren((Value)candidateValue).mapToOptional(Function.identity()).stream().map(queryPlanConstraint -> NonnullPair.of(candidateValue, queryPlanConstraint));
                    }).collect(ImmutableList.toImmutableList());
                }

                @Override
                @Nonnull
                public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
                    return this.getCurrentQueryValue().explain(explainSuppliers);
                }
            };
        }
    }

    private static class BestMatches {
        @Nonnull
        private final Value currentQueryValue;
        private final boolean isPruning;
        private int currentMaxDepth = -1;
        @Nullable
        private Map<Value, MatchResult> matchMap;
        @Nullable
        private Value value;
        @Nullable
        private MatchResult matchResult;

        public BestMatches(@Nonnull Value currentQueryValue, boolean isPruning) {
            this.currentQueryValue = currentQueryValue;
            this.isPruning = isPruning;
            if (!isPruning) {
                this.matchMap = new LinkedHashMap<Value, MatchResult>();
            }
        }

        public boolean isPruning() {
            return this.isPruning;
        }

        public boolean isEmpty() {
            return this.getCurrentMaxDepth() == -1;
        }

        public int getCurrentMaxDepth() {
            return this.currentMaxDepth;
        }

        @Nonnull
        private Map<Value, MatchResult> getMatchMap() {
            return Objects.requireNonNull(this.matchMap);
        }

        @Nonnull
        public Value getValue() {
            return Objects.requireNonNull(this.value);
        }

        @Nonnull
        public MatchResult getMatchResult() {
            return Objects.requireNonNull(this.matchResult);
        }

        @Nonnull
        public Map<Value, MatchResult> toResultMap() {
            if (this.isEmpty()) {
                return ImmutableMap.of(this.currentQueryValue, MatchResult.notMatched());
            }
            if (this.isPruning()) {
                return ImmutableMap.of(this.getValue(), this.getMatchResult());
            }
            return this.getMatchMap();
        }

        public void put(@Nonnull Value newQueryValue, @Nonnull MatchResult newMatchResult) {
            if (this.isPruning()) {
                if (this.matchResult == null || newMatchResult.getMaxDepth() < this.currentMaxDepth) {
                    this.value = newQueryValue;
                    this.matchResult = newMatchResult;
                    this.currentMaxDepth = newMatchResult.getMaxDepth();
                }
            } else {
                if (this.currentMaxDepth == -1 || newMatchResult.getMaxDepth() < this.currentMaxDepth) {
                    this.currentMaxDepth = newMatchResult.getMaxDepth();
                }
                this.getMatchMap().put(newQueryValue, newMatchResult);
            }
        }
    }
}

