/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.translation;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitorWithDefaults;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullUp {
    @Nullable
    private final PullUp parentPullUp;
    @Nonnull
    private final CorrelationIdentifier candidateAlias;
    @Nonnull
    private final Value pullThroughValue;
    @Nonnull
    private final Set<CorrelationIdentifier> rangedOverAliases;
    @Nonnull
    private final PullUp rootPullUp;

    private PullUp(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias, @Nonnull Value pullThroughValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
        this.parentPullUp = parentPullUp;
        this.candidateAlias = candidateAlias;
        this.pullThroughValue = pullThroughValue;
        this.rangedOverAliases = ImmutableSet.copyOf(rangedOverAliases);
        this.rootPullUp = parentPullUp == null ? this : parentPullUp.getRootPullUp();
    }

    @Nullable
    public PullUp getParentPullUp() {
        return this.parentPullUp;
    }

    @Nonnull
    public PullUp getRootPullUp() {
        return this.rootPullUp;
    }

    @Nonnull
    public CorrelationIdentifier getCandidateAlias() {
        return this.candidateAlias;
    }

    public boolean isRoot() {
        return this.parentPullUp == null;
    }

    @Nonnull
    public Value getPullThroughValue() {
        return this.pullThroughValue;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getRangedOverAliases() {
        return this.rangedOverAliases;
    }

    @Nonnull
    private static PullUp forMatch(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias, @Nonnull CorrelationIdentifier lowerAlias, @Nonnull Type lowerType, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
        return PullUp.forMatch(parentPullUp, candidateAlias, QuantifiedObjectValue.of(lowerAlias, lowerType), rangedOverAliases);
    }

    @Nonnull
    private static PullUp forMatch(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias, @Nonnull Value lowerPullThroughValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
        return new MatchPullUp(parentPullUp, candidateAlias, lowerPullThroughValue, rangedOverAliases);
    }

    @Nonnull
    public static UnificationPullUp forUnification(@Nonnull CorrelationIdentifier candidateAlias, @Nonnull Value lowerPullThroughValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
        return new UnificationPullUp(null, candidateAlias, lowerPullThroughValue, rangedOverAliases);
    }

    @Nonnull
    public Optional<Value> pullUpValueMaybe(@Nonnull Value value) {
        Value currentValue = value;
        PullUp currentPullUp = this;
        MaxMatchMap maxMatchMap;
        Optional<Value> currentValueOptional;
        while (!(currentValueOptional = (maxMatchMap = MaxMatchMap.compute(currentValue, currentPullUp.getPullThroughValue(), currentPullUp.getRangedOverAliases())).translateQueryValueMaybe(currentPullUp.getCandidateAlias())).isEmpty()) {
            currentValue = currentValueOptional.get().simplify(EvaluationContext.empty(), AliasMap.emptyMap(), currentPullUp.getRangedOverAliases());
            if (currentPullUp.getParentPullUp() == null) {
                return Optional.of(currentValue);
            }
            currentPullUp = currentPullUp.getParentPullUp();
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Value> pullUpCandidateValueMaybe(@Nonnull Value value) {
        Value currentValue = value;
        PullUp currentPullUp = this;
        while (true) {
            Value currentPullThroughValue = currentPullUp.getPullThroughValue();
            Set<CorrelationIdentifier> currentRangedOverAliases = currentPullUp.getRangedOverAliases();
            CorrelationIdentifier currentCandidateAlias = currentPullUp.getCandidateAlias();
            Map<Value, Value> candidatePullUpMap = currentPullThroughValue.pullUp(ImmutableList.of(currentValue), EvaluationContext.empty(), AliasMap.emptyMap(), Sets.difference(currentValue.getCorrelatedToWithoutChildren(), currentRangedOverAliases), currentCandidateAlias);
            Value pulledUpCandidateAggregateValue = candidatePullUpMap.get(currentValue);
            if (pulledUpCandidateAggregateValue == null) {
                return Optional.empty();
            }
            currentValue = pulledUpCandidateAggregateValue;
            if (currentPullUp.getParentPullUp() == null) {
                return Optional.of(currentValue);
            }
            currentPullUp = currentPullUp.getParentPullUp();
        }
    }

    @Nonnull
    public static RelationalExpressionVisitor<PullUp> visitor(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        return new PullUpVisitor(parentPullUp, candidateAlias);
    }

    public static class MatchPullUp
    extends PullUp {
        public MatchPullUp(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias, @Nonnull Value pullThroughValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
            super(parentPullUp, candidateAlias, pullThroughValue, rangedOverAliases);
        }
    }

    public static class UnificationPullUp
    extends PullUp {
        public UnificationPullUp(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias, @Nonnull Value pullThroughValue, @Nonnull Set<CorrelationIdentifier> rangedOverAliases) {
            super(parentPullUp, candidateAlias, pullThroughValue, rangedOverAliases);
        }
    }

    private static class PullUpVisitor
    implements RelationalExpressionVisitorWithDefaults<PullUp> {
        @Nullable
        private final PullUp parentPullUp;
        @Nonnull
        private final CorrelationIdentifier candidateAlias;

        public PullUpVisitor(@Nullable PullUp parentPullUp, @Nonnull CorrelationIdentifier candidateAlias) {
            this.parentPullUp = parentPullUp;
            this.candidateAlias = candidateAlias;
        }

        @Override
        @Nonnull
        public PullUp visitLogicalTypeFilterExpression(@Nonnull LogicalTypeFilterExpression logicalTypeFilterExpression) {
            return PullUp.forMatch(this.parentPullUp, this.candidateAlias, logicalTypeFilterExpression.getInnerQuantifier().getAlias(), logicalTypeFilterExpression.getInnerQuantifier().getFlowedObjectType(), Quantifiers.aliases(logicalTypeFilterExpression.getQuantifiers()));
        }

        @Override
        @Nonnull
        public PullUp visitDefault(@Nonnull RelationalExpression relationalExpression) {
            return PullUp.forMatch(this.parentPullUp, this.candidateAlias, relationalExpression.getResultValue(), Quantifiers.aliases(relationalExpression.getQuantifiers()));
        }
    }
}

