/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.translation;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RegularTranslationMap
implements TranslationMap {
    @Nonnull
    private static final RegularTranslationMap EMPTY = new RegularTranslationMap(ImmutableMap.of());
    @Nonnull
    private final Map<CorrelationIdentifier, TranslationMap.TranslationFunction> aliasToFunctionMap;

    private RegularTranslationMap(@Nonnull Map<CorrelationIdentifier, TranslationMap.TranslationFunction> aliasToFunctionMap) {
        this.aliasToFunctionMap = ImmutableMap.copyOf(aliasToFunctionMap);
    }

    @Override
    @Nonnull
    public Optional<AliasMap> getAliasMapMaybe() {
        return Optional.empty();
    }

    @Override
    public boolean definesOnlyIdentities() {
        return this.getAliasMapMaybe().map(AliasMap::definesOnlyIdentities).orElseGet(this.aliasToFunctionMap::isEmpty);
    }

    @Override
    public boolean containsSourceAlias(@Nullable CorrelationIdentifier sourceAlias) {
        return this.aliasToFunctionMap.containsKey(sourceAlias);
    }

    @Override
    @Nullable
    public CorrelationIdentifier getTarget(@Nonnull CorrelationIdentifier sourceAlias) {
        AliasMap aliasMap = this.getAliasMapMaybe().orElse(null);
        if (aliasMap == null) {
            throw new RecordCoreException("translation map is not backed by an alias map", new Object[0]);
        }
        return aliasMap.getTarget(sourceAlias);
    }

    @Override
    @Nonnull
    public Value applyTranslationFunction(@Nonnull CorrelationIdentifier sourceAlias, @Nonnull LeafValue leafValue) {
        TranslationMap.TranslationFunction translationFunction = Preconditions.checkNotNull(this.aliasToFunctionMap.get(sourceAlias));
        return translationFunction.apply(sourceAlias, leafValue);
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this.aliasToFunctionMap);
    }

    @Nonnull
    public static RegularTranslationMap empty() {
        return EMPTY;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static RegularTranslationMap rebaseWithAliasMap(@Nonnull AliasMap aliasMap) {
        ImmutableMap.Builder<CorrelationIdentifier, TranslationMap.TranslationFunction> translationMapBuilder = ImmutableMap.builder();
        for (Map.Entry<CorrelationIdentifier, CorrelationIdentifier> entry : aliasMap.entrySet()) {
            translationMapBuilder.put(entry.getKey(), (sourceAlias, leafValue) -> leafValue.rebaseLeaf((CorrelationIdentifier)entry.getValue()));
        }
        return new AliasMapBasedTranslationMap(translationMapBuilder.build(), aliasMap);
    }

    @Nonnull
    public static RegularTranslationMap ofAliases(@Nonnull CorrelationIdentifier source, @Nonnull CorrelationIdentifier target) {
        return RegularTranslationMap.rebaseWithAliasMap(AliasMap.ofAliases(source, target));
    }

    @Nonnull
    public static RegularTranslationMap compose(@Nonnull Iterable<RegularTranslationMap> translationMaps) {
        Builder builder = RegularTranslationMap.builder();
        for (RegularTranslationMap translationMap : translationMaps) {
            builder.compose(translationMap);
        }
        return builder.build();
    }

    public static class Builder {
        @Nonnull
        private final Map<CorrelationIdentifier, TranslationMap.TranslationFunction> aliasToFunctionMap;

        private Builder() {
            this.aliasToFunctionMap = Maps.newLinkedHashMap();
        }

        private Builder(@Nonnull Map<CorrelationIdentifier, TranslationMap.TranslationFunction> aliasToFunctionMap) {
            this.aliasToFunctionMap = Maps.newLinkedHashMap(aliasToFunctionMap);
        }

        @Nonnull
        public RegularTranslationMap build() {
            if (this.aliasToFunctionMap.isEmpty()) {
                return RegularTranslationMap.empty();
            }
            return new RegularTranslationMap(this.aliasToFunctionMap);
        }

        @Nonnull
        public When when(@Nonnull CorrelationIdentifier sourceAlias) {
            return new When(sourceAlias);
        }

        @Nonnull
        public WhenAny whenAny(@Nonnull Iterable<CorrelationIdentifier> sourceAliases) {
            return new WhenAny(sourceAliases);
        }

        @Nonnull
        public Builder compose(@Nonnull RegularTranslationMap other) {
            other.aliasToFunctionMap.forEach((key, value) -> {
                Verify.verify(!this.aliasToFunctionMap.containsKey(key));
                this.aliasToFunctionMap.put((CorrelationIdentifier)key, (TranslationMap.TranslationFunction)value);
            });
            return this;
        }

        public class When {
            @Nonnull
            private final CorrelationIdentifier sourceAlias;

            public When(CorrelationIdentifier sourceAlias) {
                this.sourceAlias = sourceAlias;
            }

            @Nonnull
            public Builder then(@Nonnull TranslationMap.TranslationFunction translationFunction) {
                Builder.this.aliasToFunctionMap.put(this.sourceAlias, translationFunction);
                return Builder.this;
            }
        }

        public class WhenAny {
            @Nonnull
            private final Set<CorrelationIdentifier> sourceAliases;

            public WhenAny(Iterable<CorrelationIdentifier> sourceAliases) {
                this.sourceAliases = ImmutableSet.copyOf(sourceAliases);
            }

            @Nonnull
            public Builder then(@Nonnull TranslationMap.TranslationFunction translationFunction) {
                for (CorrelationIdentifier sourceAlias : this.sourceAliases) {
                    Builder.this.aliasToFunctionMap.put(sourceAlias, translationFunction);
                }
                return Builder.this;
            }
        }
    }

    private static class AliasMapBasedTranslationMap
    extends RegularTranslationMap {
        @Nonnull
        private final AliasMap aliasMap;

        private AliasMapBasedTranslationMap(@Nonnull Map<CorrelationIdentifier, TranslationMap.TranslationFunction> aliasToFunctionMap, @Nonnull AliasMap aliasMap) {
            super(aliasToFunctionMap);
            this.aliasMap = aliasMap;
        }

        @Override
        @Nonnull
        public Optional<AliasMap> getAliasMapMaybe() {
            return Optional.of(this.aliasMap);
        }
    }
}

