/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.translation;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ToUniqueAliasesTranslationMap
implements TranslationMap {
    @Nonnull
    private final Map<CorrelationIdentifier, CorrelationIdentifier> sourceToTargetMap = new LinkedHashMap<CorrelationIdentifier, CorrelationIdentifier>();

    @Override
    @Nonnull
    public Optional<AliasMap> getAliasMapMaybe() {
        return Optional.empty();
    }

    @Nonnull
    public AliasMap getSnapshotAliasMap() {
        return AliasMap.copyOf(this.sourceToTargetMap);
    }

    @Override
    @Nullable
    public CorrelationIdentifier getTarget(@Nonnull CorrelationIdentifier sourceAlias) {
        return this.computeTargetIfAbsent(sourceAlias);
    }

    @Override
    public boolean definesOnlyIdentities() {
        return false;
    }

    @Override
    public boolean containsSourceAlias(@Nullable CorrelationIdentifier sourceAlias) {
        return true;
    }

    @Override
    @Nonnull
    public Value applyTranslationFunction(@Nonnull CorrelationIdentifier sourceAlias, @Nonnull LeafValue leafValue) {
        return leafValue.rebaseLeaf(this.computeTargetIfAbsent(sourceAlias));
    }

    @Nonnull
    private CorrelationIdentifier computeTargetIfAbsent(@Nonnull CorrelationIdentifier sourceAlias) {
        return this.sourceToTargetMap.computeIfAbsent(sourceAlias, ignored0 -> Quantifier.uniqueId());
    }
}

