/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.translation;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.google.common.base.Verify;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface TranslationMap {
    @Nonnull
    public Optional<AliasMap> getAliasMapMaybe();

    public boolean definesOnlyIdentities();

    public boolean containsSourceAlias(@Nullable CorrelationIdentifier var1);

    @Nonnull
    default public CorrelationIdentifier getTargetOrDefault(@Nonnull CorrelationIdentifier sourceAlias, @Nonnull CorrelationIdentifier defaultAlias) {
        CorrelationIdentifier targetFromMap = this.getTarget(sourceAlias);
        if (targetFromMap != null) {
            return targetFromMap;
        }
        return defaultAlias;
    }

    @Nullable
    public CorrelationIdentifier getTarget(@Nonnull CorrelationIdentifier var1);

    @Nonnull
    public Value applyTranslationFunction(@Nonnull CorrelationIdentifier var1, @Nonnull LeafValue var2);

    @Nonnull
    public static RegularTranslationMap empty() {
        return RegularTranslationMap.empty();
    }

    @Nonnull
    public static RegularTranslationMap.Builder regularBuilder() {
        return RegularTranslationMap.builder();
    }

    @Nonnull
    public static RegularTranslationMap rebaseWithAliasMap(@Nonnull AliasMap aliasMap) {
        return RegularTranslationMap.rebaseWithAliasMap(aliasMap);
    }

    @Nonnull
    public static RegularTranslationMap ofAliases(@Nonnull CorrelationIdentifier source, @Nonnull CorrelationIdentifier target) {
        return RegularTranslationMap.ofAliases(source, target);
    }

    @FunctionalInterface
    public static interface TranslationFunction {
        @Nonnull
        public Value apply(@Nonnull CorrelationIdentifier var1, @Nonnull LeafValue var2);

        @Nonnull
        public static TranslationFunction adjustValueType(@Nonnull Value translationTargetValue) {
            Type translationTargetType = translationTargetValue.getResultType();
            if (translationTargetValue instanceof QuantifiedObjectValue && translationTargetType instanceof Type.Erasable && ((Type.Erasable)translationTargetType).isErased()) {
                return (source, quantifiedValue) -> QuantifiedObjectValue.of(((QuantifiedObjectValue)translationTargetValue).getAlias(), quantifiedValue.getResultType());
            }
            Verify.verify(!(translationTargetType instanceof Type.Erasable) || !((Type.Erasable)translationTargetType).isErased());
            return (ignored, ignored2) -> translationTargetValue;
        }
    }
}

