/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.explain;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainSymbolMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainSymbolMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DefaultExplainFormatter
implements ExplainFormatter {
    @Nonnull
    private final Supplier<ExplainSymbolMap> symbolMapSupplier;
    @Nonnull
    private final Deque<ExplainSymbolMap> scopes;

    public DefaultExplainFormatter(@Nonnull Supplier<ExplainSymbolMap> symbolMapSupplier) {
        this.symbolMapSupplier = symbolMapSupplier;
        this.scopes = new ArrayDeque<ExplainSymbolMap>();
        this.scopes.push(this.symbolMapSupplier.get());
        this.registerAliasExplicitly(Quantifier.current(), "_");
    }

    @Override
    public void registerAlias(@Nonnull CorrelationIdentifier alias) {
        Objects.requireNonNull(this.scopes.peek()).registerAlias(alias);
    }

    @Override
    public void registerAliasExplicitly(@Nonnull CorrelationIdentifier alias, @Nonnull String symbol) {
        Objects.requireNonNull(this.scopes.peek()).registerAliasWithExplicitSymbol(alias, symbol);
    }

    @Override
    @Nonnull
    public Optional<String> getSymbolForAliasMaybe(@Nonnull CorrelationIdentifier alias) {
        for (ExplainSymbolMap scope : this.scopes) {
            String resolvedSymbol = scope.getSymbolForAlias(alias);
            if (resolvedSymbol == null) continue;
            return Optional.of(resolvedSymbol);
        }
        return Optional.empty();
    }

    @Override
    public void pushScope() {
        this.scopes.push(this.symbolMapSupplier.get());
    }

    @Override
    public void popScope() {
        this.scopes.pop();
    }

    @Override
    @Nonnull
    public CharSequence visitLineBreakOrSpace(@Nonnull ExplainTokens.LineBreakOrSpaceToken lineBreakOrSpaceToken, @Nonnull CharSequence stringedToken) {
        return " ";
    }

    @Override
    @Nonnull
    public CharSequence visitError(@Nonnull ExplainTokens.Token token, @Nonnull CharSequence stringedToken) {
        return "?" + String.valueOf(stringedToken) + "?";
    }

    @Nonnull
    public static DefaultExplainFormatter forDebugging() {
        return new DefaultExplainFormatter(DefaultExplainSymbolMap::new);
    }
}

