/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.explain;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.explain.ExplainSymbolMap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExplainSelfContainedSymbolMap
implements ExplainSymbolMap {
    @Nonnull
    private final AtomicInteger quantifierNumber = new AtomicInteger(0);
    @Nonnull
    private final BiMap<CorrelationIdentifier, String> aliasToFormattingNameMap = HashBiMap.create();

    @Override
    public void registerAlias(@Nonnull CorrelationIdentifier alias) {
        this.registerAliasWithExplicitSymbol(alias, "q" + this.quantifierNumber.getAndIncrement());
    }

    @Override
    public void registerAliasWithExplicitSymbol(@Nonnull CorrelationIdentifier alias, @Nonnull String symbol) {
        this.aliasToFormattingNameMap.putIfAbsent(alias, symbol);
    }

    @Override
    @Nullable
    public String getSymbolForAlias(@Nonnull CorrelationIdentifier alias) {
        return (String)this.aliasToFormattingNameMap.get(alias);
    }
}

