/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.explain;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.explain.ExplainFormatter;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExplainTokens {
    @Nonnull
    private final List<Token> tokens = Lists.newArrayList();
    private int[] tokenSizes = new int[0];
    private int[] minLengths = new int[0];
    private int[] maxLengths = new int[0];

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    @Nonnull
    public List<Token> getTokens() {
        return this.tokens;
    }

    @Nonnull
    protected int[] getTokenSizes() {
        return this.tokenSizes;
    }

    public int getTokenSize(int explainLevel) {
        return explainLevel < this.tokenSizes.length ? this.tokenSizes[explainLevel] : 0;
    }

    @Nonnull
    protected int[] getMinLengths() {
        return this.minLengths;
    }

    public int getMinLength(int explainLevel) {
        return explainLevel < this.minLengths.length ? this.minLengths[explainLevel] : 0;
    }

    @Nonnull
    protected int[] getMaxLengths() {
        return this.maxLengths;
    }

    public int getMaxLength(int explainLevel) {
        return explainLevel < this.maxLengths.length ? this.maxLengths[explainLevel] : 0;
    }

    @Nonnull
    public CharSequence render(@Nonnull ExplainFormatter formatter) {
        return this.render(0, formatter, Integer.MAX_VALUE);
    }

    @Nonnull
    public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter formatter, int remainingCharacterBudget) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            CharSequence stringedToken = token.render(renderingExplainLevel, formatter, remainingCharacterBudget);
            stringBuilder.append(stringedToken);
            if ((remainingCharacterBudget -= remainingCharacterBudget == Integer.MAX_VALUE ? 0 : stringedToken.length()) >= 1) continue;
            if (remainingCharacterBudget == 0 && i + 1 < this.tokens.size()) {
                for (int j = i + 1; j < this.tokens.size(); ++j) {
                    Token remainingToken = this.tokens.get(j);
                    CharSequence remainingStringedToken = remainingToken.render(renderingExplainLevel, formatter, 0);
                    if (remainingStringedToken.toString().isEmpty()) continue;
                    return stringBuilder.append(remainingStringedToken);
                }
            }
            return stringBuilder;
        }
        return stringBuilder;
    }

    @Nonnull
    public ExplainTokens add(@Nonnull Token token) {
        this.tokens.add(token);
        this.tokenSizes = ExplainTokens.vectorAdd(this.tokenSizes, token.getTokenSizes());
        this.minLengths = ExplainTokens.vectorAdd(this.minLengths, token.getMinLengths());
        this.maxLengths = ExplainTokens.vectorAdd(this.maxLengths, token.getMaxLengths());
        return this;
    }

    @Nonnull
    public ExplainTokens addNested(@Nonnull ExplainTokens additionalExplainTokens) {
        return this.addNested(2, additionalExplainTokens);
    }

    @Nonnull
    public ExplainTokens addNested(int explainLevel, @Nonnull ExplainTokens additionalExplainTokens) {
        return this.add(new NestedToken(explainLevel, additionalExplainTokens, new OptionalWhitespaceToken(2)));
    }

    @Nonnull
    public ExplainTokens addNested(int explainLevel, @Nonnull ExplainTokens additionalExplainTokens, @Nonnull String replacementTokenString) {
        return this.addNested(explainLevel, additionalExplainTokens, new ToStringToken(2, replacementTokenString));
    }

    @Nonnull
    public ExplainTokens addNested(int explainLevel, @Nonnull ExplainTokens additionalExplainTokens, @Nonnull Token replacementToken) {
        return this.add(new NestedToken(explainLevel, additionalExplainTokens, replacementToken));
    }

    @Nonnull
    public ExplainTokens addAll(@Nonnull Collection<? extends Token> additionalTokens) {
        additionalTokens.forEach(this::add);
        return this;
    }

    @Nonnull
    public ExplainTokens addPush() {
        return this.addPush(2);
    }

    @Nonnull
    public ExplainTokens addPush(int explainLevel) {
        return this.add(new PushToken(explainLevel));
    }

    @Nonnull
    public ExplainTokens addPop() {
        return this.addPop(2);
    }

    @Nonnull
    public ExplainTokens addPop(int explainLevel) {
        return this.add(new PopToken(explainLevel));
    }

    @Nonnull
    public ExplainTokens addWhitespace() {
        return this.addWhitespace(2);
    }

    @Nonnull
    public ExplainTokens addWhitespace(int explainLevel) {
        return this.add(new WhitespaceToken(explainLevel));
    }

    @Nonnull
    public ExplainTokens addOptionalWhitespace() {
        return this.addOptionalWhitespace(2);
    }

    @Nonnull
    public ExplainTokens addOptionalWhitespace(int explainLevel) {
        return this.add(new OptionalWhitespaceToken(explainLevel));
    }

    @Nonnull
    public ExplainTokens addLinebreakOrWhitespace() {
        return this.addLinebreakOrWhitespace(2);
    }

    @Nonnull
    public ExplainTokens addLinebreakOrWhitespace(int explainLevel) {
        return this.add(new LineBreakOrSpaceToken(explainLevel));
    }

    @Nonnull
    public ExplainTokens addIdentifier(@Nonnull String identifier) {
        return this.addIdentifier(2, identifier);
    }

    @Nonnull
    public ExplainTokens addIdentifier(int explainLevel, @Nonnull String identifier) {
        return this.add(new IdentifierToken(explainLevel, identifier));
    }

    @Nonnull
    public ExplainTokens addKeyword(@Nonnull String keyword) {
        return this.addKeyword(2, keyword);
    }

    @Nonnull
    public ExplainTokens addKeyword(int explainLevel, @Nonnull String keyword) {
        return this.add(new KeywordToken(explainLevel, keyword));
    }

    @Nonnull
    public ExplainTokens addComma() {
        return this.addComma(2);
    }

    @Nonnull
    public ExplainTokens addComma(int explainLevel) {
        return this.add(new CommaLikeToken(explainLevel, ","));
    }

    @Nonnull
    public ExplainTokens addCommaAndWhiteSpace() {
        return this.addCommaAndWhiteSpace(2);
    }

    @Nonnull
    public ExplainTokens addCommaAndWhiteSpace(int explainLevel) {
        return this.addComma(explainLevel).addWhitespace(explainLevel);
    }

    @Nonnull
    public ExplainTokens addAliasDefinition(@Nonnull CorrelationIdentifier alias) {
        return this.addAliasDefinition(2, alias);
    }

    @Nonnull
    public ExplainTokens addAliasDefinition(int explainLevel, @Nonnull CorrelationIdentifier alias) {
        return this.add(new AliasDefinitionToken(explainLevel, alias));
    }

    @Nonnull
    public ExplainTokens addCurrentAliasDefinition(@Nonnull CorrelationIdentifier alias) {
        return this.addCurrentAliasDefinition(2, alias);
    }

    @Nonnull
    public ExplainTokens addCurrentAliasDefinition(int explainLevel, @Nonnull CorrelationIdentifier alias) {
        return this.add(new CurrentAliasDefinitionToken(explainLevel, alias));
    }

    @Nonnull
    public ExplainTokens addAliasReference(@Nonnull CorrelationIdentifier alias) {
        return this.addAliasReference(2, alias);
    }

    @Nonnull
    public ExplainTokens addAliasReference(int explainLevel, @Nonnull CorrelationIdentifier alias) {
        return this.add(new AliasReferenceToken(explainLevel, alias));
    }

    @Nonnull
    public ExplainTokens addOpeningParen() {
        return this.addOpeningParen(2);
    }

    @Nonnull
    public ExplainTokens addOpeningParen(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, true, "("));
    }

    @Nonnull
    public ExplainTokens addClosingParen() {
        return this.addClosingParen(2);
    }

    @Nonnull
    public ExplainTokens addClosingParen(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, false, ")"));
    }

    @Nonnull
    public ExplainTokens addOpeningSquareBracket() {
        return this.addOpeningSquareBracket(2);
    }

    @Nonnull
    public ExplainTokens addOpeningSquareBracket(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, true, "["));
    }

    @Nonnull
    public ExplainTokens addClosingSquareBracket() {
        return this.addClosingSquareBracket(2);
    }

    @Nonnull
    public ExplainTokens addClosingSquareBracket(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, false, "]"));
    }

    @Nonnull
    public ExplainTokens addOpeningBrace() {
        return this.addOpeningBrace(2);
    }

    @Nonnull
    public ExplainTokens addOpeningBrace(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, true, "{"));
    }

    @Nonnull
    public ExplainTokens addClosingBrace() {
        return this.addClosingBrace(2);
    }

    @Nonnull
    public ExplainTokens addClosingBrace(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, false, "}"));
    }

    @Nonnull
    public ExplainTokens addOpeningAngledBracket() {
        return this.addOpeningAngledBracket(2);
    }

    @Nonnull
    public ExplainTokens addOpeningAngledBracket(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, true, "<"));
    }

    @Nonnull
    public ExplainTokens addClosingAngledBracket() {
        return this.addClosingAngledBracket(2);
    }

    @Nonnull
    public ExplainTokens addClosingAngledBracket(int explainLevel) {
        return this.add(new BracketLikeToken(explainLevel, false, ">"));
    }

    @Nonnull
    public ExplainTokens addToString(@Nullable Object object) {
        return this.addToString(2, object);
    }

    @Nonnull
    public ExplainTokens addToString(int explainLevel, @Nullable Object object) {
        return this.add(new ToStringToken(explainLevel, object));
    }

    @Nonnull
    public ExplainTokens addToStrings(@Nonnull Iterable<?> objects) {
        return this.addToStrings(2, objects);
    }

    @Nonnull
    public ExplainTokens addToStrings(int explainLevel, @Nonnull Iterable<?> objects) {
        Iterator<?> iterator = objects.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.addToString(explainLevel, object);
            if (!iterator.hasNext()) continue;
            this.addCommaAndWhiteSpace(explainLevel);
        }
        return this;
    }

    @Nonnull
    public ExplainTokens addFunctionCall(@Nonnull String identifier) {
        return this.addFunctionCall(2, identifier);
    }

    @Nonnull
    public ExplainTokens addFunctionCall(int explainLevel, @Nonnull String identifier) {
        return this.addFunctionCall(explainLevel, identifier, null);
    }

    @Nonnull
    public ExplainTokens addFunctionCall(@Nonnull String identifier, @Nullable ExplainTokens childExplainTokens) {
        return this.addFunctionCall(2, identifier, childExplainTokens);
    }

    @Nonnull
    public ExplainTokens addFunctionCall(int explainLevel, @Nonnull String identifier, @Nullable ExplainTokens childExplainTokens) {
        if (childExplainTokens == null || childExplainTokens.isEmpty()) {
            return this.addIdentifier(explainLevel, identifier).addOptionalWhitespace(explainLevel).addOpeningParen(explainLevel).addClosingParen(explainLevel);
        }
        return this.addIdentifier(explainLevel, identifier).addOptionalWhitespace(explainLevel).addOpeningParen(explainLevel).addOptionalWhitespace(explainLevel).addNested(childExplainTokens).addOptionalWhitespace(explainLevel).addClosingParen(explainLevel);
    }

    @Nonnull
    public ExplainTokens addSequence(@Nonnull Supplier<ExplainTokens> delimiterSupplier, ExplainTokens ... childrenExplainTokens) {
        return this.addSequence(delimiterSupplier, Arrays.asList(childrenExplainTokens));
    }

    @Nonnull
    public ExplainTokens addSequence(@Nonnull Supplier<ExplainTokens> delimiterSupplier, @Nonnull Iterable<ExplainTokens> childrenExplainTokens) {
        Iterator<ExplainTokens> iterator = childrenExplainTokens.iterator();
        while (iterator.hasNext()) {
            ExplainTokens childExplainTokens = iterator.next();
            this.addNested(childExplainTokens);
            if (!iterator.hasNext()) continue;
            this.addAll(delimiterSupplier.get().getTokens());
        }
        return this;
    }

    @Nonnull
    private static int[] vectorAdd(@Nonnull int[] left, @Nonnull int[] right) {
        return ExplainTokens.vectorOp(left, right, Integer::sum);
    }

    @Nonnull
    private static int[] vectorCoalesce(@Nonnull int[] left, @Nonnull int[] right) {
        return ExplainTokens.vectorOp(left, right, (a, b) -> {
            if (a == 0) {
                return b;
            }
            if (b == 0) {
                return a;
            }
            throw new RecordCoreException("incorrect use of coalesce", new Object[0]);
        });
    }

    @Nonnull
    private static int[] vectorOp(@Nonnull int[] left, @Nonnull int[] right, IntBinaryOperator intBinaryOperator) {
        int maxSize = Math.max(left.length, right.length);
        int[] result = new int[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            result[i] = intBinaryOperator.applyAsInt(i < left.length ? left[i] : 0, i < right.length ? right[i] : 0);
        }
        return result;
    }

    public static abstract class Token {
        public static final int DEFAULT_EXPLAIN_LEVEL = 2;
        private static final int MAX_ALIAS_LENGTH = 36;
        @Nonnull
        private final TokenKind tokenKind;
        @Nonnull
        private final int[] tokenSizes;
        @Nonnull
        private final int[] minLengths;
        @Nonnull
        private final int[] maxLengths;

        public Token(@Nonnull TokenKind tokenKind, int explainLevel, int minLength, int maxLength) {
            this(tokenKind, explainLevel, 1, minLength, maxLength);
        }

        public Token(@Nonnull TokenKind tokenKind, int explainLevel, int tokenSize, int minLength, int maxLength) {
            this(tokenKind, Token.vectorForExplainLevel(explainLevel + 1, tokenSize), Token.vectorForExplainLevel(explainLevel + 1, minLength), Token.vectorForExplainLevel(explainLevel + 1, maxLength));
        }

        protected Token(@Nonnull TokenKind tokenKind, @Nonnull int[] tokenSizes, @Nonnull int[] minLengths, @Nonnull int[] maxLengths) {
            this.tokenKind = tokenKind;
            this.tokenSizes = tokenSizes;
            this.minLengths = minLengths;
            this.maxLengths = maxLengths;
        }

        @Nonnull
        public TokenKind getTokenKind() {
            return this.tokenKind;
        }

        @Nonnull
        private int[] getTokenSizes() {
            return this.tokenSizes;
        }

        @Nonnull
        private int[] getMinLengths() {
            return this.minLengths;
        }

        @Nonnull
        private int[] getMaxLengths() {
            return this.maxLengths;
        }

        public int getExplainLevel() {
            Verify.verify(this.tokenSizes.length == this.minLengths.length);
            return this.tokenSizes.length - 1;
        }

        protected boolean isRenderingEnabled(int renderingExplainLevel) {
            return this.getExplainLevel() >= renderingExplainLevel;
        }

        protected <T extends Token> CharSequence renderIfEnabled(int renderingExplainLevel, @Nonnull String stringedToken, @Nonnull BiFunction<T, CharSequence, CharSequence> renderFunction) {
            if (this.isRenderingEnabled(renderingExplainLevel)) {
                return renderFunction.apply(this, stringedToken);
            }
            return "";
        }

        protected CharSequence cutOffIfNeeded(int remainingCharacterBudget, @Nonnull CharSequence stringedToken) {
            Verify.verify(remainingCharacterBudget >= 0);
            if (remainingCharacterBudget >= stringedToken.length()) {
                return stringedToken;
            }
            return new StringBuilder(stringedToken.subSequence(0, remainingCharacterBudget)).append("...");
        }

        public int getTokenSize(int explainLevel) {
            return explainLevel < this.tokenSizes.length ? this.tokenSizes[explainLevel] : 0;
        }

        public int getMinLength(int explainLevel) {
            return explainLevel < this.minLengths.length ? this.minLengths[explainLevel] : 0;
        }

        public int getMaxLength(int explainLevel) {
            return explainLevel < this.maxLengths.length ? this.maxLengths[explainLevel] : 0;
        }

        @Nonnull
        public abstract CharSequence render(int var1, @Nonnull ExplainFormatter var2, int var3);

        @Nonnull
        private static int[] vectorForExplainLevel(int explainLevelExclusive, int value) {
            int[] result = new int[explainLevelExclusive];
            Arrays.fill(result, value);
            return result;
        }
    }

    public static class NestedToken
    extends Token {
        final int explainLevel;
        final int explainLevelAdjustment;
        @Nonnull
        private final ExplainTokens nestedExplainTokens;
        @Nonnull
        private final Token replacementToken;

        public NestedToken(int explainLevel, @Nonnull ExplainTokens nestedExplainTokens, @Nonnull Token replacementToken) {
            this(explainLevel, 2 - explainLevel, nestedExplainTokens, replacementToken);
        }

        private NestedToken(int explainLevel, int explainLevelAdjustment, @Nonnull ExplainTokens nestedExplainTokens, @Nonnull Token replacementToken) {
            super(TokenKind.NESTED, nestedExplainTokens.getTokenSizes(), ExplainTokens.vectorCoalesce(NestedToken.shiftLengthsDownBy(nestedExplainTokens.getMinLengths(), explainLevelAdjustment), NestedToken.zeroOutLengthsUpTo(replacementToken.getMinLengths(), explainLevel + 1)), ExplainTokens.vectorCoalesce(NestedToken.shiftLengthsDownBy(nestedExplainTokens.getMaxLengths(), explainLevelAdjustment), NestedToken.zeroOutLengthsUpTo(replacementToken.getMaxLengths(), explainLevel + 1)));
            this.explainLevel = explainLevel;
            this.explainLevelAdjustment = explainLevelAdjustment;
            if (explainLevelAdjustment != 0) {
                NestedToken.validateNestedTokens(nestedExplainTokens.getTokens());
            }
            this.nestedExplainTokens = nestedExplainTokens;
            this.replacementToken = replacementToken;
        }

        private int getExplainLevelAdjustment() {
            return this.explainLevelAdjustment;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            CharSequence renderedNested = this.explainLevel >= renderingExplainLevel ? this.nestedExplainTokens.render(renderingExplainLevel + this.explainLevelAdjustment, explainFormatter, remainingCharacterBudget) : this.replacementToken.render(2, explainFormatter, Integer.MAX_VALUE);
            return this.cutOffIfNeeded(remainingCharacterBudget, explainFormatter.visitNested(this, renderedNested));
        }

        private static int[] zeroOutLengthsUpTo(@Nonnull int[] lengths, int maxExplainLevelExclusive) {
            int[] resultArray = Arrays.copyOf(lengths, lengths.length);
            Arrays.fill(resultArray, 0, maxExplainLevelExclusive, 0);
            return resultArray;
        }

        private static int[] shiftLengthsDownBy(@Nonnull int[] lengths, int explainLevelAdjustment) {
            Verify.verify(explainLevelAdjustment >= 0);
            if (explainLevelAdjustment == 0) {
                return lengths;
            }
            if (lengths.length - explainLevelAdjustment > 0) {
                int[] resultArray = new int[lengths.length - explainLevelAdjustment];
                System.arraycopy(lengths, explainLevelAdjustment, resultArray, 0, lengths.length - explainLevelAdjustment);
                return resultArray;
            }
            return new int[0];
        }

        private static void validateNestedTokens(@Nonnull List<Token> nestedTokens) {
            for (Token token : nestedTokens) {
                if (token instanceof NestedToken) {
                    Verify.verify(((NestedToken)token).getExplainLevelAdjustment() == 0);
                    NestedToken.validateNestedTokens(((NestedToken)token).nestedExplainTokens.getTokens());
                    continue;
                }
                Verify.verify(token.getExplainLevel() == 2);
            }
        }
    }

    public static class OptionalWhitespaceToken
    extends Token {
        public OptionalWhitespaceToken(int explainLevel) {
            super(TokenKind.OPTIONAL_WHITESPACE, explainLevel, 0, 1);
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, "", explainFormatter::visitOptionalWhitespace));
        }
    }

    public static class ToStringToken
    extends Token {
        @Nullable
        private final Object object;
        private final String objectAsString;

        public ToStringToken(int explainLevel, @Nullable Object object) {
            this(explainLevel, object, String.valueOf(object));
        }

        private ToStringToken(int explainLevel, @Nullable Object object, @Nonnull String objectAsString) {
            super(TokenKind.TO_STRING, explainLevel, objectAsString.length(), objectAsString.length());
            this.object = object;
            this.objectAsString = objectAsString;
        }

        @Nullable
        public Object getObject() {
            return this.object;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, this.objectAsString, explainFormatter::visitToString));
        }
    }

    public static class PushToken
    extends Token {
        public PushToken(int explainLevel) {
            super(TokenKind.PUSH, explainLevel, 0, 0);
        }

        @Override
        @Nonnull
        public String render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            if (this.isRenderingEnabled(renderingExplainLevel)) {
                explainFormatter.pushScope();
            }
            return "";
        }
    }

    public static class PopToken
    extends Token {
        public PopToken(int explainLevel) {
            super(TokenKind.POP, explainLevel, 0, 0);
        }

        @Override
        @Nonnull
        public String render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            if (this.isRenderingEnabled(renderingExplainLevel)) {
                explainFormatter.popScope();
            }
            return "";
        }
    }

    public static class WhitespaceToken
    extends Token {
        public WhitespaceToken(int explainLevel) {
            super(TokenKind.WHITESPACE, explainLevel, 1, 1);
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, " ", explainFormatter::visitWhitespace));
        }
    }

    public static class LineBreakOrSpaceToken
    extends Token {
        public LineBreakOrSpaceToken(int explainLevel) {
            super(TokenKind.LINE_BREAK_OR_SPACE, explainLevel, 1, 1);
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, "", explainFormatter::visitLineBreakOrSpace));
        }
    }

    public static class IdentifierToken
    extends Token {
        @Nonnull
        private final String identifier;

        public IdentifierToken(int explainLevel, @Nonnull String identifier) {
            super(TokenKind.IDENTIFIER, explainLevel, identifier.length(), identifier.length());
            this.identifier = identifier;
        }

        @Nonnull
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, this.identifier, explainFormatter::visitIdentifier));
        }
    }

    public static class KeywordToken
    extends Token {
        @Nonnull
        private final String keyword;

        public KeywordToken(int explainLevel, @Nonnull String keyword) {
            super(TokenKind.KEYWORD, explainLevel, keyword.length(), keyword.length());
            this.keyword = keyword;
        }

        @Nonnull
        public String getKeyword() {
            return this.keyword;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, this.keyword, explainFormatter::visitKeyword));
        }
    }

    public static class CommaLikeToken
    extends Token {
        @Nonnull
        private final String commaLike;

        public CommaLikeToken(int explainLevel, @Nonnull String commaLike) {
            super(TokenKind.COMMA_LIKE, explainLevel, 1, 1);
            this.commaLike = commaLike;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, this.commaLike, explainFormatter::visitCommaLike));
        }
    }

    public static class AliasDefinitionToken
    extends Token {
        @Nonnull
        private final CorrelationIdentifier alias;

        public AliasDefinitionToken(int explainLevel, @Nonnull CorrelationIdentifier alias) {
            super(TokenKind.ALIAS_DEFINITION, explainLevel, 1, 36);
            this.alias = alias;
        }

        @Nonnull
        public CorrelationIdentifier getAlias() {
            return this.alias;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            if (this.isRenderingEnabled(renderingExplainLevel)) {
                explainFormatter.registerAlias(this.alias);
                return this.cutOffIfNeeded(remainingCharacterBudget, explainFormatter.visitAliasDefinition(this, explainFormatter.getSymbolForAliasMaybe(this.alias).orElseThrow(() -> new RecordCoreException("must have resolved symbol", new Object[0]))));
            }
            return "";
        }
    }

    public static class CurrentAliasDefinitionToken
    extends Token {
        @Nonnull
        private final CorrelationIdentifier alias;

        public CurrentAliasDefinitionToken(int explainLevel, @Nonnull CorrelationIdentifier alias) {
            super(TokenKind.ALIAS_DEFINITION, explainLevel, 0, 0);
            this.alias = alias;
        }

        @Nonnull
        public CorrelationIdentifier getAlias() {
            return this.alias;
        }

        @Override
        @Nonnull
        public String render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            if (this.isRenderingEnabled(renderingExplainLevel)) {
                explainFormatter.registerAliasExplicitly(this.alias, "_");
            }
            return "";
        }
    }

    public static class AliasReferenceToken
    extends Token {
        @Nonnull
        private final CorrelationIdentifier alias;

        public AliasReferenceToken(int explainLevel, @Nonnull CorrelationIdentifier alias) {
            super(TokenKind.ALIAS_REFERENCE, explainLevel, 1, 38);
            this.alias = alias;
        }

        @Nonnull
        public CorrelationIdentifier getAlias() {
            return this.alias;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            Optional<String> symbolForAliasOptional = explainFormatter.getSymbolForAliasMaybe(this.alias);
            CharSequence result = symbolForAliasOptional.isPresent() ? this.renderIfEnabled(renderingExplainLevel, symbolForAliasOptional.get(), explainFormatter::visitAliasReference) : this.renderIfEnabled(renderingExplainLevel, this.alias.getId(), explainFormatter::visitError);
            return this.cutOffIfNeeded(remainingCharacterBudget, result);
        }
    }

    public static class BracketLikeToken
    extends Token {
        private final boolean isOpen;
        @Nonnull
        private final String bracket;

        public BracketLikeToken(int explainLevel, boolean isOpen, @Nonnull String bracket) {
            super(isOpen ? TokenKind.BRACKETS_OPEN : TokenKind.BRACKETS_CLOSE, explainLevel, 1, 1);
            this.isOpen = isOpen;
            this.bracket = bracket;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        @Nonnull
        public CharSequence render(int renderingExplainLevel, @Nonnull ExplainFormatter explainFormatter, int remainingCharacterBudget) {
            return this.cutOffIfNeeded(remainingCharacterBudget, this.renderIfEnabled(renderingExplainLevel, this.bracket, explainFormatter::visitBracketLike));
        }
    }

    public static enum TokenKind {
        PUSH,
        POP,
        NESTED,
        WHITESPACE,
        OPTIONAL_WHITESPACE,
        LINE_BREAK_OR_SPACE,
        IDENTIFIER,
        KEYWORD,
        COMMA_LIKE,
        ALIAS_DEFINITION,
        ALIAS_REFERENCE,
        BRACKETS_OPEN,
        BRACKETS_CLOSE,
        TO_STRING;

    }
}

