/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.explain;

import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import javax.annotation.Nonnull;

public class ExplainTokensWithPrecedence {
    @Nonnull
    private final Precedence precedence;
    @Nonnull
    private final ExplainTokens explainTokens;

    private ExplainTokensWithPrecedence(@Nonnull Precedence precedence, @Nonnull ExplainTokens explainTokens) {
        this.precedence = precedence;
        this.explainTokens = explainTokens;
    }

    @Nonnull
    public Precedence getPrecedence() {
        return this.precedence;
    }

    @Nonnull
    public ExplainTokens getExplainTokens() {
        return this.explainTokens;
    }

    @Nonnull
    public static ExplainTokensWithPrecedence of(@Nonnull ExplainTokens explainTokens) {
        return ExplainTokensWithPrecedence.of(Precedence.NEVER_PARENS, explainTokens);
    }

    @Nonnull
    public static ExplainTokensWithPrecedence of(@Nonnull Precedence precedence, @Nonnull ExplainTokens explainTokens) {
        return new ExplainTokensWithPrecedence(precedence, explainTokens);
    }

    public static enum Precedence {
        NEVER_PARENS(-2),
        ALWAYS_PARENS(-1),
        DOT(0),
        UNARY_MINUS_BITWISE_NOT(1),
        BITWISE_XOR(2),
        MULTIPLICATIVE(3),
        ADDITIVE(4),
        SHIFT(5),
        BITWISE_AND(6),
        BITWISE_OR(7),
        COMPARISONS(8),
        BETWEEN(9),
        NOT(10),
        AND(11),
        XOR(12),
        OR(13),
        ASSIGNMENT(13);

        private final int precedenceOrdinal;

        private Precedence(int precedenceOrdinal) {
            this.precedenceOrdinal = precedenceOrdinal;
        }

        public int getPrecedenceOrdinal() {
            return this.precedenceOrdinal;
        }

        @Nonnull
        public ExplainTokens parenthesizeChild(@Nonnull ExplainTokensWithPrecedence childExplainInfo) {
            return this.parenthesizeChild(childExplainInfo, false);
        }

        @Nonnull
        public ExplainTokens parenthesizeChild(@Nonnull ExplainTokensWithPrecedence childExplainInfo, boolean isStrict) {
            return this.parenthesizeChild(childExplainInfo.getPrecedence(), childExplainInfo.getExplainTokens(), isStrict);
        }

        @Nonnull
        public ExplainTokens parenthesizeChild(@Nonnull Precedence childPrecedence, @Nonnull ExplainTokens childExplainTokens, boolean isStrict) {
            if (childPrecedence == ALWAYS_PARENS || isStrict && childPrecedence.getPrecedenceOrdinal() == this.getPrecedenceOrdinal() || childPrecedence.getPrecedenceOrdinal() > this.getPrecedenceOrdinal()) {
                return new ExplainTokens().addOpeningParen().addOptionalWhitespace().addNested(childExplainTokens).addOptionalWhitespace().addClosingParen();
            }
            return childExplainTokens;
        }
    }
}

