/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.explain;

import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainSymbolMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainSymbolMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class PrettyExplainFormatter
extends DefaultExplainFormatter {
    private static final int TAB_SIZE = 4;
    private final boolean useOptionalLineBreaks;
    private int indentationLevel;

    public PrettyExplainFormatter(@Nonnull Supplier<ExplainSymbolMap> symbolMapSupplier, boolean useOptionalLineBreaks) {
        super(symbolMapSupplier);
        this.useOptionalLineBreaks = useOptionalLineBreaks;
        this.indentationLevel = 0;
    }

    @Override
    @Nonnull
    public CharSequence visitLineBreakOrSpace(@Nonnull ExplainTokens.LineBreakOrSpaceToken lineBreakOrSpaceToken, @Nonnull CharSequence stringedToken) {
        if (this.useOptionalLineBreaks) {
            return "\n" + " ".repeat(this.indentationLevel * 4);
        }
        return " ";
    }

    @Override
    @Nonnull
    public CharSequence visitIdentifier(@Nonnull ExplainTokens.IdentifierToken identifierToken, @Nonnull CharSequence stringedToken) {
        return new StringBuilder().append((Object)Color.BRIGHT_YELLOW).append(stringedToken).append((Object)Color.RESET);
    }

    @Override
    @Nonnull
    public CharSequence visitKeyword(@Nonnull ExplainTokens.KeywordToken keywordToken, @Nonnull CharSequence stringedToken) {
        return new StringBuilder().append((Object)Color.BRIGHT_WHITE).append(stringedToken).append((Object)Color.RESET);
    }

    @Override
    @Nonnull
    public CharSequence visitAliasDefinition(@Nonnull ExplainTokens.AliasDefinitionToken aliasDefinitionToken, @Nonnull CharSequence stringedToken) {
        return new StringBuilder().append((Object)Color.BRIGHT_GREEN).append(stringedToken).append((Object)Color.RESET);
    }

    @Override
    @Nonnull
    public CharSequence visitAliasReference(@Nonnull ExplainTokens.AliasReferenceToken aliasReferenceToken, @Nonnull CharSequence stringedToken) {
        return new StringBuilder().append((Object)Color.GREEN).append(stringedToken).append((Object)Color.RESET);
    }

    @Override
    @Nonnull
    public CharSequence visitBracketLike(@Nonnull ExplainTokens.BracketLikeToken bracketLikeToken, @Nonnull CharSequence stringedToken) {
        this.indentationLevel = bracketLikeToken.isOpen() ? ++this.indentationLevel : --this.indentationLevel;
        return new StringBuilder().append((Object)Color.BRIGHT_WHITE).append(stringedToken).append((Object)Color.RESET);
    }

    @Override
    @Nonnull
    public CharSequence visitToString(@Nonnull ExplainTokens.ToStringToken toStringToken, @Nonnull CharSequence stringedToken) {
        return new StringBuilder().append((Object)Color.WHITE).append(stringedToken).append((Object)Color.RESET);
    }

    @Override
    @Nonnull
    public CharSequence visitError(@Nonnull ExplainTokens.Token token, @Nonnull CharSequence stringedToken) {
        return new StringBuilder().append((Object)Color.BRIGHT_RED).append(stringedToken).append((Object)Color.RESET);
    }

    @Nonnull
    public static PrettyExplainFormatter forDebugging() {
        return new PrettyExplainFormatter(DefaultExplainSymbolMap::new, false);
    }

    public static enum Color {
        RESET("\u001b[0m"),
        BLACK("\u001b[30m"),
        RED("\u001b[31m"),
        GREEN("\u001b[32m"),
        YELLOW("\u001b[33m"),
        BLUE("\u001b[34m"),
        MAGENTA("\u001b[35m"),
        CYAN("\u001b[36m"),
        WHITE("\u001b[37m"),
        BRIGHT_BLACK("\u001b[90;1m"),
        BRIGHT_RED("\u001b[91;1m"),
        BRIGHT_GREEN("\u001b[92;1m"),
        BRIGHT_YELLOW("\u001b[93;1m"),
        BRIGHT_BLUE("\u001b[94;1m"),
        BRIGHT_MAGENTA("\u001b[95;1m"),
        BRIGHT_CYAN("\u001b[96;1m"),
        BRIGHT_WHITE("\u001b[97;1m");

        @Nonnull
        private final String ansi;

        private Color(String ansi) {
            this.ansi = ansi;
        }

        public String toString() {
            return this.ansi;
        }
    }
}

