/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.planprotos.PScoreForRank;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ZeroCopyByteString;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public enum BindingFunction {
    INT(tuple -> {
        Long value = (Long)tuple.get(0);
        return value == null ? null : Integer.valueOf(value.intValue());
    }),
    LONG(tuple -> (Long)tuple.get(0)),
    FLOAT(tuple -> {
        Double value = (Double)tuple.get(0);
        return value == null ? null : Float.valueOf(value.floatValue());
    }),
    DOUBLE(tuple -> (Double)tuple.get(0)),
    BOOLEAN(tuple -> (Boolean)tuple.get(0)),
    STRING(tuple -> (String)tuple.get(0)),
    BYTE_STRING(tuple -> {
        byte[] value = (byte[])tuple.get(0);
        return value == null ? null : ZeroCopyByteString.wrap(value);
    }),
    TUPLE(tuple -> tuple.get(0));

    @Nonnull
    private Function<Tuple, Object> function;

    private BindingFunction(Function<Tuple, Object> function) {
        this.function = function;
    }

    @Nullable
    public Object apply(@Nonnull Tuple tuple) {
        return this.function.apply(tuple);
    }

    @Nonnull
    public PScoreForRank.PBindingFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
        switch (this) {
            case INT: {
                return PScoreForRank.PBindingFunction.INT;
            }
            case LONG: {
                return PScoreForRank.PBindingFunction.LONG;
            }
            case FLOAT: {
                return PScoreForRank.PBindingFunction.FLOAT;
            }
            case DOUBLE: {
                return PScoreForRank.PBindingFunction.DOUBLE;
            }
            case BOOLEAN: {
                return PScoreForRank.PBindingFunction.BOOLEAN;
            }
            case STRING: {
                return PScoreForRank.PBindingFunction.STRING;
            }
            case BYTE_STRING: {
                return PScoreForRank.PBindingFunction.BYTE_STRING;
            }
            case TUPLE: {
                return PScoreForRank.PBindingFunction.TUPLE;
            }
        }
        throw new RecordCoreException("unknown binding function mapping. did you forget to add it?", new Object[0]);
    }

    @Nonnull
    public static BindingFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PScoreForRank.PBindingFunction bindingFunctionProto) {
        switch (bindingFunctionProto) {
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case STRING: {
                return STRING;
            }
            case BYTE_STRING: {
                return BYTE_STRING;
            }
            case TUPLE: {
                return TUPLE;
            }
        }
        throw new RecordCoreException("unknown binding function mapping. did you forget to add it?", new Object[0]);
    }

    @Nonnull
    static BindingFunction comparisonBindingFunction(@Nonnull QueryComponent fieldComparison, @Nonnull Index index, @Nonnull RecordMetaData metaData) {
        Descriptors.FieldDescriptor.JavaType javaType = BindingFunction.javaComparisonType(fieldComparison, index, metaData);
        if (javaType != null) {
            switch (javaType) {
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case STRING: {
                    return STRING;
                }
                case BYTE_STRING: {
                    return BYTE_STRING;
                }
            }
        }
        return TUPLE;
    }

    @Nullable
    private static Descriptors.FieldDescriptor.JavaType javaComparisonType(@Nonnull QueryComponent fieldComparison, @Nonnull Index index, @Nonnull RecordMetaData metaData) {
        Descriptors.FieldDescriptor.JavaType javaType = null;
        for (RecordType recordType : metaData.recordTypesForIndex(index)) {
            Descriptors.FieldDescriptor fieldDescriptor;
            Descriptors.Descriptor descriptor = recordType.getDescriptor();
            QueryComponent component = fieldComparison;
            while (component instanceof NestedField) {
                fieldDescriptor = descriptor.findFieldByName(((NestedField)component).getName());
                if (fieldDescriptor == null) {
                    return null;
                }
                descriptor = fieldDescriptor.getMessageType();
                component = ((NestedField)component).getChild();
            }
            if (component instanceof FieldWithComparison) {
                fieldDescriptor = descriptor.findFieldByName(((FieldWithComparison)component).getName());
                if (fieldDescriptor == null) {
                    return null;
                }
                if (javaType == null) {
                    javaType = fieldDescriptor.getJavaType();
                    continue;
                }
                if (javaType == fieldDescriptor.getJavaType()) continue;
                return null;
            }
            return null;
        }
        return javaType;
    }
}

