/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.BooleanComponent;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.NotComponent;
import com.apple.foundationdb.record.query.expressions.OrComponent;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class BooleanNormalizer {
    public static final int DEFAULT_SIZE_LIMIT = 1000000;
    private static final BooleanNormalizer DEFAULT = new BooleanNormalizer(1000000, false, false);
    private final int sizeLimit;
    private final boolean checkForDuplicateConditions;
    private final boolean normalizeNestedFields;

    private BooleanNormalizer(int sizeLimit, boolean checkForDuplicateConditions, boolean normalizeNestedFields) {
        this.sizeLimit = sizeLimit;
        this.checkForDuplicateConditions = checkForDuplicateConditions;
        this.normalizeNestedFields = normalizeNestedFields;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"MS_EXPOSE_REP"}, justification="Value is not actually mutable")
    public static BooleanNormalizer getDefaultInstance() {
        return DEFAULT;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"MS_EXPOSE_REP"}, justification="Value is not actually mutable")
    public static BooleanNormalizer withLimit(int sizeLimit) {
        if (sizeLimit == 1000000) {
            return DEFAULT;
        }
        return new BooleanNormalizer(sizeLimit, false, false);
    }

    @Nonnull
    public BooleanNormalizer withUpdatedLimit(int sizeLimit) {
        if (sizeLimit == this.sizeLimit) {
            return this;
        }
        return new BooleanNormalizer(sizeLimit, this.checkForDuplicateConditions, this.normalizeNestedFields);
    }

    @SpotBugsSuppressWarnings(value={"MS_EXPOSE_REP"}, justification="Value is not actually mutable")
    public static BooleanNormalizer forConfiguration(RecordQueryPlannerConfiguration configuration) {
        if (configuration.getComplexityThreshold() == 1000000 && !configuration.shouldCheckForDuplicateConditions() && !configuration.shouldNormalizeNestedFields()) {
            return DEFAULT;
        }
        return new BooleanNormalizer(configuration.getComplexityThreshold(), configuration.shouldCheckForDuplicateConditions(), configuration.shouldNormalizeNestedFields());
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public boolean isCheckForDuplicateConditions() {
        return this.checkForDuplicateConditions;
    }

    @Nullable
    public QueryComponent normalizeIfPossible(@Nullable QueryComponent predicate) {
        return this.normalize(predicate, false);
    }

    @Nullable
    public QueryComponent normalize(@Nullable QueryComponent predicate) {
        return this.normalize(predicate, true);
    }

    @Nullable
    private QueryComponent normalize(@Nullable QueryComponent predicate, boolean failIfTooLarge) {
        if (!this.needsNormalize(predicate)) {
            return predicate;
        }
        if (!this.shouldNormalize(predicate)) {
            if (failIfTooLarge) {
                throw new DNFTooLargeException(predicate);
            }
            return predicate;
        }
        List<List<QueryComponent>> orOfAnd = this.toDNF(predicate, false, new ArrayDeque<String>());
        if (this.checkForDuplicateConditions) {
            this.removeDuplicateConditions(orOfAnd);
        }
        return this.normalOr(orOfAnd.stream().map(this::normalAnd).collect(Collectors.toList()));
    }

    private boolean needsNormalize(@Nullable QueryComponent predicate) {
        return predicate != null && this.depthAtLeast(predicate, 2, 0);
    }

    private boolean depthAtLeast(@Nonnull QueryComponent predicate, int target, int booleanDepthSoFar) {
        if (predicate instanceof BooleanComponent || this.normalizeNestedFields && predicate instanceof NestedField) {
            int newDepth = booleanDepthSoFar + 1;
            if (newDepth >= target) {
                return true;
            }
            if (predicate instanceof ComponentWithChildren) {
                return ((ComponentWithChildren)predicate).getChildren().stream().anyMatch(p -> this.depthAtLeast((QueryComponent)p, target, newDepth));
            }
            if (predicate instanceof ComponentWithSingleChild) {
                return this.depthAtLeast(((ComponentWithSingleChild)predicate).getChild(), target, newDepth);
            }
        }
        return false;
    }

    private boolean shouldNormalize(@Nullable QueryComponent predicate) {
        try {
            return this.getNormalizedSize(predicate) <= this.sizeLimit;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    int getNormalizedSize(@Nullable QueryComponent predicate) {
        if (predicate == null) {
            return 0;
        }
        return this.toDNFSize(predicate, false);
    }

    private int toDNFSize(@Nonnull QueryComponent predicate, boolean negate) {
        if (predicate instanceof AndComponent) {
            List children = ((AndComponent)predicate).getChildren();
            return negate ? this.orToDNFSize(children, true) : this.andToDNFSize(children, false);
        }
        if (predicate instanceof OrComponent) {
            List children = ((OrComponent)predicate).getChildren();
            return negate ? this.andToDNFSize(children, true) : this.orToDNFSize(children, false);
        }
        if (predicate instanceof NotComponent) {
            return this.toDNFSize(((NotComponent)predicate).getChild(), !negate);
        }
        if (this.normalizeNestedFields && predicate instanceof NestedField) {
            return this.toDNFSize(((NestedField)predicate).getChild(), negate);
        }
        return 1;
    }

    private int orToDNFSize(@Nonnull List<QueryComponent> children, boolean negate) {
        return children.stream().mapToInt(p -> this.toDNFSize((QueryComponent)p, negate)).reduce(0, Math::addExact);
    }

    private int andToDNFSize(@Nonnull List<QueryComponent> children, boolean negate) {
        return children.stream().mapToInt(child -> this.toDNFSize((QueryComponent)child, negate)).reduce(1, Math::multiplyExact);
    }

    @Nonnull
    private QueryComponent normalOr(@Nonnull List<QueryComponent> children) {
        if (children.size() == 1) {
            return children.get(0);
        }
        return OrComponent.from(children);
    }

    @Nonnull
    private QueryComponent normalAnd(@Nonnull List<QueryComponent> children) {
        if (children.size() == 1) {
            return children.get(0);
        }
        return AndComponent.from(children);
    }

    @Nonnull
    private List<List<QueryComponent>> toDNF(@Nonnull QueryComponent predicate, boolean negate, @Nonnull Deque<String> parentPath) {
        if (predicate instanceof AndComponent) {
            List children = ((AndComponent)predicate).getChildren();
            return negate ? this.orToDNF(children, true, parentPath) : this.andToDNF(children, false, parentPath);
        }
        if (predicate instanceof OrComponent) {
            List children = ((OrComponent)predicate).getChildren();
            return negate ? this.andToDNF(children, true, parentPath) : this.orToDNF(children, false, parentPath);
        }
        if (predicate instanceof NotComponent) {
            return this.toDNF(((NotComponent)predicate).getChild(), !negate, parentPath);
        }
        if (this.normalizeNestedFields && predicate instanceof NestedField) {
            return this.nestedFieldToDNF((NestedField)predicate, negate, parentPath);
        }
        QueryComponent predicateForNormalization = predicate;
        Iterator<String> pathIterator = parentPath.descendingIterator();
        while (pathIterator.hasNext()) {
            predicateForNormalization = new NestedField(pathIterator.next(), predicateForNormalization);
        }
        return Collections.singletonList(Collections.singletonList(negate ? Query.not(predicateForNormalization) : predicateForNormalization));
    }

    @Nonnull
    private List<List<QueryComponent>> orToDNF(@Nonnull List<QueryComponent> children, boolean negate, @Nonnull Deque<String> parentPath) {
        ArrayList<List<QueryComponent>> result = new ArrayList<List<QueryComponent>>();
        children.stream().map(p -> this.toDNF((QueryComponent)p, negate, parentPath)).forEach(result::addAll);
        return result;
    }

    @Nonnull
    private List<List<QueryComponent>> andToDNF(@Nonnull List<QueryComponent> children, boolean negate, @Nonnull Deque<String> parentPath) {
        return this.andToDNF(children, 0, negate, parentPath, Collections.singletonList(Collections.emptyList()));
    }

    @Nonnull
    private List<List<QueryComponent>> andToDNF(@Nonnull List<QueryComponent> children, int index, boolean negate, @Nonnull Deque<String> parentPath, @Nonnull List<List<QueryComponent>> crossProductSoFar) {
        if (index >= children.size()) {
            return crossProductSoFar;
        }
        return this.andToDNF(children, index + 1, negate, parentPath, this.toDNF(children.get(index), negate, parentPath).stream().flatMap(right -> crossProductSoFar.stream().map(left -> {
            ArrayList combined = new ArrayList(left);
            combined.addAll(right);
            return combined;
        })).collect(Collectors.toList()));
    }

    @Nonnull
    private List<List<QueryComponent>> nestedFieldToDNF(@Nonnull NestedField nestedField, boolean negate, @Nonnull Deque<String> parentPath) {
        String parentField = nestedField.getFieldName();
        parentPath.addLast(parentField);
        List<List<QueryComponent>> dnf = this.toDNF(nestedField.getChild(), negate, parentPath);
        parentPath.removeLast();
        return dnf;
    }

    private void removeDuplicateConditions(List<List<QueryComponent>> orOfAnd) {
        int size = orOfAnd.size();
        if (size < 2) {
            return;
        }
        int i = 0;
        block0: while (i < size) {
            HashSet ci = (HashSet)((Object)orOfAnd.get(i));
            if (ci.size() > 1) {
                ci = new HashSet(ci);
            }
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                Collection cj = orOfAnd.get(j);
                if (ci.size() <= cj.size() && (ci.size() != cj.size() || i >= j) || !ci.containsAll(cj)) continue;
                orOfAnd.remove(i);
                --size;
                continue block0;
            }
            ++i;
        }
    }

    class DNFTooLargeException
    extends RecordCoreException {
        private static final long serialVersionUID = 1L;

        public DNFTooLargeException(QueryComponent predicate) {
            super("tried to normalize to a DNF but the size would have been too big", new Object[0]);
            this.addLogInfo(new Object[]{LogMessageKeys.FILTER, predicate});
            this.addLogInfo(new Object[]{LogMessageKeys.DNF_SIZE_LIMIT, BooleanNormalizer.this.sizeLimit});
        }
    }
}

