/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class BooleanPredicateNormalizer {
    public static final int DEFAULT_SIZE_LIMIT = 1000000;
    private static final BooleanPredicateNormalizer DEFAULT_DNF = new BooleanPredicateNormalizer(Mode.DNF, 1000000);
    private static final BooleanPredicateNormalizer DEFAULT_CNF = new BooleanPredicateNormalizer(Mode.CNF, 1000000);
    @Nonnull
    private final Mode mode;
    private final int sizeLimit;

    private BooleanPredicateNormalizer(@Nonnull Mode mode, int sizeLimit) {
        this.mode = mode;
        this.sizeLimit = sizeLimit;
    }

    @Nonnull
    public static BooleanPredicateNormalizer getDefaultInstanceForDnf() {
        return DEFAULT_DNF;
    }

    @Nonnull
    public static BooleanPredicateNormalizer getDefaultInstanceForCnf() {
        return DEFAULT_CNF;
    }

    @Nonnull
    public static BooleanPredicateNormalizer withLimit(@Nonnull Mode mode, int sizeLimit) {
        if (sizeLimit == 1000000) {
            return BooleanPredicateNormalizer.getDefaultInstance(mode);
        }
        return new BooleanPredicateNormalizer(mode, sizeLimit);
    }

    @Nonnull
    private static BooleanPredicateNormalizer getDefaultInstance(@Nonnull Mode mode) {
        return mode == Mode.CNF ? DEFAULT_CNF : DEFAULT_DNF;
    }

    public static BooleanPredicateNormalizer forConfiguration(@Nonnull Mode mode, @Nonnull RecordQueryPlannerConfiguration configuration) {
        if (configuration.getComplexityThreshold() == 1000000) {
            return BooleanPredicateNormalizer.getDefaultInstance(mode);
        }
        return new BooleanPredicateNormalizer(mode, configuration.getComplexityThreshold());
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    @Nonnull
    public Optional<QueryPredicate> normalizeAndSimplify(@Nullable QueryPredicate predicate, boolean failIfTooLarge) {
        return this.normalizeInternal(predicate, failIfTooLarge).map(majorOfMinor -> {
            List<Collection<? extends QueryPredicate>> absorbed = BooleanPredicateNormalizer.applyAbsorptionLaw(majorOfMinor);
            return this.mode.majorWithChildren(absorbed.stream().map(this.mode::minorWithChildren).collect(Collectors.toList()));
        });
    }

    @Nonnull
    public Optional<QueryPredicate> normalize(@Nullable QueryPredicate predicate, boolean failIfTooLarge) {
        return this.normalizeInternal(predicate, failIfTooLarge).map(majorOfMinor -> this.mode.majorWithChildren(majorOfMinor.stream().map(this.mode::minorWithChildren).collect(Collectors.toList())));
    }

    @Nonnull
    private Optional<List<Collection<? extends QueryPredicate>>> normalizeInternal(@Nullable QueryPredicate predicate, boolean failIfTooLarge) {
        if (this.isInNormalForm(predicate)) {
            return Optional.empty();
        }
        if (!this.shouldNormalize(predicate)) {
            if (failIfTooLarge) {
                throw new NormalFormTooLargeException(Objects.requireNonNull(predicate));
            }
            return Optional.empty();
        }
        return Optional.of(this.toNormalized(Objects.requireNonNull(predicate), false));
    }

    private boolean isInNormalForm(@Nullable QueryPredicate predicate) {
        if (predicate == null) {
            return true;
        }
        if (BooleanPredicateNormalizer.isNormalFormVariableOrNotPredicate(predicate)) {
            return true;
        }
        if (predicate instanceof AndOrPredicate) {
            Iterable children = ((AndOrPredicate)predicate).getChildren();
            if (this.mode.instanceOfMajorClass(predicate)) {
                return children.stream().allMatch(child -> {
                    if (BooleanPredicateNormalizer.isNormalFormVariableOrNotPredicate(child)) {
                        return true;
                    }
                    if (this.mode.instanceOfMinorClass((QueryPredicate)child)) {
                        return ((AndOrPredicate)child).getChildren().stream().allMatch(BooleanPredicateNormalizer::isNormalFormVariableOrNotPredicate);
                    }
                    return false;
                });
            }
            if (this.mode.instanceOfMinorClass(predicate)) {
                return children.stream().allMatch(BooleanPredicateNormalizer::isNormalFormVariableOrNotPredicate);
            }
        }
        if (predicate instanceof NotPredicate) {
            return false;
        }
        throw new RecordCoreException("unknown boolean expression", new Object[0]);
    }

    private boolean shouldNormalize(@Nullable QueryPredicate predicate) {
        try {
            return this.getNormalizedSize(predicate) <= (long)this.sizeLimit;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    long getNormalizedSize(@Nullable QueryPredicate predicate) {
        if (predicate == null) {
            return 0L;
        }
        return this.getMetrics(predicate).getNormalFormSize();
    }

    @Nonnull
    public PredicateMetrics getMetrics(@Nullable QueryPredicate predicate) {
        if (predicate == null) {
            return new PredicateMetrics(0L, 0L, 0);
        }
        return this.getMetrics(predicate, false);
    }

    private PredicateMetrics getMetrics(@Nonnull QueryPredicate predicate, boolean negate) {
        if (this.mode.instanceOfMinorClass(predicate)) {
            Iterable children = ((AndOrPredicate)predicate).getChildren();
            PredicateMetrics metricsFromChildren = negate ? this.getMetricsForMajor((List<? extends QueryPredicate>)children, true) : this.getMetricsForMinor((List<? extends QueryPredicate>)children, false);
            return predicate.isAtomic() ? new PredicateMetrics(1L, metricsFromChildren.getNormalFormFullSize(), 1) : metricsFromChildren;
        }
        if (this.mode.instanceOfMajorClass(predicate)) {
            Iterable children = ((AndOrPredicate)predicate).getChildren();
            PredicateMetrics metricsFromChildren = negate ? this.getMetricsForMinor((List<? extends QueryPredicate>)children, true) : this.getMetricsForMajor((List<? extends QueryPredicate>)children, false);
            return predicate.isAtomic() ? new PredicateMetrics(1L, metricsFromChildren.getNormalFormFullSize(), 1) : metricsFromChildren;
        }
        if (predicate instanceof NotPredicate) {
            PredicateMetrics metricsFromChildren = this.getMetrics(((NotPredicate)predicate).getChild(), !negate);
            return predicate.isAtomic() ? new PredicateMetrics(1L, metricsFromChildren.getNormalFormFullSize(), 1) : metricsFromChildren;
        }
        return new PredicateMetrics(1L, 1L, 1);
    }

    private PredicateMetrics getMetricsForMajor(@Nonnull List<? extends QueryPredicate> children, boolean negate) {
        long normalFormSize = 0L;
        long normalFormFullSize = 0L;
        int normalFormMaximumNumMinors = 0;
        for (QueryPredicate queryPredicate : children) {
            PredicateMetrics childMetrics = this.getMetrics(queryPredicate, negate);
            normalFormSize = Math.addExact(normalFormSize, childMetrics.getNormalFormSize());
            normalFormFullSize = Math.addExact(normalFormFullSize, childMetrics.getNormalFormFullSize());
            normalFormMaximumNumMinors = Math.max(normalFormMaximumNumMinors, childMetrics.getNormalFormMaximumNumMinors());
        }
        return new PredicateMetrics(normalFormSize, normalFormFullSize, normalFormMaximumNumMinors);
    }

    private PredicateMetrics getMetricsForMinor(@Nonnull List<? extends QueryPredicate> children, boolean negate) {
        long normalFormSize = 1L;
        long normalFormFullSize = 1L;
        int normalFormMaximumNumMinors = 0;
        for (QueryPredicate queryPredicate : children) {
            PredicateMetrics childMetrics = this.getMetrics(queryPredicate, negate);
            normalFormSize = Math.multiplyExact(normalFormSize, childMetrics.getNormalFormSize());
            normalFormFullSize = Math.multiplyExact(normalFormFullSize, childMetrics.getNormalFormFullSize());
            normalFormMaximumNumMinors = Math.addExact(normalFormMaximumNumMinors, childMetrics.getNormalFormMaximumNumMinors());
        }
        return new PredicateMetrics(normalFormSize, normalFormFullSize, normalFormMaximumNumMinors);
    }

    @Nonnull
    private List<Collection<? extends QueryPredicate>> toNormalized(@Nonnull QueryPredicate predicate, boolean negate) {
        if (!predicate.isAtomic()) {
            if (this.mode.instanceOfMinorClass(predicate)) {
                Iterable children = ((AndOrPredicate)predicate).getChildren();
                return negate ? this.majorToNormalized((List<? extends QueryPredicate>)children, true) : this.minorToNormalized((List<? extends QueryPredicate>)children, false);
            }
            if (this.mode.instanceOfMajorClass(predicate)) {
                Iterable children = ((AndOrPredicate)predicate).getChildren();
                return negate ? this.minorToNormalized((List<? extends QueryPredicate>)children, true) : this.majorToNormalized((List<? extends QueryPredicate>)children, false);
            }
            if (predicate instanceof NotPredicate) {
                return this.toNormalized(((NotPredicate)predicate).getChild(), !negate);
            }
        }
        return Collections.singletonList(Collections.singletonList(negate ? NotPredicate.not(predicate) : predicate));
    }

    @Nonnull
    private List<Collection<? extends QueryPredicate>> majorToNormalized(@Nonnull List<? extends QueryPredicate> children, boolean negate) {
        ArrayList<Collection<? extends QueryPredicate>> result = new ArrayList<Collection<? extends QueryPredicate>>();
        children.stream().map(p -> this.toNormalized((QueryPredicate)p, negate)).forEach(result::addAll);
        return result;
    }

    @Nonnull
    private List<Collection<? extends QueryPredicate>> minorToNormalized(@Nonnull List<? extends QueryPredicate> children, boolean negate) {
        return this.minorToNormalized(children, 0, negate, Collections.singletonList(Collections.emptyList()));
    }

    @Nonnull
    private List<Collection<? extends QueryPredicate>> minorToNormalized(@Nonnull List<? extends QueryPredicate> children, int index, boolean negate, @Nonnull List<Collection<? extends QueryPredicate>> crossProductSoFar) {
        if (index >= children.size()) {
            return crossProductSoFar;
        }
        return this.minorToNormalized(children, index + 1, negate, this.toNormalized(children.get(index), negate).stream().flatMap(right -> crossProductSoFar.stream().map(left -> {
            ArrayList combined = new ArrayList(left);
            combined.addAll(right);
            return combined;
        })).collect(Collectors.toList()));
    }

    public static List<Collection<? extends QueryPredicate>> applyAbsorptionLaw(List<Collection<? extends QueryPredicate>> majorOfMinor) {
        int size = majorOfMinor.size();
        if (size < 2) {
            return majorOfMinor;
        }
        ArrayList<Collection<? extends QueryPredicate>> absorbed = Lists.newArrayList();
        for (Collection<? extends QueryPredicate> minors : majorOfMinor) {
            absorbed.add(Sets.newLinkedHashSet(minors));
        }
        int i = 0;
        block1: while (i < size) {
            Collection ci = (Collection)absorbed.get(i);
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                Collection cj = (Collection)absorbed.get(j);
                if (ci.size() <= cj.size() && (ci.size() != cj.size() || i >= j) || !ci.containsAll(cj)) continue;
                absorbed.remove(i);
                --size;
                continue block1;
            }
            ++i;
        }
        return absorbed;
    }

    private static boolean isNormalFormVariable(@Nonnull QueryPredicate queryPredicate) {
        return queryPredicate.isAtomic() || queryPredicate instanceof LeafQueryPredicate;
    }

    private static boolean isNormalFormVariableOrNotPredicate(@Nonnull QueryPredicate queryPredicate) {
        if (BooleanPredicateNormalizer.isNormalFormVariable(queryPredicate)) {
            return true;
        }
        if (queryPredicate instanceof NotPredicate) {
            return BooleanPredicateNormalizer.isNormalFormVariable(((NotPredicate)queryPredicate).getChild());
        }
        return false;
    }

    @SpotBugsSuppressWarnings(justification="https://github.com/spotbugs/spotbugs/issues/740", value={"SE_BAD_FIELD"})
    public static enum Mode {
        DNF(OrPredicate.class, OrPredicate::or, AndPredicate.class, AndPredicate::and),
        CNF(AndPredicate.class, AndPredicate::and, OrPredicate.class, OrPredicate::or);

        @Nonnull
        private final Class<? extends AndOrPredicate> majorClass;
        @Nonnull
        private final Function<Collection<? extends QueryPredicate>, QueryPredicate> majorGenerator;
        @Nonnull
        private final Class<? extends AndOrPredicate> minorClass;
        @Nonnull
        private final Function<Collection<? extends QueryPredicate>, QueryPredicate> minorGenerator;

        private Mode(@Nonnull Class<? extends AndOrPredicate> majorClass, @Nonnull Function<Collection<? extends QueryPredicate>, QueryPredicate> majorGenerator, Class<? extends AndOrPredicate> minorClass, Function<Collection<? extends QueryPredicate>, QueryPredicate> minorGenerator) {
            this.majorClass = majorClass;
            this.majorGenerator = majorGenerator;
            this.minorClass = minorClass;
            this.minorGenerator = minorGenerator;
        }

        public boolean instanceOfMajorClass(@Nullable QueryPredicate andOrPredicate) {
            return this.majorClass.isInstance(andOrPredicate);
        }

        public boolean instanceOfMinorClass(@Nullable QueryPredicate andOrPredicate) {
            return this.minorClass.isInstance(andOrPredicate);
        }

        @Nonnull
        public QueryPredicate majorWithChildren(@Nonnull Collection<? extends QueryPredicate> children) {
            return this.majorGenerator.apply(children);
        }

        @Nonnull
        public QueryPredicate minorWithChildren(@Nonnull Collection<? extends QueryPredicate> children) {
            return this.minorGenerator.apply(children);
        }
    }

    class NormalFormTooLargeException
    extends RecordCoreException {
        private static final long serialVersionUID = 1L;

        public NormalFormTooLargeException(QueryPredicate predicate) {
            super("tried to normalize to a normal form but the size would have been too big", new Object[0]);
            this.addLogInfo(new Object[]{LogMessageKeys.FILTER, predicate});
            this.addLogInfo(new Object[]{LogMessageKeys.DNF_SIZE_LIMIT, BooleanPredicateNormalizer.this.sizeLimit});
        }
    }

    public static class PredicateMetrics {
        private final long normalFormSize;
        private final long normalFormFullSize;
        private final int normalFormMaximumNumMinors;

        public PredicateMetrics(long normalFormSize, long normalFormFullSize, int normalFormMaximumNumMinors) {
            this.normalFormSize = normalFormSize;
            this.normalFormFullSize = normalFormFullSize;
            this.normalFormMaximumNumMinors = normalFormMaximumNumMinors;
        }

        public long getNormalFormSize() {
            return this.normalFormSize;
        }

        public long getNormalFormFullSize() {
            return this.normalFormFullSize;
        }

        public int getNormalFormMaximumNumMinors() {
            return this.normalFormMaximumNumMinors;
        }
    }
}

