/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.OrComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class FilterSatisfiedMask {
    @Nonnull
    private final QueryComponent filter;
    @Nonnull
    private final List<FilterSatisfiedMask> children;
    private boolean satisfied;
    @Nullable
    private KeyExpression expression;

    private FilterSatisfiedMask(@Nonnull QueryComponent filter, @Nonnull List<FilterSatisfiedMask> children, boolean satisfied) {
        this.filter = filter;
        this.children = children;
        this.satisfied = satisfied;
        this.expression = null;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    @Nullable
    public KeyExpression getExpression() {
        return this.expression;
    }

    public void setExpression(@Nullable KeyExpression expression) {
        this.expression = expression;
    }

    @Nonnull
    public QueryComponent getFilter() {
        return this.filter;
    }

    @Nonnull
    public List<FilterSatisfiedMask> getChildren() {
        return this.children;
    }

    @Nonnull
    public FilterSatisfiedMask getChild(@Nonnull QueryComponent childFilter) {
        for (FilterSatisfiedMask child : this.children) {
            if (child.getFilter() != childFilter) continue;
            return child;
        }
        throw new FilterNotFoundException(childFilter);
    }

    public void reset() {
        this.setSatisfied(false);
        this.setExpression(null);
        if (!this.children.isEmpty()) {
            this.children.forEach(FilterSatisfiedMask::reset);
        }
    }

    @Nonnull
    public List<QueryComponent> getUnsatisfiedFilters() {
        if (this.isSatisfied()) {
            return Collections.emptyList();
        }
        QueryComponent unsatisfiedFilter = this.getUnsatisfiedFilter();
        if (unsatisfiedFilter == null) {
            return Collections.emptyList();
        }
        if (unsatisfiedFilter instanceof AndComponent) {
            return ((AndComponent)unsatisfiedFilter).getChildren();
        }
        return Collections.singletonList(unsatisfiedFilter);
    }

    @Nullable
    public QueryComponent getUnsatisfiedFilter() {
        if (this.isSatisfied()) {
            return null;
        }
        if (this.filter instanceof NestedField) {
            return this.getUnsatisfiedFilter((NestedField)this.filter);
        }
        if (this.filter instanceof OneOfThemWithComponent) {
            return this.getUnsatisfiedFilter((OneOfThemWithComponent)this.filter);
        }
        if (this.filter instanceof AndComponent) {
            return this.getUnsatisfiedFilter((AndComponent)this.filter);
        }
        if (this.filter instanceof OrComponent) {
            return this.getUnsatisfiedFilter((OrComponent)this.filter);
        }
        return this.filter;
    }

    @Nullable
    private QueryComponent getUnsatisfiedFilter(@Nonnull NestedField filter) {
        if (this.children.isEmpty()) {
            throw new RecordCoreException("nested filter has no child masks", new Object[]{LogMessageKeys.PARENT_FILTER, filter});
        }
        QueryComponent newChildFilter = this.children.get(0).getUnsatisfiedFilter();
        if (newChildFilter == null) {
            this.setSatisfied(true);
            return null;
        }
        if (newChildFilter == filter.getChild()) {
            return filter;
        }
        return new NestedField(filter.getFieldName(), newChildFilter);
    }

    @Nullable
    private QueryComponent getUnsatisfiedFilter(@Nonnull OneOfThemWithComponent filter) {
        if (this.children.isEmpty()) {
            throw new RecordCoreException("nested filter has no child masks", new Object[]{LogMessageKeys.PARENT_FILTER, filter});
        }
        QueryComponent newChildFilter = this.children.get(0).getUnsatisfiedFilter();
        if (newChildFilter == null) {
            this.setSatisfied(true);
            return null;
        }
        return filter;
    }

    @Nullable
    private QueryComponent getUnsatisfiedFilter(@Nonnull AndComponent filter) {
        ArrayList<QueryComponent> unsatisfiedChildren = new ArrayList<QueryComponent>(this.children.size());
        for (FilterSatisfiedMask child : this.children) {
            QueryComponent newChildFilter = child.getUnsatisfiedFilter();
            if (newChildFilter == null) continue;
            unsatisfiedChildren.add(newChildFilter);
        }
        if (unsatisfiedChildren.isEmpty()) {
            this.setSatisfied(true);
            return null;
        }
        if (unsatisfiedChildren.size() == this.children.size()) {
            return filter;
        }
        if (unsatisfiedChildren.size() == 1) {
            return (QueryComponent)unsatisfiedChildren.get(0);
        }
        return AndComponent.from(unsatisfiedChildren);
    }

    @Nullable
    private QueryComponent getUnsatisfiedFilter(@Nonnull OrComponent filter) {
        boolean allSatisfied = this.children.stream().map(FilterSatisfiedMask::getUnsatisfiedFilter).allMatch(Objects::isNull);
        if (allSatisfied) {
            this.setSatisfied(true);
            return null;
        }
        return filter;
    }

    public boolean allSatisfied() {
        if (this.isSatisfied()) {
            return true;
        }
        if (this.filter instanceof AndComponent || this.filter instanceof NestedField || this.filter instanceof OneOfThemWithComponent || this.filter instanceof OrComponent) {
            return this.getChildren().stream().allMatch(FilterSatisfiedMask::allSatisfied);
        }
        return false;
    }

    public void mergeWith(@Nonnull FilterSatisfiedMask other) {
        if (other.getFilter() != this.getFilter()) {
            throw new FilterMismatchException(other.getFilter());
        }
        if (!this.children.isEmpty()) {
            Iterator<FilterSatisfiedMask> otherChildren = other.getChildren().iterator();
            for (FilterSatisfiedMask child : this.getChildren()) {
                if (!otherChildren.hasNext()) {
                    throw new RecordCoreException("insufficient children included in other filter mask", new Object[]{LogMessageKeys.FILTER, this.filter, LogMessageKeys.OTHER_FILTER, other.getFilter()});
                }
                child.mergeWith(otherChildren.next());
            }
            if (otherChildren.hasNext()) {
                throw new RecordCoreException("extraneous children included in other filter mask", new Object[]{LogMessageKeys.FILTER, this.filter, LogMessageKeys.OTHER_FILTER, other.getFilter()});
            }
        } else if (!other.getChildren().isEmpty()) {
            throw new RecordCoreException("extraneous children included in other filter mask", new Object[]{LogMessageKeys.FILTER, this.filter, LogMessageKeys.OTHER_FILTER, other.getFilter()});
        }
        if (other.isSatisfied()) {
            this.setSatisfied(true);
        }
        if (other.getExpression() != null) {
            this.setExpression(other.getExpression());
        }
    }

    public String toString() {
        return "FilterSatisfiedMask(" + String.valueOf(this.getFilter()) + ")";
    }

    @Nonnull
    public static FilterSatisfiedMask of(@Nonnull QueryComponent filter) {
        List<FilterSatisfiedMask> children;
        if (filter instanceof ComponentWithSingleChild) {
            children = Collections.singletonList(FilterSatisfiedMask.of(((ComponentWithSingleChild)filter).getChild()));
        } else if (filter instanceof ComponentWithChildren) {
            List<QueryComponent> filterChildren = ((ComponentWithChildren)filter).getChildren();
            children = new ArrayList(filterChildren.size());
            for (QueryComponent childFilter : filterChildren) {
                children.add(FilterSatisfiedMask.of(childFilter));
            }
        } else {
            children = Collections.emptyList();
        }
        return new FilterSatisfiedMask(filter, children, false);
    }

    public class FilterNotFoundException
    extends RecordCoreException {
        static final long serialVersionUID = 1L;

        private FilterNotFoundException(QueryComponent childFilter) {
            super("child filter not found", new Object[]{LogMessageKeys.PARENT_FILTER, FilterSatisfiedMask.this.filter, LogMessageKeys.CHILD_FILTER, childFilter});
        }
    }

    public class FilterMismatchException
    extends RecordCoreException {
        static final long serialVersionUID = 1L;

        private FilterMismatchException(QueryComponent otherFilter) {
            super("filter from other mask does not match mask filter", new Object[]{LogMessageKeys.FILTER, FilterSatisfiedMask.this.filter, LogMessageKeys.OTHER_FILTER, otherFilter});
        }
    }
}

