/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
class GroupingValidator {
    static boolean findGroupKeyFilters(@Nonnull List<QueryComponent> filters, @Nonnull KeyExpression groupKey, @Nonnull List<QueryComponent> groupFilters, @Nonnull List<Comparisons.Comparison> groupComparisons) {
        if (groupKey.getColumnSize() == 0) {
            return true;
        }
        if (groupKey instanceof ThenKeyExpression) {
            for (KeyExpression subKey : ((ThenKeyExpression)groupKey).getChildren()) {
                if (GroupingValidator.findGroupKeyFilters(filters, subKey, groupFilters, groupComparisons)) continue;
                return false;
            }
            return true;
        }
        return groupKey instanceof FieldKeyExpression && GroupingValidator.findGroupFieldFilter(filters, (FieldKeyExpression)groupKey, groupFilters, groupComparisons) || groupKey instanceof NestingKeyExpression && GroupingValidator.findNestingFilter(filters, (NestingKeyExpression)groupKey, groupFilters, groupComparisons);
    }

    private static boolean findGroupFieldFilter(@Nonnull List<QueryComponent> filters, @Nonnull FieldKeyExpression groupField, @Nonnull List<QueryComponent> groupFilters, @Nonnull List<Comparisons.Comparison> groupComparisons) {
        for (QueryComponent filter : filters) {
            FieldWithComparison comparisonFilter;
            if (!(filter instanceof FieldWithComparison) || !(comparisonFilter = (FieldWithComparison)filter).getFieldName().equals(groupField.getFieldName()) || comparisonFilter.getComparison().getType() != Comparisons.Type.EQUALS && comparisonFilter.getComparison().getType() != Comparisons.Type.IS_NULL) continue;
            groupFilters.add(filter);
            groupComparisons.add(comparisonFilter.getComparison());
            return true;
        }
        return false;
    }

    private static boolean findNestingFilter(@Nonnull List<QueryComponent> filters, @Nonnull NestingKeyExpression nesting, @Nonnull List<QueryComponent> groupFilters, @Nonnull List<Comparisons.Comparison> groupComparisons) {
        FieldKeyExpression parentFieldKey = nesting.getParent();
        for (QueryComponent filter : filters) {
            if (!(filter instanceof NestedField) && !(filter instanceof OneOfThemWithComponent) || !parentFieldKey.getFieldName().equals(((BaseField)filter).getFieldName()) || !GroupingValidator.matchNestingField(filter, (ComponentWithSingleChild)filter, nesting, groupFilters, groupComparisons)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchNestingField(@Nonnull QueryComponent filter, @Nonnull ComponentWithSingleChild nestingComponent, @Nonnull NestingKeyExpression nesting, @Nonnull List<QueryComponent> groupFilters, @Nonnull List<Comparisons.Comparison> groupComparisons) {
        if (nesting.getChild() instanceof NestingKeyExpression) {
            NestingKeyExpression childNesting = (NestingKeyExpression)nesting.getChild();
            QueryComponent childComponent = nestingComponent.getChild();
            if ((childComponent instanceof NestedField || childComponent instanceof OneOfThemWithComponent) && childNesting.getParent().getFieldName().equals(((BaseField)childComponent).getFieldName()) && GroupingValidator.matchNestingField(filter, (ComponentWithSingleChild)childComponent, childNesting, groupFilters, groupComparisons)) {
                return true;
            }
        } else if (nesting.getChild() instanceof FieldKeyExpression) {
            FieldWithComparison comparisonFilter;
            FieldKeyExpression childField = (FieldKeyExpression)nesting.getChild();
            if (nestingComponent.getChild() instanceof FieldWithComparison && (comparisonFilter = (FieldWithComparison)nestingComponent.getChild()).getFieldName().equals(childField.getFieldName()) && (comparisonFilter.getComparison().getType() == Comparisons.Type.EQUALS || comparisonFilter.getComparison().getType() == Comparisons.Type.IS_NULL)) {
                groupFilters.add(filter);
                groupComparisons.add(comparisonFilter.getComparison());
                return true;
            }
        }
        return false;
    }

    private GroupingValidator() {
    }
}

