/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.ComponentWithNoChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComparison;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlanOrderingKey;
import com.apple.foundationdb.record.query.plan.plans.InComparandSource;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class InExtractor {
    @Nonnull
    private final QueryComponent filter;
    @Nonnull
    private final List<InClause> inClauses;
    @Nonnull
    private QueryComponent subFilter;

    public InExtractor(@Nonnull InExtractor other) {
        this(other.filter, Lists.newArrayList(other.inClauses), other.subFilter);
    }

    private InExtractor(@Nonnull QueryComponent filter, @Nonnull List<InClause> inClauses, @Nonnull QueryComponent subFilter) {
        this.filter = filter;
        this.inClauses = inClauses;
        this.subFilter = subFilter;
    }

    @Nonnull
    public QueryComponent getFilter() {
        return this.filter;
    }

    @Nonnull
    public QueryComponent getSubFilter() {
        return this.subFilter;
    }

    @Nonnull
    public Set<String> getInBindings() {
        return this.inClauses.stream().map(inClause -> inClause.bindingName).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public QueryComponent asOr() {
        return InExtractor.mapClauses(this.filter, (withComparison, fields) -> {
            if (withComparison.getComparison().getType() == Comparisons.Type.IN) {
                if (withComparison.getComparison() instanceof Comparisons.ParameterComparison) {
                    return withComparison;
                }
                List comparands = Verify.verifyNotNull((List)withComparison.getComparison().getComparand());
                ArrayList<QueryComponent> orBranches = new ArrayList<QueryComponent>();
                for (Object comparand : comparands) {
                    orBranches.add(withComparison.withOtherComparison(new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, comparand)));
                }
                if (orBranches.size() == 1) {
                    return (QueryComponent)orBranches.get(0);
                }
                return Query.or(orBranches);
            }
            return withComparison;
        }, Collections.emptyList());
    }

    @Nullable
    private static KeyExpression getOrderingKey(List<FieldKeyExpression> fields) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        KeyExpression key = fields.get(fields.size() - 1);
        for (int i = fields.size() - 2; i >= 0; --i) {
            key = new NestingKeyExpression(fields.get(i), key);
        }
        return key;
    }

    public QueryComponent subFilter() {
        return this.subFilter;
    }

    public boolean setSort(@Nonnull KeyExpression key, boolean reverse) {
        if (this.inClauses.isEmpty()) {
            return true;
        }
        List<KeyExpression> sortComponents = key.normalizeKeyForPositions();
        for (int i = 0; i < sortComponents.size() && i < this.inClauses.size(); ++i) {
            KeyExpression sortComponent = sortComponents.get(i);
            boolean found = false;
            for (int j = i; j < this.inClauses.size(); ++j) {
                InClause inClause = this.inClauses.get(j);
                if (!sortComponent.equals(inClause.orderingKey)) continue;
                if (i != j) {
                    this.inClauses.remove(j);
                    this.inClauses.add(i, inClause);
                }
                inClause.sortValues = true;
                inClause.sortReverse = reverse;
                found = true;
                break;
            }
            if (found) continue;
            this.cancel();
            return false;
        }
        return true;
    }

    public void sortByClauses() {
        for (InClause inClause : this.inClauses) {
            inClause.sortValues = true;
        }
    }

    public void cancel() {
        this.inClauses.clear();
        this.subFilter = this.filter;
    }

    @Nonnull
    public RecordQueryPlan wrap(RecordQueryPlan plan) {
        for (int i = this.inClauses.size() - 1; i >= 0; --i) {
            plan = this.inClauses.get(i).wrap(plan);
        }
        return plan;
    }

    @Nullable
    public PlanOrderingKey adjustOrdering(@Nullable PlanOrderingKey ordering, boolean asPrefix) {
        if (ordering == null || this.inClauses.isEmpty()) {
            return ordering;
        }
        ArrayList<KeyExpression> keys = new ArrayList<KeyExpression>(ordering.getKeys());
        int prefixSize = ordering.getPrefixSize();
        int primaryKeyStart = ordering.getPrimaryKeyStart();
        int primaryKeyTailFromEnd = keys.size() - ordering.getPrimaryKeyTail();
        for (int i = 0; i < this.inClauses.size(); ++i) {
            KeyExpression inOrdering = this.inClauses.get((int)i).orderingKey;
            if (inOrdering == null) {
                return null;
            }
            int position = keys.indexOf(inOrdering);
            if (position >= 0) {
                if (position < prefixSize) {
                    --prefixSize;
                }
                keys.remove(position);
            }
            keys.add(prefixSize + i, inOrdering);
            if (!asPrefix) continue;
            ++prefixSize;
        }
        return new PlanOrderingKey(keys, prefixSize, primaryKeyStart, keys.size() - primaryKeyTailFromEnd);
    }

    @Nonnull
    public List<InSource> unionSources() {
        return this.inClauses.stream().map(InClause::unionSource).collect(Collectors.toList());
    }

    public InExtractor filter(@Nonnull BiPredicate<ComponentWithComparison, String> inBindingFilter) {
        return InExtractor.fromFilter(this.filter, inBindingFilter);
    }

    @Nonnull
    public static InExtractor fromFilter(@Nonnull QueryComponent filter, @Nonnull BiPredicate<ComponentWithComparison, String> inBindingFilter) {
        AtomicInteger bindingIndex = new AtomicInteger();
        ArrayList<InClause> inClauses = Lists.newArrayList();
        QueryComponent subFilter = InExtractor.mapClauses(filter, (withComparison, fields) -> {
            String bindingName;
            if (withComparison.getComparison().getType() == Comparisons.Type.IN && inBindingFilter.test((ComponentWithComparison)withComparison, bindingName = Bindings.Internal.IN.bindingName(withComparison.getName() + "__" + bindingIndex.getAndIncrement()))) {
                ArrayList<FieldKeyExpression> nestedFields = null;
                if (fields != null && (withComparison instanceof FieldWithComparison || withComparison instanceof OneOfThemWithComparison)) {
                    nestedFields = new ArrayList<FieldKeyExpression>((Collection<FieldKeyExpression>)fields);
                    nestedFields.add(Key.Expressions.field(((BaseField)((Object)withComparison)).getFieldName(), withComparison instanceof FieldWithComparison ? KeyExpression.FanType.None : KeyExpression.FanType.FanOut));
                }
                KeyExpression orderingKey = InExtractor.getOrderingKey(nestedFields);
                if (withComparison.getComparison() instanceof Comparisons.ComparisonWithParameter) {
                    String parameterName = ((Comparisons.ComparisonWithParameter)withComparison.getComparison()).getParameter();
                    inClauses.add(new InParameterClause(bindingName, parameterName, orderingKey));
                } else if (withComparison.getComparison() instanceof Comparisons.ListComparison || withComparison.getComparison() instanceof Comparisons.SimpleComparison) {
                    List comparand = (List)withComparison.getComparison().getComparand();
                    if (comparand != null && comparand.size() == 1) {
                        return withComparison.withOtherComparison(new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, comparand.get(0)));
                    }
                    inClauses.add(new InValuesClause(bindingName, comparand, orderingKey));
                } else {
                    inClauses.add(new InComparandClause(bindingName, withComparison.getComparison(), orderingKey));
                }
                return withComparison.withOtherComparison(new Comparisons.ParameterComparison(Comparisons.Type.EQUALS, bindingName, Bindings.Internal.IN));
            }
            return withComparison;
        }, Collections.emptyList());
        return new InExtractor(filter, inClauses, subFilter);
    }

    @Nonnull
    private static QueryComponent mapClauses(QueryComponent filter, BiFunction<ComponentWithComparison, List<FieldKeyExpression>, QueryComponent> mapper, @Nullable List<FieldKeyExpression> fields) {
        if (filter instanceof ComponentWithComparison) {
            ComponentWithComparison withComparison = (ComponentWithComparison)filter;
            return mapper.apply(withComparison, fields);
        }
        if (filter instanceof ComponentWithChildren) {
            ComponentWithChildren componentWithChildren = (ComponentWithChildren)filter;
            return componentWithChildren.withOtherChildren(componentWithChildren.getChildren().stream().map(component -> InExtractor.mapClauses(component, mapper, fields)).collect(Collectors.toList()));
        }
        if (filter instanceof ComponentWithSingleChild) {
            ComponentWithSingleChild componentWithSingleChild = (ComponentWithSingleChild)filter;
            ArrayList<FieldKeyExpression> nestedFields = null;
            if (fields != null && (componentWithSingleChild instanceof NestedField || componentWithSingleChild instanceof OneOfThemWithComponent)) {
                nestedFields = new ArrayList<FieldKeyExpression>(fields);
                nestedFields.add(Key.Expressions.field(((BaseField)((Object)componentWithSingleChild)).getFieldName(), componentWithSingleChild instanceof NestedField ? KeyExpression.FanType.None : KeyExpression.FanType.FanOut));
            }
            return componentWithSingleChild.withOtherChild(InExtractor.mapClauses(componentWithSingleChild.getChild(), mapper, nestedFields));
        }
        if (filter instanceof ComponentWithNoChildren) {
            return filter;
        }
        throw new Query.InvalidExpressionException("Unsupported query type " + String.valueOf(filter.getClass()));
    }

    static abstract class InClause {
        @Nonnull
        protected final String bindingName;
        @Nullable
        protected final KeyExpression orderingKey;
        protected boolean sortValues;
        protected boolean sortReverse;

        protected InClause(@Nonnull String bindingName, @Nullable KeyExpression orderingKey) {
            this.bindingName = bindingName;
            this.orderingKey = orderingKey;
        }

        protected abstract RecordQueryPlan wrap(RecordQueryPlan var1);

        protected abstract InSource unionSource();
    }

    static class InParameterClause
    extends InClause {
        @Nonnull
        private final String parameterName;

        protected InParameterClause(@Nonnull String bindingName, @Nonnull String parameterName, @Nullable KeyExpression orderingKey) {
            super(bindingName, orderingKey);
            this.parameterName = parameterName;
        }

        @Override
        protected RecordQueryPlan wrap(RecordQueryPlan inner) {
            return new RecordQueryInParameterJoinPlan(inner, this.bindingName, Bindings.Internal.IN, this.parameterName, this.sortValues, this.sortReverse);
        }

        @Override
        protected InSource unionSource() {
            return new InParameterSource(this.bindingName, this.parameterName);
        }
    }

    static class InValuesClause
    extends InClause {
        @Nullable
        private final List<Object> values;

        protected InValuesClause(@Nonnull String bindingName, @Nullable List<Object> values, @Nullable KeyExpression orderingKey) {
            super(bindingName, orderingKey);
            this.values = values;
        }

        @Override
        protected RecordQueryPlan wrap(RecordQueryPlan inner) {
            return new RecordQueryInValuesJoinPlan(inner, this.bindingName, Bindings.Internal.IN, this.values == null ? ImmutableList.of() : this.values, this.sortValues, this.sortReverse);
        }

        @Override
        protected InSource unionSource() {
            return new InValuesSource(this.bindingName, Objects.requireNonNullElse(this.values, ImmutableList.of()));
        }
    }

    static class InComparandClause
    extends InClause {
        @Nonnull
        private final Comparisons.Comparison comparison;

        protected InComparandClause(@Nonnull String bindingName, @Nonnull Comparisons.Comparison comparison, @Nullable KeyExpression orderingKey) {
            super(bindingName, orderingKey);
            this.comparison = comparison;
        }

        @Override
        protected RecordQueryPlan wrap(RecordQueryPlan inner) {
            return new RecordQueryInComparandJoinPlan(inner, this.bindingName, Bindings.Internal.IN, this.comparison, this.sortValues, this.sortReverse);
        }

        @Override
        protected InSource unionSource() {
            return new InComparandSource(this.bindingName, this.comparison);
        }
    }
}

