/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordFunction;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.AndOrComponent;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryRecordFunctionWithComparison;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.planning.BindingFunction;
import com.apple.foundationdb.record.query.plan.planning.GroupingValidator;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RankComparisons {
    @Nonnull
    private final Map<QueryRecordFunctionWithComparison, RankComparison> comparisons = new HashMap<QueryRecordFunctionWithComparison, RankComparison>();

    public RankComparisons(@Nullable QueryComponent filter, @Nonnull List<Index> indexes) {
        List groupingFilters = filter instanceof AndComponent ? ((AndComponent)filter).getChildren() : Collections.emptyList();
        this.findComparisons(filter, indexes, groupingFilters, new AtomicInteger());
    }

    @Nullable
    public RankComparison getPlanComparison(@Nonnull QueryRecordFunctionWithComparison comparison) {
        return this.comparisons.get(comparison);
    }

    @Nonnull
    public QueryComponent planComparisonSubstitute(@Nonnull QueryComponent component) {
        QueryComponent substitute;
        RankComparison rankComparison;
        if (component instanceof QueryRecordFunctionWithComparison && (rankComparison = this.getPlanComparison((QueryRecordFunctionWithComparison)component)) != null && (substitute = rankComparison.getSubstitute()) != null) {
            return substitute;
        }
        return component;
    }

    @Nullable
    public List<QueryComponent> planComparisonSubstitutes(@Nullable List<QueryComponent> components) {
        if (components == null || this.comparisons.isEmpty()) {
            return components;
        }
        return components.stream().map(this::planComparisonSubstitute).collect(Collectors.toList());
    }

    @Nonnull
    public RecordQueryPlan wrap(@Nonnull RecordQueryPlan plan, @Nullable Set<RankComparison> includedRankComparisons, @Nonnull RecordMetaData metaData) {
        if (this.comparisons.isEmpty()) {
            return plan;
        }
        ArrayList<RecordQueryScoreForRankPlan.ScoreForRank> ranks = new ArrayList<RecordQueryScoreForRankPlan.ScoreForRank>(this.comparisons.size());
        for (RankComparison rankComparison : this.comparisons.values()) {
            if (includedRankComparisons != null && includedRankComparisons.contains(rankComparison)) continue;
            ranks.add(rankComparison.getScoreForRank(metaData));
        }
        if (!ranks.isEmpty()) {
            Collections.sort(ranks, Comparator.comparing(RecordQueryScoreForRankPlan.ScoreForRank::getBindingName));
            plan = new RecordQueryScoreForRankPlan(plan, ranks);
        }
        return plan;
    }

    public static String scoreForRankFunction(@Nonnull QueryRecordFunctionWithComparison comparison) {
        boolean isRightRange;
        String rankFunction = comparison.getFunction().getName();
        Comparisons.Type comparisonType = comparison.getComparison().getType();
        boolean bl = isRightRange = comparisonType == Comparisons.Type.LESS_THAN || comparisonType == Comparisons.Type.LESS_THAN_OR_EQUALS;
        if ("rank".equals(rankFunction)) {
            return isRightRange ? "score_for_rank_else_skip" : "score_for_rank";
        }
        if ("time_window_rank".equals(rankFunction)) {
            return isRightRange ? "score_for_time_window_rank_else_skip" : "score_for_time_window_rank";
        }
        throw new RecordCoreException("Unknown rank function: " + rankFunction, new Object[0]);
    }

    public static boolean matchesSort(@Nonnull GroupingKeyExpression indexExpr, @Nullable KeyExpression sort) {
        if (sort == null) {
            return true;
        }
        KeyExpression grouped = indexExpr.getGroupedSubKey();
        return sort.equals(grouped);
    }

    public static boolean createsDuplicates(@Nonnull Index index, @Nonnull GroupingKeyExpression indexExpr) {
        return !"time_window_leaderboard".equals(index.getType()) && indexExpr.createsDuplicates();
    }

    private void findComparisons(@Nullable QueryComponent filter, @Nonnull List<Index> indexes, @Nonnull List<QueryComponent> groupingFilters, @Nonnull AtomicInteger counter) {
        if (filter instanceof AndOrComponent) {
            for (QueryComponent child : ((ComponentWithChildren)filter).getChildren()) {
                this.findComparisons(child, indexes, groupingFilters, counter);
            }
        } else if (filter instanceof QueryRecordFunctionWithComparison) {
            this.findComparison((QueryRecordFunctionWithComparison)filter, indexes, groupingFilters, counter);
        }
    }

    private void findComparison(@Nonnull QueryRecordFunctionWithComparison comparison, @Nonnull List<Index> indexes, @Nonnull List<QueryComponent> potentialGroupFilters, @Nonnull AtomicInteger counter) {
        RecordFunction<?> recordFunction = comparison.getFunction();
        List<String> requiredIndexTypes = "rank".equals(recordFunction.getName()) ? Arrays.asList("rank", "time_window_leaderboard") : ("time_window_rank".equals(recordFunction.getName()) ? Collections.singletonList("time_window_leaderboard") : null);
        if (requiredIndexTypes != null) {
            GroupingKeyExpression operand = ((IndexRecordFunction)recordFunction).getOperand();
            Optional<Index> matchingIndex = indexes.stream().filter(index -> requiredIndexTypes.contains(index.getType()) && index.getRootExpression().equals(operand)).min(Comparator.comparing(Index::getColumnSize));
            if (matchingIndex.isPresent()) {
                ArrayList<Comparisons.Comparison> groupComparisons;
                ArrayList<QueryComponent> groupFilters;
                KeyExpression groupBy = operand.getGroupingSubKey();
                if (!GroupingValidator.findGroupKeyFilters(potentialGroupFilters, groupBy, groupFilters = new ArrayList<QueryComponent>(), groupComparisons = new ArrayList<Comparisons.Comparison>())) {
                    return;
                }
                BaseField substitute = null;
                String bindingName = null;
                Comparisons.Type comparisonType = comparison.getComparison().getType();
                if (!operand.createsDuplicates() && !comparisonType.isUnary()) {
                    NestingKeyExpression nesting;
                    bindingName = Bindings.Internal.RANK.bindingName(Integer.toString(counter.getAndIncrement()));
                    Comparisons.ParameterComparison substituteComparison = new Comparisons.ParameterComparison(comparisonType, bindingName, Bindings.Internal.RANK);
                    KeyExpression grouped = operand.getGroupedSubKey();
                    if (grouped instanceof FieldKeyExpression) {
                        substitute = new FieldWithComparison(((FieldKeyExpression)grouped).getFieldName(), substituteComparison);
                    } else if (grouped instanceof NestingKeyExpression && (nesting = (NestingKeyExpression)grouped).getChild() instanceof FieldKeyExpression) {
                        substitute = new NestedField(nesting.getParent().getFieldName(), new FieldWithComparison(((FieldKeyExpression)nesting.getChild()).getFieldName(), substituteComparison));
                    }
                    if (substitute == null) {
                        bindingName = null;
                    }
                }
                this.comparisons.put(comparison, new RankComparison(comparison, matchingIndex.get(), groupFilters, groupComparisons, substitute, bindingName));
            }
        }
    }

    public static class RankComparison {
        @Nonnull
        private final QueryRecordFunctionWithComparison comparison;
        @Nonnull
        private final Index index;
        @Nonnull
        private final List<QueryComponent> groupFilters;
        @Nonnull
        private final List<Comparisons.Comparison> groupComparisons;
        @Nullable
        private final QueryComponent substitute;
        @Nullable
        private final String bindingName;

        protected RankComparison(@Nonnull QueryRecordFunctionWithComparison comparison, @Nonnull Index index, @Nonnull List<QueryComponent> groupFilters, @Nonnull List<Comparisons.Comparison> groupComparisons, @Nullable QueryComponent substitute, @Nullable String bindingName) {
            this.comparison = comparison;
            this.index = index;
            this.groupFilters = groupFilters;
            this.groupComparisons = groupComparisons;
            this.substitute = substitute;
            this.bindingName = bindingName;
        }

        @Nonnull
        public Index getIndex() {
            return this.index;
        }

        @Nonnull
        public List<QueryComponent> getGroupFilters() {
            return this.groupFilters;
        }

        @Nonnull
        public ScanComparisons getScanComparisons() {
            ScanComparisons rankComparison = ScanComparisons.from(this.comparison.getComparison());
            if (this.groupComparisons.isEmpty()) {
                return rankComparison;
            }
            return new ScanComparisons(this.groupComparisons, Collections.emptySet()).append(rankComparison);
        }

        @Nullable
        public QueryComponent getSubstitute() {
            return this.substitute;
        }

        @Nonnull
        public RecordQueryScoreForRankPlan.ScoreForRank getScoreForRank(@Nonnull RecordMetaData metaData) {
            String functionName = RankComparisons.scoreForRankFunction(this.comparison);
            IndexAggregateFunction function = new IndexAggregateFunction(functionName, ((IndexRecordFunction)this.comparison.getFunction()).getOperand(), this.index.getName());
            ArrayList<Comparisons.Comparison> comparisons = new ArrayList<Comparisons.Comparison>(this.groupComparisons);
            comparisons.add(this.comparison.getComparison());
            BindingFunction bindingFunction = BindingFunction.comparisonBindingFunction(this.substitute, this.index, metaData);
            return new RecordQueryScoreForRankPlan.ScoreForRank(this.bindingName, bindingFunction, function, comparisons);
        }
    }
}

