/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.planning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.TextScan;
import com.apple.foundationdb.record.query.plan.planning.FilterSatisfiedMask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class TextScanPlanner {
    private static final ImmutableSet<Comparisons.Type> COMPARISONS_NOT_REQUIRING_POSITIONS = ImmutableSet.of(Comparisons.Type.TEXT_CONTAINS_ALL, Comparisons.Type.TEXT_CONTAINS_ANY, Comparisons.Type.TEXT_CONTAINS_PREFIX);

    private static boolean matchesTokenizer(@Nonnull Comparisons.TextComparison comparison, @Nonnull Index index) {
        if (comparison.getTokenizerName() != null) {
            String indexTokenizerName = index.getOption("textTokenizerName");
            if (indexTokenizerName == null) {
                indexTokenizerName = "default";
            }
            return comparison.getTokenizerName().equals(indexTokenizerName);
        }
        return true;
    }

    private static boolean containsPositionsIfNecessary(@Nonnull Comparisons.TextComparison comparison, @Nonnull Index index) {
        return COMPARISONS_NOT_REQUIRING_POSITIONS.contains((Object)comparison.getType()) || !index.getBooleanOption("textOmitPositions", false);
    }

    @Nullable
    private static TextScan getScanForField(@Nonnull Index index, @Nonnull FieldKeyExpression textExpression, @Nonnull FieldWithComparison filter, @Nullable ScanComparisons groupingComparisons, boolean hasSort, @Nullable FilterSatisfiedMask filterMask) {
        if (!(filter.getComparison() instanceof Comparisons.TextComparison)) {
            return null;
        }
        Comparisons.TextComparison comparison = (Comparisons.TextComparison)filter.getComparison();
        if (!TextScanPlanner.matchesTokenizer(comparison, index) || !TextScanPlanner.containsPositionsIfNecessary(comparison, index)) {
            return null;
        }
        if (hasSort) {
            return null;
        }
        if (filter.getFieldName().equals(textExpression.getFieldName())) {
            if (filterMask != null) {
                filterMask.setSatisfied(true);
                filterMask.setExpression(textExpression);
            }
            return new TextScan(index, groupingComparisons, comparison, null);
        }
        return null;
    }

    @Nullable
    private static TextScan getScanForAndFilter(@Nonnull Index index, @Nonnull KeyExpression textExpression, @Nonnull AndComponent filter, @Nullable ScanComparisons groupingComparisons, boolean hasSort, @Nullable FilterSatisfiedMask filterMask) {
        Iterator<FilterSatisfiedMask> subFilterMasks = filterMask != null ? filterMask.getChildren().iterator() : null;
        for (QueryComponent subFilter : filter.getChildren()) {
            FilterSatisfiedMask childMask;
            TextScan childScan = TextScanPlanner.getScanForFilter(index, textExpression, subFilter, groupingComparisons, hasSort, childMask = subFilterMasks != null ? subFilterMasks.next() : null);
            if (childScan == null) continue;
            if (filterMask != null && filterMask.getExpression() == null) {
                filterMask.setExpression(textExpression);
            }
            return childScan;
        }
        return null;
    }

    @Nullable
    private static TextScan getScanForNestedField(@Nonnull Index index, @Nonnull NestingKeyExpression textExpression, @Nonnull NestedField filter, @Nullable ScanComparisons groupingComparisons, boolean hasSort, @Nullable FilterSatisfiedMask filterMask) {
        if (textExpression.getParent().getFanType().equals((Object)KeyExpression.FanType.None) && textExpression.getParent().getFieldName().equals(filter.getFieldName())) {
            FilterSatisfiedMask childMask = filterMask != null ? filterMask.getChild(filter.getChild()) : null;
            TextScan foundScan = TextScanPlanner.getScanForFilter(index, textExpression.getChild(), filter.getChild(), groupingComparisons, hasSort, childMask);
            if (foundScan != null && filterMask != null && filterMask.getExpression() == null) {
                filterMask.setExpression(textExpression);
            }
            return foundScan;
        }
        return null;
    }

    @Nullable
    private static TextScan getScanForRepeatedNestedField(@Nonnull Index index, @Nonnull NestingKeyExpression textExpression, @Nonnull OneOfThemWithComponent filter, @Nullable ScanComparisons groupingComparisons, boolean hasSort, @Nullable FilterSatisfiedMask filterMask) {
        if (textExpression.getParent().getFanType().equals((Object)KeyExpression.FanType.FanOut) && textExpression.getParent().getFieldName().equals(filter.getFieldName())) {
            FilterSatisfiedMask childMask = filterMask != null ? filterMask.getChild(filter.getChild()) : null;
            TextScan foundScan = TextScanPlanner.getScanForFilter(index, textExpression.getChild(), filter.getChild(), groupingComparisons, hasSort, childMask);
            if (foundScan != null && filterMask != null && filterMask.getExpression() != null) {
                filterMask.setExpression(textExpression);
            }
            return foundScan;
        }
        return null;
    }

    @Nullable
    private static TextScan getScanForFilter(@Nonnull Index index, @Nonnull KeyExpression textExpression, @Nonnull QueryComponent filter, @Nullable ScanComparisons groupingComparisons, boolean hasSort, @Nullable FilterSatisfiedMask filterMask) {
        if (filter instanceof AndComponent) {
            return TextScanPlanner.getScanForAndFilter(index, textExpression, (AndComponent)filter, groupingComparisons, hasSort, filterMask);
        }
        if (textExpression instanceof FieldKeyExpression && filter instanceof FieldWithComparison) {
            return TextScanPlanner.getScanForField(index, (FieldKeyExpression)textExpression, (FieldWithComparison)filter, groupingComparisons, hasSort, filterMask);
        }
        if (textExpression instanceof NestingKeyExpression) {
            if (filter instanceof NestedField) {
                return TextScanPlanner.getScanForNestedField(index, (NestingKeyExpression)textExpression, (NestedField)filter, groupingComparisons, hasSort, filterMask);
            }
            if (filter instanceof OneOfThemWithComponent) {
                return TextScanPlanner.getScanForRepeatedNestedField(index, (NestingKeyExpression)textExpression, (OneOfThemWithComponent)filter, groupingComparisons, hasSort, filterMask);
            }
        }
        return null;
    }

    @Nullable
    public static TextScan getScanForQuery(@Nonnull Index index, @Nonnull QueryComponent filter, boolean hasSort, @Nonnull FilterSatisfiedMask filterMask) {
        ScanComparisons groupingComparisons;
        KeyExpression groupedKey;
        KeyExpression indexExpression = index.getRootExpression();
        FilterSatisfiedMask localMask = FilterSatisfiedMask.of(filter);
        if (indexExpression instanceof GroupingKeyExpression) {
            KeyExpression groupingKey = ((GroupingKeyExpression)indexExpression).getGroupingSubKey();
            groupedKey = ((GroupingKeyExpression)indexExpression).getGroupedSubKey();
            QueryToKeyMatcher groupingQueryMatcher = new QueryToKeyMatcher(filter);
            QueryToKeyMatcher.Match groupingMatch = groupingQueryMatcher.matchesCoveringKey(groupingKey, localMask);
            if (!groupingMatch.getType().equals((Object)QueryToKeyMatcher.MatchType.EQUALITY)) {
                return null;
            }
            groupingComparisons = new ScanComparisons(groupingMatch.getEqualityComparisons(), Collections.emptySet());
        } else {
            groupedKey = indexExpression;
            groupingComparisons = null;
        }
        KeyExpression textExpression = groupedKey.getSubKey(0, 1);
        TextScan foundScan = TextScanPlanner.getScanForFilter(index, textExpression, filter, groupingComparisons, hasSort, localMask);
        if (foundScan != null) {
            filterMask.mergeWith(localMask);
            return foundScan;
        }
        return null;
    }

    @Nonnull
    public static KeyExpression getTokenizedField(@Nonnull KeyExpression indexExpression) {
        KeyExpression groupedKey = indexExpression instanceof GroupingKeyExpression ? ((GroupingKeyExpression)indexExpression).getGroupedSubKey() : indexExpression;
        return groupedKey.getSubKey(0, 1);
    }

    @Nonnull
    public static List<KeyExpression> getOtherFields(@Nonnull KeyExpression indexExpression) {
        ImmutableList.Builder otherFields = ImmutableList.builder();
        if (indexExpression instanceof GroupingKeyExpression) {
            GroupingKeyExpression groupingIndexExpression = (GroupingKeyExpression)indexExpression;
            KeyExpression groupedKey = groupingIndexExpression.getGroupedSubKey();
            KeyExpression groupingKey = groupingIndexExpression.getGroupingSubKey();
            otherFields.addAll(groupingKey.normalizeKeyForPositions());
            otherFields.add(Key.Expressions.value("__text_token"));
            if (groupedKey.getColumnSize() > 1) {
                otherFields.addAll(groupedKey.getSubKey(1, groupedKey.getColumnSize()).normalizeKeyForPositions());
            }
        } else {
            otherFields.add(Key.Expressions.value("__text_token"));
            if (indexExpression.getColumnSize() > 1) {
                otherFields.addAll(indexExpression.getSubKey(1, indexExpression.getColumnSize()).normalizeKeyForPositions());
            }
        }
        return otherFields.build();
    }

    private TextScanPlanner() {
    }
}

