/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInComparandSource;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class InComparandSource
extends InSource {
    @Nonnull
    private static final ObjectPlanHash OBJECT_PLAN_HASH_IN_COMPARAND_SOURCE = new ObjectPlanHash("In-Comparand");
    @Nonnull
    private final Comparisons.Comparison comparison;

    protected InComparandSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInComparandSource inComparandSource) {
        super(serializationContext, Objects.requireNonNull(inComparandSource.getSuper()));
        this.comparison = Comparisons.Comparison.fromComparisonProto(serializationContext, Objects.requireNonNull(inComparandSource.getComparison()));
    }

    public InComparandSource(@Nonnull String bindingName, @Nonnull Comparisons.Comparison comparison) {
        super(bindingName);
        this.comparison = comparison;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.baseHash(mode, OBJECT_PLAN_HASH_IN_COMPARAND_SOURCE), this.comparison);
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addNested(0, this.comparison.explain().getExplainTokens(), "...").addNested(this.explainSuffix()));
    }

    @Override
    protected int size(@Nonnull EvaluationContext context) {
        return this.getValues(context).size();
    }

    @Override
    @Nonnull
    protected List<Object> getValues(@Nullable EvaluationContext context) {
        return (List)this.comparison.getComparand(null, context);
    }

    @Override
    @Nonnull
    public RecordQueryInJoinPlan toInJoinPlan(@Nonnull Quantifier.Physical innerQuantifier) {
        return new RecordQueryInComparandJoinPlan(innerQuantifier, this, Bindings.Internal.CORRELATION);
    }

    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Nonnull
    public String toString() {
        return this.getBindingName() + " " + String.valueOf(this.comparison);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InComparandSource inComparandSource = (InComparandSource)o;
        if (!this.getBindingName().equals(inComparandSource.getBindingName())) {
            return false;
        }
        return this.comparison.equals(inComparandSource.comparison);
    }

    public int hashCode() {
        return this.comparison.hashCode();
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        return this.toInComparandSourceProto(serializationContext);
    }

    @Nonnull
    protected PInComparandSource toInComparandSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInComparandSource.newBuilder().setSuper(this.toInSourceSuperProto(serializationContext)).setComparison(this.comparison.toComparisonProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    protected PInSource toInSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.newBuilder().setInComparandSource(this.toInComparandSourceProto(serializationContext)).build();
    }

    @Nonnull
    public static InComparandSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInComparandSource inComparandSourceProto) {
        return new InComparandSource(serializationContext, inComparandSourceProto);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Objects.requireNonNull(this.comparison.getValue()).getResultType();
    }

    public static class Deserializer
    implements PlanDeserializer<PInComparandSource, InComparandSource> {
        @Override
        @Nonnull
        public Class<PInComparandSource> getProtoMessageClass() {
            return PInComparandSource.class;
        }

        @Override
        @Nonnull
        public InComparandSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInComparandSource inComparandSourceProto) {
            return InComparandSource.fromProto(serializationContext, inComparandSourceProto);
        }
    }
}

