/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInParameterSource;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class InParameterSource
extends InSource {
    @Nonnull
    private static final ObjectPlanHash OBJECT_PLAN_HASH_IN_PARAMETER_SOURCE = new ObjectPlanHash("In-Parameter");
    @Nonnull
    private final String parameterName;

    protected InParameterSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInParameterSource inParameterSourceProto) {
        super(serializationContext, Objects.requireNonNull(inParameterSourceProto.getSuper()));
        this.parameterName = Objects.requireNonNull(inParameterSourceProto.getParameterName());
    }

    public InParameterSource(@Nonnull String bindingName, @Nonnull String parameterName) {
        super(bindingName);
        this.parameterName = parameterName;
    }

    @Nonnull
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addToString("$").addIdentifier(this.parameterName).addNested(this.explainSuffix()));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.baseHash(mode, OBJECT_PLAN_HASH_IN_PARAMETER_SOURCE), this.parameterName);
    }

    @Override
    protected int size(@Nonnull EvaluationContext context) {
        return this.getValues(context).size();
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    protected List<Object> getValues(@Nullable EvaluationContext context) {
        return this.getBoundValues(Objects.requireNonNull(context));
    }

    @Nonnull
    protected List<Object> getBoundValues(@Nonnull EvaluationContext context) {
        List binding = (List)context.getBinding(this.getParameterName());
        return Objects.requireNonNullElse(binding, Collections.emptyList());
    }

    @Override
    @Nonnull
    public RecordQueryInJoinPlan toInJoinPlan(@Nonnull Quantifier.Physical innerQuantifier) {
        return new RecordQueryInParameterJoinPlan(innerQuantifier, this, Bindings.Internal.CORRELATION);
    }

    @Nonnull
    public String toString() {
        return this.getBindingName() + " IN $" + this.parameterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InParameterSource inParameterSource = (InParameterSource)o;
        if (!this.getBindingName().equals(inParameterSource.getBindingName())) {
            return false;
        }
        return this.parameterName.equals(inParameterSource.parameterName);
    }

    public int hashCode() {
        return this.parameterName.hashCode();
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        return this.toInParameterSourceProto(serializationContext);
    }

    @Nonnull
    protected PInParameterSource toInParameterSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInParameterSource.newBuilder().setSuper(this.toInSourceSuperProto(serializationContext)).setParameterName(this.parameterName).build();
    }

    @Override
    @Nonnull
    protected PInSource toInSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.newBuilder().setInParameterSource(this.toInParameterSourceProto(serializationContext)).build();
    }

    @Nonnull
    public static InParameterSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInParameterSource inParameterSourceProto) {
        return new InParameterSource(serializationContext, inParameterSourceProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PInParameterSource, InParameterSource> {
        @Override
        @Nonnull
        public Class<PInParameterSource> getProtoMessageClass() {
            return PInParameterSource.class;
        }

        @Override
        @Nonnull
        public InParameterSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInParameterSource inParameterSourceProto) {
            return InParameterSource.fromProto(serializationContext, inParameterSourceProto);
        }
    }
}

