/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class InSource
implements PlanHashable,
PlanSerializable,
Typed {
    private static final Comparator<Object> VALUE_COMPARATOR = Comparator.comparing(Comparable.class::cast);
    @Nonnull
    private final String bindingName;

    protected InSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInSource.Super inSourceProto) {
        this(Objects.requireNonNull(inSourceProto.getBindingName()));
    }

    protected InSource(@Nonnull String bindingName) {
        this.bindingName = bindingName;
    }

    @Nonnull
    public String getBindingName() {
        return this.bindingName;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.any();
    }

    public abstract boolean isSorted();

    public abstract boolean isReverse();

    @Nonnull
    public abstract ExplainTokensWithPrecedence explain();

    @Nonnull
    protected ExplainTokens explainSuffix() {
        ExplainTokens resultExplainTokens = new ExplainTokens();
        if (this.isSorted()) {
            resultExplainTokens.addWhitespace().addKeyword("SORTED");
        }
        if (this.isReverse()) {
            resultExplainTokens.addWhitespace().addKeyword("DESC");
        }
        return resultExplainTokens;
    }

    protected abstract int size(@Nonnull EvaluationContext var1);

    @Nonnull
    public List<Object> getValues() {
        return this.getValues(null);
    }

    @Nonnull
    protected abstract List<Object> getValues(@Nullable EvaluationContext var1);

    @Nonnull
    public abstract RecordQueryInJoinPlan toInJoinPlan(@Nonnull Quantifier.Physical var1);

    public int baseHash(@Nonnull PlanHashable.PlanHashMode mode, @Nonnull ObjectPlanHash objectPlanHash) {
        return objectPlanHash.planHash(mode);
    }

    @Nonnull
    protected abstract PInSource toInSourceProto(@Nonnull PlanSerializationContext var1);

    @Nonnull
    protected static InSource fromInSourceProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInSource inSourceProto) {
        return (InSource)PlanSerialization.dispatchFromProtoContainer(serializationContext, inSourceProto);
    }

    @Nonnull
    protected PInSource.Super toInSourceSuperProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.Super.newBuilder().setBindingName(this.bindingName).build();
    }

    @Nonnull
    public static List<Object> sortValues(@Nonnull List<Object> values, boolean isReversed) {
        if (values.size() < 2) {
            return values;
        }
        ArrayList<Object> copy = new ArrayList<Object>(values);
        copy.sort(isReversed ? VALUE_COMPARATOR.reversed() : VALUE_COMPARATOR);
        return copy;
    }
}

