/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInSource;
import com.apple.foundationdb.record.planprotos.PInValuesSource;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class InValuesSource
extends InSource {
    @Nonnull
    private static final ObjectPlanHash OBJECT_PLAN_HASH_IN_VALUES_SOURCE = new ObjectPlanHash("In-Values");
    @Nonnull
    private final List<Object> values;
    @Nonnull
    private final Supplier<List<Object>> valuesWithRealEqualsSupplier = Suppliers.memoize(() -> Lists.transform(this.getValues(), Comparisons::toClassWithRealEquals));

    protected InValuesSource(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInValuesSource inValuesSourceProto) {
        super(serializationContext, Objects.requireNonNull(inValuesSourceProto.getSuper()));
        this.values = Lists.newArrayListWithExpectedSize(inValuesSourceProto.getValuesCount());
        for (int i = 0; i < inValuesSourceProto.getValuesCount(); ++i) {
            this.values.add(PlanSerialization.protoToValueObject(inValuesSourceProto.getValues(i)));
        }
    }

    public InValuesSource(@Nonnull String bindingName, @Nonnull List<Object> values) {
        super(bindingName);
        this.values = values;
    }

    @Override
    @Nonnull
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    @Nonnull
    protected List<Object> getValues(@Nullable EvaluationContext context) {
        return this.values;
    }

    @Nonnull
    public List<Object> getValuesWithRealEquals() {
        return this.valuesWithRealEqualsSupplier.get();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addNested(0, new ExplainTokens().addToStrings(this.values), "...").addNested(this.explainSuffix()));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.baseHash(mode, OBJECT_PLAN_HASH_IN_VALUES_SOURCE), this.values);
    }

    @Override
    protected int size(@Nonnull EvaluationContext context) {
        return this.values.size();
    }

    @Override
    @Nonnull
    public RecordQueryInJoinPlan toInJoinPlan(@Nonnull Quantifier.Physical innerQuantifier) {
        return new RecordQueryInValuesJoinPlan(innerQuantifier, this, Bindings.Internal.CORRELATION);
    }

    @Nonnull
    public String toString() {
        return this.getBindingName() + " IN " + String.valueOf(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InValuesSource inValuesSource = (InValuesSource)o;
        if (!this.getBindingName().equals(inValuesSource.getBindingName())) {
            return false;
        }
        return this.getValuesWithRealEquals().equals(inValuesSource.getValuesWithRealEquals());
    }

    public int hashCode() {
        return this.getValuesWithRealEquals().hashCode();
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        return this.toInValuesSourceProto(serializationContext);
    }

    @Nonnull
    protected PInValuesSource toInValuesSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        PInValuesSource.Builder builder = PInValuesSource.newBuilder().setSuper(this.toInSourceSuperProto(serializationContext));
        for (Object value : this.values) {
            builder.addValues(PlanSerialization.valueObjectToProto(value));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    protected PInSource toInSourceProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInSource.newBuilder().setInValuesSource(this.toInValuesSourceProto(serializationContext)).build();
    }

    @Nonnull
    public static InValuesSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInValuesSource inValuesSource) {
        return new InValuesSource(serializationContext, inValuesSource);
    }

    public static class Deserializer
    implements PlanDeserializer<PInValuesSource, InValuesSource> {
        @Override
        @Nonnull
        public Class<PInValuesSource> getProtoMessageClass() {
            return PInValuesSource.class;
        }

        @Override
        @Nonnull
        public InValuesSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInValuesSource inValuesSourceProto) {
            return InValuesSource.fromProto(serializationContext, inValuesSourceProto);
        }
    }
}

