/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface QueryPlan<T>
extends PlanHashable,
RelationalExpression {
    public static final int UNKNOWN_MAX_CARDINALITY = Integer.MAX_VALUE;

    @Nonnull
    public RecordCursor<T> execute(@Nonnull FDBRecordStore var1, @Nonnull EvaluationContext var2, @Nullable byte[] var3, @Nonnull ExecuteProperties var4);

    @Nonnull
    default public RecordCursor<T> execute(@Nonnull FDBRecordStore store) {
        return this.execute(store, EvaluationContext.EMPTY);
    }

    @Nonnull
    default public RecordCursor<T> execute(@Nonnull FDBRecordStore store, @Nonnull EvaluationContext context) {
        return this.execute(store, context, null, ExecuteProperties.SERIAL_EXECUTE);
    }

    public boolean isReverse();

    public boolean hasRecordScan();

    public boolean hasFullRecordScan();

    public boolean hasIndexScan(@Nonnull String var1);

    @Nonnull
    public Set<String> getUsedIndexes();

    public boolean hasLoadBykeys();

    default public int maxCardinality(@Nonnull RecordMetaData metaData) {
        return Integer.MAX_VALUE;
    }

    default public boolean isStrictlySorted() {
        return false;
    }

    default public QueryPlan<T> strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    public void logPlanStructure(StoreTimer var1);

    public int getComplexity();

    public List<? extends QueryPlan<?>> getQueryPlanChildren();

    default public Iterable<? extends QueryPlan<?>> collectDescendantPlans() {
        Iterable<Object> result = ImmutableList.of();
        for (QueryPlan<?> queryPlanChild : this.getQueryPlanChildren()) {
            result = Iterables.concat(result, queryPlanChild.collectDescendantPlans(), ImmutableList.of(queryPlanChild));
        }
        return result;
    }
}

