/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.ProtoSerializable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.planprotos.PQueryResult;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QueryResult
implements ProtoSerializable {
    @Nullable
    private final Object datum;
    @Nullable
    private final FDBQueriedRecord<?> queriedRecord;
    @Nullable
    private final Tuple primaryKey;
    @Nullable
    private PQueryResult cachedProto;

    private QueryResult(@Nullable Object datum, @Nullable FDBQueriedRecord<?> queriedRecord, @Nullable Tuple primaryKey) {
        this.datum = datum;
        this.queriedRecord = queriedRecord;
        this.primaryKey = primaryKey;
    }

    @Nullable
    public <M extends Message> FDBQueriedRecord<M> getQueriedRecord() {
        return this.queriedRecord;
    }

    @Nonnull
    public <M extends Message> Optional<FDBQueriedRecord<M>> getQueriedRecordMaybe() {
        return Optional.ofNullable(this.getQueriedRecord());
    }

    @Nullable
    public Object getDatum() {
        return this.datum;
    }

    @Nonnull
    public <T> T get(@Nonnull Class<? extends T> clazz) {
        return clazz.cast(this.datum);
    }

    @Nonnull
    public <T> Optional<T> getMaybe(@Nonnull Class<? extends T> clazz) {
        if (clazz.isInstance(this.datum)) {
            return Optional.of(this.get(clazz));
        }
        return Optional.empty();
    }

    public <M extends Message> M getMessage() {
        if (this.datum instanceof FDBQueriedRecord) {
            return ((FDBQueriedRecord)this.datum).getRecord();
        }
        if (this.datum instanceof Message) {
            return (M)((Message)this.datum);
        }
        throw new RecordCoreException("cannot retrieve message from flowed object", new Object[0]);
    }

    public <M extends Message> Optional<M> getMessageMaybe() {
        if (this.datum instanceof FDBQueriedRecord) {
            return Optional.of(((FDBQueriedRecord)this.datum).getRecord());
        }
        if (this.datum instanceof Message) {
            return Optional.of((Message)this.datum);
        }
        return Optional.empty();
    }

    @Nullable
    public IndexEntry getIndexEntry() {
        if (this.queriedRecord != null) {
            return this.queriedRecord.getIndexEntry();
        }
        return null;
    }

    @Nullable
    public Tuple getPrimaryKey() {
        return this.primaryKey;
    }

    @Nullable
    public RecordType getRecordType() {
        if (this.queriedRecord != null) {
            return this.queriedRecord.getRecordType();
        }
        return null;
    }

    @Nonnull
    public QueryResult withComputed(@Nullable Object computed) {
        return new QueryResult(computed, this.queriedRecord, this.primaryKey);
    }

    @Nonnull
    public static QueryResult from(@Nullable Descriptors.Descriptor descriptor, @Nonnull PQueryResult parsed) {
        try {
            if (parsed.hasPrimitive()) {
                return QueryResult.ofComputed(PlanSerialization.protoToValueObject(parsed.getPrimitive()));
            }
            return QueryResult.ofComputed(DynamicMessage.parseFrom(Verify.verifyNotNull(descriptor), parsed.getComplex()));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid bytes", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(parsed.toByteArray())});
        }
    }

    @Nonnull
    public static QueryResult from(@Nullable Descriptors.Descriptor descriptor, @Nonnull ByteString byteString) {
        try {
            return QueryResult.from(descriptor, PQueryResult.parseFrom(byteString));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid bytes", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(byteString.toByteArray())});
        }
    }

    @Nonnull
    public static QueryResult from(@Nullable Descriptors.Descriptor descriptor, @Nonnull byte[] unparsed) {
        return QueryResult.from(descriptor, ZeroCopyByteString.wrap(unparsed));
    }

    @Nonnull
    public static QueryResult ofComputed(@Nullable Object computed) {
        return new QueryResult(computed, null, null);
    }

    @Nonnull
    public static QueryResult ofComputed(@Nullable Object computed, @Nullable Tuple primaryKey) {
        return new QueryResult(computed, null, primaryKey);
    }

    @Nonnull
    public static QueryResult fromQueriedRecord(@Nullable FDBQueriedRecord<?> queriedRecord) {
        if (queriedRecord == null) {
            return new QueryResult(null, null, null);
        }
        return new QueryResult(queriedRecord.getRecord(), queriedRecord, queriedRecord.getPrimaryKey());
    }

    @Override
    @Nonnull
    public PQueryResult toProto() {
        if (this.cachedProto == null) {
            PQueryResult.Builder builder = PQueryResult.newBuilder();
            if (this.datum instanceof FDBQueriedRecord) {
                builder.setComplex(((FDBQueriedRecord)this.datum).getRecord().toByteString());
            } else if (this.datum instanceof Message) {
                builder.setComplex(((Message)this.datum).toByteString());
            } else {
                builder.setPrimitive(PlanSerialization.valueObjectToProto(this.datum));
            }
            this.cachedProto = builder.buildPartial();
        }
        return this.cachedProto;
    }
}

