/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryAbstractDataModificationPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryAbstractDataModificationPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild,
PlannerGraphRewritable {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryAbstractDataModificationPlan.class);
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Abstract-Data-Modification-Plan");
    private static final UUID CURRENT_MODIFIED_RECORD = UUID.randomUUID();
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Type innerFlowedType;
    @Nonnull
    private final String targetRecordType;
    @Nonnull
    private final Type.Record targetType;
    @Nullable
    private final MessageHelpers.TransformationTrieNode transformationsTrie;
    @Nullable
    private final MessageHelpers.CoercionTrieNode coercionTrie;
    @Nonnull
    private final Value computationValue;
    @Nonnull
    private final Value resultValue;
    @Nonnull
    private final CorrelationIdentifier currentModifiedRecordAlias;
    @Nonnull
    private final Supplier<Integer> planHashForContinuationSupplier;

    protected RecordQueryAbstractDataModificationPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryAbstractDataModificationPlan recordQueryAbstractDataModificationPlanProto) {
        this(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getInner())), Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getTargetRecordType()), Type.Record.fromProto(serializationContext, Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getTargetType())), PlanSerialization.getFieldOrNull(recordQueryAbstractDataModificationPlanProto, PRecordQueryAbstractDataModificationPlan::hasTransformationsTrie, m4 -> MessageHelpers.TransformationTrieNode.fromProto(serializationContext, Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getTransformationsTrie()))), PlanSerialization.getFieldOrNull(recordQueryAbstractDataModificationPlanProto, PRecordQueryAbstractDataModificationPlan::hasCoercionTrie, m4 -> MessageHelpers.CoercionTrieNode.fromProto(serializationContext, Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getCoercionTrie()))), Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getComputationValue())), CorrelationIdentifier.of(Objects.requireNonNull(recordQueryAbstractDataModificationPlanProto.getCurrentModifiedRecordAlias())));
    }

    protected RecordQueryAbstractDataModificationPlan(@Nonnull Quantifier.Physical inner, @Nonnull String targetRecordType, @Nonnull Type.Record targetType, @Nullable MessageHelpers.TransformationTrieNode transformationsTrie, @Nullable MessageHelpers.CoercionTrieNode coercionTrie, @Nonnull Value computationValue, @Nonnull CorrelationIdentifier currentModifiedRecordAlias) {
        this.inner = inner;
        this.innerFlowedType = inner.getFlowedObjectType();
        this.targetRecordType = targetRecordType;
        this.targetType = targetType;
        this.transformationsTrie = transformationsTrie;
        this.coercionTrie = coercionTrie;
        this.computationValue = computationValue;
        this.resultValue = new QueriedValue(computationValue.getResultType());
        this.currentModifiedRecordAlias = currentModifiedRecordAlias;
        this.planHashForContinuationSupplier = Suppliers.memoize(this::computePlanHashForContinuation);
    }

    @Nonnull
    public Type.Record getTargetType() {
        return this.targetType;
    }

    @Nullable
    public MessageHelpers.TransformationTrieNode getTransformationsTrie() {
        return this.transformationsTrie;
    }

    @Nullable
    public MessageHelpers.CoercionTrieNode getCoercionTrie() {
        return this.coercionTrie;
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        ImmutableSet.Builder dynamicTypesBuilder = ImmutableSet.builder();
        dynamicTypesBuilder.addAll(this.computationValue.getDynamicTypes());
        if (this.transformationsTrie != null) {
            this.transformationsTrie.values().forEach(value -> dynamicTypesBuilder.addAll(value.getDynamicTypes()));
        }
        return dynamicTypesBuilder.build();
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordCursor<QueryResult> results = this.getInnerPlan().executePlan(store, context, continuation, executeProperties.clearSkipAndLimit());
        Descriptors.Descriptor targetDescriptor = store.getRecordMetaData().getRecordType(Objects.requireNonNull(this.targetRecordType)).getDescriptor();
        return results.map(queryResult -> Pair.of(queryResult, this.mutateRecord(store, context, (QueryResult)queryResult, targetDescriptor))).mapPipelined(pair -> this.saveRecordAsync(store, context, (Message)pair.getRight(), executeProperties.isDryRun()).thenApply(queryResult -> {
            EvaluationContext nestedContext = context.childBuilder().setBinding(this.getInner().getAlias(), pair.getLeft()).setBinding(this.getCurrentModifiedRecordAlias(), queryResult.getMessage()).build(context.getTypeRepository());
            Object result = this.computationValue.eval(store, nestedContext);
            return QueryResult.ofComputed(result, queryResult.getPrimaryKey());
        }), store.getPipelineSize(this.getPipelineOperation()));
    }

    public abstract PipelineOperation getPipelineOperation();

    @Nullable
    public <M extends Message> M mutateRecord(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull QueryResult queryResult, @Nonnull Descriptors.Descriptor targetDescriptor) {
        Message inRecord = (Message)Preconditions.checkNotNull(queryResult.getMessage());
        return (M)((Message)MessageHelpers.transformMessage(store, context.withBinding(Bindings.Internal.CORRELATION, this.getInner().getAlias(), queryResult), this.transformationsTrie, this.coercionTrie, this.targetType, targetDescriptor, this.innerFlowedType, inRecord.getDescriptorForType(), inRecord));
    }

    @Nonnull
    public abstract <M extends Message> CompletableFuture<QueryResult> saveRecordAsync(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nonnull M var3, boolean var4);

    @Override
    public boolean isReverse() {
        return this.getInnerPlan().isReverse();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.getInner());
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        Set<CorrelationIdentifier> resultValueCorrelatedTo = Sets.filter(this.computationValue.getCorrelatedTo(), alias -> !alias.equals(this.getCurrentModifiedRecordAlias()));
        if (this.transformationsTrie != null) {
            Iterator aliasesFromTransformationsTrieIterator = this.transformationsTrie.values().stream().flatMap(value -> value.getCorrelatedTo().stream()).iterator();
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(aliasesFromTransformationsTrieIterator)).addAll(resultValueCorrelatedTo)).build();
        }
        return resultValueCorrelatedTo;
    }

    @Nonnull
    public Value getComputationValue() {
        return this.computationValue;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression other, @Nonnull AliasMap equivalences) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RecordQueryUpdatePlan otherUpdatePlan = (RecordQueryUpdatePlan)other;
        if (!this.getTargetRecordType().equals(otherUpdatePlan.getTargetRecordType())) {
            return false;
        }
        if (!this.getTargetType().equals(otherUpdatePlan.getTargetType())) {
            return false;
        }
        if (!this.getResultValue().semanticEquals((Object)otherUpdatePlan.getResultValue(), equivalences)) {
            return false;
        }
        if (!Objects.equals(this.getTransformationsTrie(), otherUpdatePlan.getTransformationsTrie())) {
            return false;
        }
        return Objects.equals(this.getCoercionTrie(), otherUpdatePlan.getCoercionTrie());
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.hashCode(), this.targetRecordType, this.targetType, this.transformationsTrie, this.coercionTrie, this.computationValue);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return this.planHashForContinuationSupplier.get();
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    private int computePlanHashForContinuation() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.getInnerPlan(), this.targetRecordType, this.transformationsTrie, this.coercionTrie);
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.getInner().getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Nonnull
    public String getTargetRecordType() {
        return this.targetRecordType;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInnerPlan().getComplexity();
    }

    @Nonnull
    public PRecordQueryAbstractDataModificationPlan toRecordQueryAbstractModificationPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryAbstractDataModificationPlan.Builder builder = PRecordQueryAbstractDataModificationPlan.newBuilder().setInner(this.getInner().toProto(serializationContext)).setTargetRecordType(this.targetRecordType).setTargetType(this.targetType.toProto(serializationContext));
        if (this.transformationsTrie != null) {
            builder.setTransformationsTrie(this.transformationsTrie.toProto(serializationContext));
        }
        if (this.coercionTrie != null) {
            builder.setCoercionTrie(this.coercionTrie.toProto(serializationContext));
        }
        builder.setComputationValue(this.computationValue.toValueProto(serializationContext));
        builder.setCurrentModifiedRecordAlias(this.getCurrentModifiedRecordAlias().getId());
        return builder.build();
    }

    @Nonnull
    public static CorrelationIdentifier currentModifiedRecordAlias() {
        return CorrelationIdentifier.uniqueSingletonID(CURRENT_MODIFIED_RECORD, "\ud835\udcc6");
    }

    @Nonnull
    Quantifier.Physical getInner() {
        return this.inner;
    }

    @Nonnull
    CorrelationIdentifier getCurrentModifiedRecordAlias() {
        return this.currentModifiedRecordAlias;
    }
}

