/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.planprotos.PRecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRanges;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithConstraint;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithMatchCandidate;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryAggregateIndexPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren,
RecordQueryPlanWithMatchCandidate,
RecordQueryPlanWithConstraint,
RecordQueryPlanWithComparisons {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Aggregate-Index-Plan");
    @Nonnull
    private final RecordQueryIndexPlan indexPlan;
    @Nonnull
    private final String recordTypeName;
    @Nonnull
    private final IndexKeyValueToPartialRecord toRecord;
    @Nonnull
    private final Value resultValue;
    @Nonnull
    private final Value groupByResultValue;
    @Nonnull
    private final QueryPlanConstraint constraint;

    public RecordQueryAggregateIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan, @Nonnull String recordTypeName, @Nonnull IndexKeyValueToPartialRecord indexEntryToPartialRecordConverter, @Nonnull Value resultValue, @Nonnull Value groupByResultValue, @Nonnull QueryPlanConstraint constraint) {
        this.indexPlan = indexPlan;
        this.recordTypeName = recordTypeName;
        this.toRecord = indexEntryToPartialRecordConverter;
        this.resultValue = resultValue;
        this.groupByResultValue = groupByResultValue;
        this.constraint = constraint;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        TypeRepository typeRepository = context.getTypeRepository();
        Descriptors.Descriptor recordDescriptor = Objects.requireNonNull(typeRepository.getMessageDescriptor(this.resultValue.getResultType()));
        return this.indexPlan.executeEntries(store, context, continuation, executeProperties).map(indexEntry -> {
            RecordMetaData metaData = store.getRecordMetaData();
            RecordType recordType = metaData.getRecordType(this.recordTypeName);
            Index index = metaData.getIndex(this.getIndexName());
            return store.coveredIndexQueriedRecord(index, (IndexEntry)indexEntry, recordType, (Object)this.toRecord.toRecord(recordDescriptor, (IndexEntry)indexEntry), false);
        }).map(QueryResult::fromQueriedRecord);
    }

    @Nonnull
    public RecordQueryIndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    public Optional<Value> getGroupingValueMaybe() {
        boolean hasGroupingValue;
        boolean bl = hasGroupingValue = StreamSupport.stream(this.groupByResultValue.getChildren().spliterator(), false).count() > 1L;
        if (hasGroupingValue) {
            return Optional.of((Value)this.groupByResultValue.getChildren().iterator().next());
        }
        return Optional.empty();
    }

    @Nonnull
    public String getIndexName() {
        return this.indexPlan.getIndexName();
    }

    @Nonnull
    public IndexScanType getScanType() {
        return this.indexPlan.getScanType();
    }

    @Override
    public boolean isReverse() {
        return this.indexPlan.isReverse();
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.indexPlan.hasIndexScan(indexName);
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return this.indexPlan.getUsedIndexes();
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        return this.indexPlan.maxCardinality(metaData);
    }

    @Override
    public boolean isStrictlySorted() {
        return this.indexPlan.isStrictlySorted();
    }

    @Override
    public RecordQueryAggregateIndexPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return new RecordQueryAggregateIndexPlan(this.indexPlan.strictlySorted(memoizer), this.recordTypeName, this.toRecord, this.resultValue, this.groupByResultValue, this.constraint);
    }

    @Override
    @Nonnull
    public Optional<? extends MatchCandidate> getMatchCandidateMaybe() {
        return this.indexPlan.getMatchCandidateMaybe();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.NO_FIELDS;
    }

    @Nonnull
    public IndexKeyValueToPartialRecord getToRecord() {
        return this.toRecord;
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        result.addAll(this.indexPlan.getCorrelatedTo());
        return result.build();
    }

    @Override
    @Nonnull
    public RecordQueryAggregateIndexPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        RelationalExpression translatedIndexPlan = this.indexPlan.translateCorrelations(translationMap, shouldSimplifyValues, (List)translatedQuantifiers);
        if (translatedIndexPlan != this.indexPlan) {
            return new RecordQueryAggregateIndexPlan((RecordQueryIndexPlan)translatedIndexPlan, this.recordTypeName, this.toRecord, this.resultValue, this.groupByResultValue, this.constraint);
        }
        return this;
    }

    @Override
    public boolean canBeMinimized() {
        return this.indexPlan.canBeMinimized();
    }

    @Override
    @Nonnull
    public RecordQueryPlan minimize(@Nonnull List<Quantifier.Physical> newQuantifiers) {
        Verify.verify(newQuantifiers.isEmpty());
        return new RecordQueryAggregateIndexPlan((RecordQueryIndexPlan)this.indexPlan.minimize((List)newQuantifiers), this.recordTypeName, this.toRecord, this.resultValue, this.groupByResultValue, this.constraint);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryAggregateIndexPlan other = (RecordQueryAggregateIndexPlan)otherExpression;
        return this.indexPlan.structuralEquals(other.indexPlan, equivalencesMap) && this.recordTypeName.equals(other.recordTypeName) && this.toRecord.equals(other.toRecord);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.indexPlan, this.recordTypeName, this.toRecord);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_COVERING_INDEX);
    }

    @Override
    public int getComplexity() {
        return this.indexPlan.getComplexity();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.indexPlan, this.resultValue);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return this.indexPlan.createIndexPlannerGraph(this, NodeInfo.INDEX_SCAN_OPERATOR, ImmutableList.of(), ImmutableMap.of());
    }

    @Override
    @Nonnull
    public QueryPlanConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    @Nonnull
    public ScanComparisons getScanComparisons() {
        return this.indexPlan.getScanComparisons();
    }

    @Override
    public boolean hasComparisonRanges() {
        return this.indexPlan.hasComparisonRanges();
    }

    @Override
    @Nonnull
    public ComparisonRanges getComparisonRanges() {
        return this.indexPlan.getComparisonRanges();
    }

    @Override
    @Nonnull
    public PRecordQueryAggregateIndexPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryAggregateIndexPlan.newBuilder().setIndexPlan(this.indexPlan.toRecordQueryIndexPlanProto(serializationContext)).setRecordTypeName(this.recordTypeName).setToRecord(this.toRecord.toProto(serializationContext)).setResultValue(this.resultValue.toValueProto(serializationContext)).setGroupByResultValue(this.groupByResultValue.toValueProto(serializationContext)).setConstraint(this.constraint.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setAggregateIndexPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryAggregateIndexPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryAggregateIndexPlan recordQueryAggregateIndexPlanProto) {
        return new RecordQueryAggregateIndexPlan(RecordQueryIndexPlan.fromProto(serializationContext, Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getIndexPlan())), Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getRecordTypeName()), IndexKeyValueToPartialRecord.fromProto(serializationContext, Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getToRecord())), Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getResultValue())), recordQueryAggregateIndexPlanProto.hasGroupByResultValue() ? Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getGroupByResultValue())) : Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getResultValue())), QueryPlanConstraint.fromProto(serializationContext, Objects.requireNonNull(recordQueryAggregateIndexPlanProto.getConstraint())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryAggregateIndexPlan, RecordQueryAggregateIndexPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryAggregateIndexPlan> getProtoMessageClass() {
            return PRecordQueryAggregateIndexPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryAggregateIndexPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryAggregateIndexPlan recordQueryAggregateIndexPlanProto) {
            return RecordQueryAggregateIndexPlan.fromProto(serializationContext, recordQueryAggregateIndexPlanProto);
        }
    }
}

