/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PickValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class RecordQueryChooserPlanBase
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChildren {
    @Nonnull
    protected final List<Quantifier.Physical> quantifiers;
    private final boolean reverse;
    @Nonnull
    private final Value resultValue;

    protected RecordQueryChooserPlanBase(@Nonnull List<Quantifier.Physical> quantifiers) {
        Verify.verify(!quantifiers.isEmpty());
        this.quantifiers = List.copyOf(quantifiers);
        boolean firstReverse = quantifiers.get(0).getRangesOverPlan().isReverse();
        if (!this.getChildStream().allMatch(child -> child.isReverse() == firstReverse)) {
            throw new RecordCoreArgumentException("children of chooser plan do not all have same value for reverse field", new Object[0]);
        }
        this.reverse = firstReverse;
        this.resultValue = RecordQueryChooserPlanBase.calculateChildrenValues(quantifiers);
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return this.quantifiers;
    }

    @Override
    @Nonnull
    public List<RecordQueryPlan> getChildren() {
        return this.quantifiers.stream().map(Quantifier.Physical::getRangesOverPlan).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    protected Stream<RecordQueryPlan> getChildStream() {
        return this.quantifiers.stream().map(Quantifier.Physical::getRangesOverPlan);
    }

    @Nonnull
    protected RecordQueryPlan getChild(int planIndex) {
        Verify.verify(this.quantifiers.size() > planIndex);
        return this.quantifiers.get(planIndex).getRangesOverPlan();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.intersection(this.getChildStream().map(RecordQueryPlan::getAvailableFields).collect(Collectors.toList()));
    }

    @Override
    public int getComplexity() {
        return 1 + this.getChildStream().mapToInt(QueryPlan::getComplexity).sum();
    }

    @Override
    public int getRelationalChildCount() {
        return this.quantifiers.size();
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        return this.getChildStream().map(p -> p.maxCardinality(metaData)).min(Integer::compare).orElse(Integer.MAX_VALUE);
    }

    @Override
    public boolean isStrictlySorted() {
        return this.getChildren().stream().allMatch(QueryPlan::isStrictlySorted);
    }

    private static Value calculateChildrenValues(@Nonnull List<? extends Quantifier> quantifiers) {
        return new PickValue(LiteralValue.ofScalar(0), quantifiers.stream().map(Quantifier::getFlowedObjectValue).collect(ImmutableList.toImmutableList()));
    }
}

