/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ComparatorCursor;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryChooserPlanBase;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryComparatorPlan
extends RecordQueryChooserPlanBase {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Comparator-Plan");
    @Nonnull
    private final KeyExpression comparisonKey;
    private final int referencePlanIndex;
    private final boolean abortOnComparisonFailure;

    private RecordQueryComparatorPlan(@Nonnull List<Quantifier.Physical> quantifiers, @Nonnull KeyExpression comparisonKey, int referencePlanIndex, boolean abortOnComparisonFailure) {
        super(quantifiers);
        this.comparisonKey = comparisonKey;
        this.referencePlanIndex = referencePlanIndex;
        this.abortOnComparisonFailure = abortOnComparisonFailure;
    }

    @Nonnull
    public static RecordQueryComparatorPlan from(@Nonnull List<? extends RecordQueryPlan> children, @Nonnull KeyExpression comparisonKey, int referencePlanIndex) {
        return RecordQueryComparatorPlan.from(children, comparisonKey, referencePlanIndex, false);
    }

    @Nonnull
    @HeuristicPlanner
    @VisibleForTesting
    public static RecordQueryComparatorPlan from(@Nonnull List<? extends RecordQueryPlan> children, @Nonnull KeyExpression comparisonKey, int referencePlanIndex, boolean abortOnComparisonFailure) {
        Debugger.verifyHeuristicPlanner();
        if (children.isEmpty()) {
            throw new RecordCoreArgumentException("Comparator plan should have at least one plan", new Object[0]);
        }
        if (referencePlanIndex < 0 || referencePlanIndex >= children.size()) {
            throw new RecordCoreArgumentException("Reference Plan Index should be within the range of sub plans", new Object[0]);
        }
        ImmutableList.Builder childRefsBuilder = ImmutableList.builder();
        for (RecordQueryPlan recordQueryPlan : children) {
            childRefsBuilder.add(Reference.plannedOf(recordQueryPlan));
        }
        return new RecordQueryComparatorPlan(Quantifiers.fromPlans(childRefsBuilder.build()), comparisonKey, referencePlanIndex, abortOnComparisonFailure);
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties parentExecuteProperties = executeProperties.clearSkipAndLimit();
        return ComparatorCursor.create(store, this.getComparisonKey(), this.getChildren().stream().map(childPlan -> this.childCursorFunction(store, context, executeProperties, (RecordQueryPlan)childPlan)).collect(Collectors.toList()), continuation, this.referencePlanIndex, this.abortOnComparisonFailure, this::toString, () -> this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION)).skipThenLimit(parentExecuteProperties.getSkip(), parentExecuteProperties.getReturnedRowLimit());
    }

    @Nonnull
    private <M extends Message> Function<byte[], RecordCursor<QueryResult>> childCursorFunction(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, ExecuteProperties childExecuteProperties, RecordQueryPlan childPlan) {
        return childContinuation -> childPlan.executePlan(store, context, (byte[])childContinuation, childExecuteProperties);
    }

    @Nonnull
    public KeyExpression getComparisonKey() {
        return this.comparisonKey;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public RecordQueryComparatorPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryComparatorPlan(Quantifiers.narrow(Quantifier.Physical.class, translatedQuantifiers), this.getComparisonKey(), this.referencePlanIndex, this.abortOnComparisonFailure);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryComparatorPlan other = (RecordQueryComparatorPlan)otherExpression;
        return this.isReverse() == other.isReverse() && this.referencePlanIndex == other.referencePlanIndex && this.comparisonKey.equals(other.comparisonKey);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getComparisonKey(), this.referencePlanIndex, this.isReverse());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren(), this.getComparisonKey(), this.referencePlanIndex, this.isReverse());
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_COMPARATOR);
        for (Quantifier.Physical quantifier : this.quantifiers) {
            quantifier.getRangesOverPlan().logPlanStructure(timer);
        }
    }

    @Override
    public RecordQueryComparatorPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return new RecordQueryComparatorPlan(Quantifiers.fromPlans(this.getChildStream().map(p -> memoizer.memoizePlan(p.strictlySorted(memoizer))).collect(Collectors.toList())), this.comparisonKey, this.referencePlanIndex, this.abortOnComparisonFailure);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.COMPARATOR_OPERATOR, List.of("COMPARE BY {{comparisonKey}}"), Map.of("comparisonKey", Attribute.gml(this.comparisonKey.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }
}

