/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.planprotos.PRecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.ScanWithFetchMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryPlanUtils;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithMatchCandidate;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryCoveringIndexPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren,
RecordQueryPlanWithMatchCandidate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Covering-Index-Plan");
    @Nonnull
    private final RecordQueryPlanWithIndex indexPlan;
    @Nonnull
    private final String recordTypeName;
    @Nullable
    private final AvailableFields availableFields;
    @Nonnull
    private final IndexKeyValueToPartialRecord toRecord;

    protected RecordQueryCoveringIndexPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryCoveringIndexPlan recordQueryCoveringIndexPlanProto) {
        this.indexPlan = (RecordQueryPlanWithIndex)RecordQueryPlan.fromRecordQueryPlanProto(serializationContext, Objects.requireNonNull(recordQueryCoveringIndexPlanProto.getIndexPlan()));
        this.availableFields = null;
        this.recordTypeName = Objects.requireNonNull(recordQueryCoveringIndexPlanProto.getRecordTypeName());
        this.toRecord = IndexKeyValueToPartialRecord.fromProto(serializationContext, Objects.requireNonNull(recordQueryCoveringIndexPlanProto.getToRecord()));
    }

    public RecordQueryCoveringIndexPlan(@Nonnull RecordQueryPlanWithIndex indexPlan, @Nonnull String recordTypeName, @Nonnull AvailableFields availableFields, @Nonnull IndexKeyValueToPartialRecord toRecord) {
        this.indexPlan = indexPlan;
        this.availableFields = availableFields;
        this.recordTypeName = recordTypeName;
        this.toRecord = toRecord;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.indexPlan.executeEntries(store, context, continuation, executeProperties).map(this.indexEntryToQueriedRecord(store)).map(QueryResult::fromQueriedRecord);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public <M extends Message> Function<IndexEntry, FDBQueriedRecord<M>> indexEntryToQueriedRecord(@Nonnull FDBRecordStoreBase<M> store) {
        IndexScanType scanType = this.getScanType();
        boolean hasPrimaryKey = !scanType.equals(IndexScanType.BY_GROUP);
        return QueryPlanUtils.getCoveringIndexEntryToPartialRecordFunction(store, this.recordTypeName, this.getIndexName(), this.toRecord, hasPrimaryKey);
    }

    @Nonnull
    public RecordQueryPlanWithIndex getIndexPlan() {
        return this.indexPlan;
    }

    @Nonnull
    public String getIndexName() {
        return this.indexPlan.getIndexName();
    }

    @Nonnull
    public IndexScanType getScanType() {
        return this.indexPlan.getScanType();
    }

    @Override
    public boolean isReverse() {
        return this.indexPlan.isReverse();
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.indexPlan.hasIndexScan(indexName);
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return this.indexPlan.getUsedIndexes();
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        return this.indexPlan.maxCardinality(metaData);
    }

    @Override
    public boolean isStrictlySorted() {
        return this.indexPlan.isStrictlySorted();
    }

    @Override
    public RecordQueryCoveringIndexPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return new RecordQueryCoveringIndexPlan(this.indexPlan.strictlySorted(memoizer), this.recordTypeName, this.getAvailableFields(), this.toRecord);
    }

    @Override
    @Nonnull
    public Optional<? extends MatchCandidate> getMatchCandidateMaybe() {
        return this.indexPlan.getMatchCandidateMaybe();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return Objects.requireNonNull(this.availableFields);
    }

    @Nonnull
    public IndexKeyValueToPartialRecord getToRecord() {
        return this.toRecord;
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new IndexedValue(Objects.requireNonNull(this.indexPlan.getResultType().getInnerType()));
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.indexPlan.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryCoveringIndexPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        RelationalExpression translatedIndexPlan = this.indexPlan.translateCorrelations(translationMap, shouldSimplifyValues, (List)translatedQuantifiers);
        if (translatedIndexPlan != this.indexPlan) {
            return new RecordQueryCoveringIndexPlan((RecordQueryPlanWithIndex)translatedIndexPlan, this.recordTypeName, this.getAvailableFields(), this.toRecord);
        }
        return this;
    }

    @Override
    public boolean canBeMinimized() {
        return this.indexPlan.canBeMinimized();
    }

    @Override
    @Nonnull
    public RecordQueryCoveringIndexPlan minimize(@Nonnull List<Quantifier.Physical> newQuantifiers) {
        Verify.verify(newQuantifiers.isEmpty());
        return new RecordQueryCoveringIndexPlan((RecordQueryPlanWithIndex)this.indexPlan.minimize(newQuantifiers), this.recordTypeName, this.getAvailableFields(), this.toRecord);
    }

    @Nonnull
    public Optional<Value> pushValueThroughFetch(@Nonnull Value value, @Nonnull CorrelationIdentifier sourceAlias, @Nonnull CorrelationIdentifier targetAlias) {
        return this.indexPlan.getMatchCandidateMaybe().flatMap(matchCandidate -> matchCandidate instanceof ScanWithFetchMatchCandidate ? Optional.of((ScanWithFetchMatchCandidate)matchCandidate) : Optional.empty()).flatMap(scanWithFetchMatchCandidate -> scanWithFetchMatchCandidate.pushValueThroughFetch(value, sourceAlias, targetAlias));
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryCoveringIndexPlan other = (RecordQueryCoveringIndexPlan)otherExpression;
        return this.indexPlan.structuralEquals(other.indexPlan, equivalencesMap) && this.recordTypeName.equals(other.recordTypeName) && this.toRecord.equals(other.toRecord);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.indexPlan, this.recordTypeName, this.toRecord);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_COVERING_INDEX);
    }

    @Override
    public int getComplexity() {
        return this.indexPlan.getComplexity();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.indexPlan.planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.indexPlan);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return this.indexPlan.createIndexPlannerGraph(this, NodeInfo.COVERING_INDEX_SCAN_OPERATOR, ImmutableList.of(), ImmutableMap.of());
    }

    @Override
    @Nonnull
    public PRecordQueryCoveringIndexPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryCoveringIndexPlan.newBuilder().setIndexPlan(this.indexPlan.toRecordQueryPlanProto(serializationContext)).setRecordTypeName(this.recordTypeName).setToRecord(this.toRecord.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setCoveringIndexPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryCoveringIndexPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryCoveringIndexPlan recordQueryCoveringIndexPlanProto) {
        return new RecordQueryCoveringIndexPlan(serializationContext, recordQueryCoveringIndexPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryCoveringIndexPlan, RecordQueryCoveringIndexPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryCoveringIndexPlan> getProtoMessageClass() {
            return PRecordQueryCoveringIndexPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryCoveringIndexPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryCoveringIndexPlan recordQueryCoveringIndexPlanProto) {
            return RecordQueryCoveringIndexPlan.fromProto(serializationContext, recordQueryCoveringIndexPlanProto);
        }
    }
}

