/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.DerivedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryDefaultOnEmptyPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Default-On-Empty-Plan");
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Value onEmptyResultValue;
    @Nonnull
    private final Value resultValue;

    public RecordQueryDefaultOnEmptyPlan(@Nonnull Quantifier.Physical inner, @Nonnull Value onEmptyResultValue) {
        Verify.verify(inner.getFlowedObjectType().nullable().equals(onEmptyResultValue.getResultType().nullable()));
        this.inner = inner;
        this.onEmptyResultValue = onEmptyResultValue;
        this.resultValue = new DerivedValue(ImmutableList.of(inner.getFlowedObjectValue(), onEmptyResultValue), RecordQueryDefaultOnEmptyPlan.chooseNullableType(inner.getFlowedObjectType(), onEmptyResultValue.getResultType()));
    }

    @Nonnull
    private static Type chooseNullableType(@Nonnull Type type1, @Nonnull Type type2) {
        if (type1.isNullable()) {
            return type1;
        }
        return type2.isNullable() ? type2 : type1;
    }

    @Nonnull
    public Value getOnEmptyResultValue() {
        return this.onEmptyResultValue;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return RecordCursor.orElse(cont -> this.getChild().executePlan(store, context, (byte[])cont, executeProperties.clearSkipAndLimit()), (executor, cont) -> RecordCursor.fromList(executor, ImmutableList.of(QueryResult.ofComputed(this.onEmptyResultValue.eval(store, context))), cont), continuation).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public RecordQueryPlan getChild() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryDefaultOnEmptyPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.onEmptyResultValue);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.onEmptyResultValue.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 1);
        Value rebasedOnEmptyResultValue = this.onEmptyResultValue.translateCorrelations(translationMap, shouldSimplifyValues);
        return new RecordQueryDefaultOnEmptyPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), rebasedOnEmptyResultValue);
    }

    @Override
    public boolean isReverse() {
        return this.getChild().isReverse();
    }

    @Override
    public boolean isStrictlySorted() {
        return this.getChild().isStrictlySorted();
    }

    @Override
    public RecordQueryDefaultOnEmptyPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.semanticEqualsForResults(otherExpression, aliasMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return this.getChild().getComplexity();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChild(), this.getResultValue());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + mode.name() + " is not supported");
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.VALUE_COMPUTATION_OPERATOR, ImmutableList.of("{{inner}} OR {{expr}}"), ImmutableMap.of("inner", Attribute.gml("$" + String.valueOf(this.inner.getAlias())), "expr", Attribute.gml(this.onEmptyResultValue.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryDefaultOnEmptyPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryDefaultOnEmptyPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setOnEmptyResultValue(this.onEmptyResultValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setDefaultOnEmptyPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryDefaultOnEmptyPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryDefaultOnEmptyPlan recordQueryDefaultOnEmptyPlanProto) {
        return new RecordQueryDefaultOnEmptyPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryDefaultOnEmptyPlanProto.getInner())), Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryDefaultOnEmptyPlanProto.getOnEmptyResultValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryDefaultOnEmptyPlan, RecordQueryDefaultOnEmptyPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryDefaultOnEmptyPlan> getProtoMessageClass() {
            return PRecordQueryDefaultOnEmptyPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryDefaultOnEmptyPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryDefaultOnEmptyPlan recordQueryDefaultOnEmptyPlanProto) {
            return RecordQueryDefaultOnEmptyPlan.fromProto(serializationContext, recordQueryDefaultOnEmptyPlanProto);
        }
    }
}

