/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryDeletePlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryDeletePlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild,
PlannerGraphRewritable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Delete-Plan");
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryDeletePlan.class);
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Supplier<Value> resultValueSupplier;

    protected RecordQueryDeletePlan(@Nonnull Quantifier.Physical inner) {
        this.inner = inner;
        this.resultValueSupplier = Suppliers.memoize(inner::getFlowedObjectValue);
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        if (executeProperties.isDryRun()) {
            return RecordCursor.flatMapPipelined(outerContinuation -> this.getInnerPlan().executePlan(store, context, (byte[])outerContinuation, executeProperties.clearSkipAndLimit()), (outerQueryResult, innerContinuation) -> RecordCursor.fromFuture(store.dryRunDeleteRecordAsync(Verify.verifyNotNull(outerQueryResult.getPrimaryKey()))).filter(isDeleted -> isDeleted).map(ignored -> outerQueryResult), continuation, store.getPipelineSize(PipelineOperation.DELETE));
        }
        return RecordCursor.flatMapPipelined(outerContinuation -> this.getInnerPlan().executePlan(store, context, (byte[])outerContinuation, executeProperties.clearSkipAndLimit()), (outerQueryResult, innerContinuation) -> RecordCursor.fromFuture(store.deleteRecordAsync(Verify.verifyNotNull(outerQueryResult.getPrimaryKey()))).filter(isDeleted -> isDeleted).map(ignored -> outerQueryResult), continuation, store.getPipelineSize(PipelineOperation.DELETE));
    }

    @Override
    public boolean isReverse() {
        return this.getInnerPlan().isReverse();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValueSupplier.get();
    }

    @Override
    @Nonnull
    public RecordQueryDeletePlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryDeletePlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class));
    }

    @Override
    @Nonnull
    public RecordQueryDeletePlan withChild(@Nonnull Reference childRef) {
        return new RecordQueryDeletePlan(Quantifier.physical(childRef, this.inner.getAlias()));
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression other, @Nonnull AliasMap equivalences) {
        if (this == other) {
            return true;
        }
        return this.getClass() == other.getClass();
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.planHash(PlanHashable.CURRENT_FOR_CONTINUATION));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInnerPlan());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInnerPlan().getComplexity();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph graphForTarget = PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of()), ImmutableList.of());
        return PlannerGraph.fromNodeInnerAndTargetForModifications(new PlannerGraph.ModificationOperatorNodeWithInfo(this, NodeInfo.MODIFICATION_OPERATOR, ImmutableList.of("DELETE"), ImmutableMap.of()), Iterables.getOnlyElement(childGraphs), graphForTarget);
    }

    @Override
    @Nonnull
    public PRecordQueryDeletePlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryDeletePlan.newBuilder().setInner(this.inner.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setDeletePlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryDeletePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryDeletePlan recordQueryDeletePlanProto) {
        return new RecordQueryDeletePlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryDeletePlanProto.getInner())));
    }

    @Nonnull
    public static RecordQueryDeletePlan deletePlan(@Nonnull Quantifier.Physical inner) {
        return new RecordQueryDeletePlan(inner);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryDeletePlan, RecordQueryDeletePlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryDeletePlan> getProtoMessageClass() {
            return PRecordQueryDeletePlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryDeletePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryDeletePlan recordQueryDeletePlanProto) {
            return RecordQueryDeletePlan.fromProto(serializationContext, recordQueryDeletePlanProto);
        }
    }
}

