/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryExplodePlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryExplodePlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Explode-Plan");
    @Nonnull
    private final Value collectionValue;

    public RecordQueryExplodePlan(@Nonnull Value collectionValue) {
        this.collectionValue = collectionValue;
    }

    @Nonnull
    public Value getCollectionValue() {
        return this.collectionValue;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        Object result = this.collectionValue.eval(store, context);
        return RecordCursor.fromList(result == null ? ImmutableList.of() : (List)result, continuation).map(QueryResult::ofComputed).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.collectionValue.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryExplodePlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        Value translatedCollectionValue = this.collectionValue.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedCollectionValue != this.collectionValue) {
            return new RecordQueryExplodePlan(translatedCollectionValue);
        }
        return this;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public RecordQueryExplodePlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return false;
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return ImmutableSet.of();
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.NO_FIELDS;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        Verify.verify(this.collectionValue.getResultType().isArray());
        return new QueriedValue(Objects.requireNonNull(((Type.Array)this.collectionValue.getResultType()).getElementType()));
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.collectionValue.getDynamicTypes();
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryExplodePlan otherExplodePlan = (RecordQueryExplodePlan)otherExpression;
        return this.collectionValue.semanticEquals((Object)otherExplodePlan.getCollectionValue(), equivalencesMap) && this.semanticEqualsForResults(otherExpression, equivalencesMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getResultValue());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.VALUE_COMPUTATION_OPERATOR, ImmutableList.of("EXPLODE {{expr}}"), ImmutableMap.of("expr", Attribute.gml(this.collectionValue.toString()))), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryExplodePlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryExplodePlan.newBuilder().setCollectionValue(this.collectionValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setExplodePlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryExplodePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryExplodePlan recordQueryRangePlanProto) {
        return new RecordQueryExplodePlan(Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryRangePlanProto.getCollectionValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryExplodePlan, RecordQueryExplodePlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryExplodePlan> getProtoMessageClass() {
            return PRecordQueryExplodePlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryExplodePlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryExplodePlan recordQueryExplodePlanProto) {
            return RecordQueryExplodePlan.fromProto(serializationContext, recordQueryExplodePlanProto);
        }
    }
}

