/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PFetchIndexRecords;
import com.apple.foundationdb.record.planprotos.PRecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.DerivedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryFetchFromPartialRecordPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Fetch-From-Partial-Record-Plan");
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private final Type resultType;
    @Nullable
    private final TranslateValueFunction translateValueFunction;
    @Nonnull
    private final FetchIndexRecords fetchIndexRecords;
    @Nonnull
    private final Supplier<? extends Value> resultValueSupplier;

    protected RecordQueryFetchFromPartialRecordPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryFetchFromPartialRecordPlan recordQueryFetchFromPartialRecordPlanProto) {
        this.inner = Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryFetchFromPartialRecordPlanProto.getInner()));
        this.resultType = Type.fromTypeProto(serializationContext, Objects.requireNonNull(recordQueryFetchFromPartialRecordPlanProto.getResultType()));
        this.translateValueFunction = null;
        this.fetchIndexRecords = FetchIndexRecords.fromProto(serializationContext, Objects.requireNonNull(recordQueryFetchFromPartialRecordPlanProto.getFetchIndexRecords()));
        this.resultValueSupplier = Suppliers.memoize(this::computeResultValue);
    }

    @HeuristicPlanner
    public RecordQueryFetchFromPartialRecordPlan(@Nonnull RecordQueryPlan inner, @Nonnull TranslateValueFunction translateValueFunction, @Nonnull Type resultType, @Nonnull FetchIndexRecords fetchIndexRecords) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(inner))), translateValueFunction, resultType, fetchIndexRecords);
    }

    public RecordQueryFetchFromPartialRecordPlan(@Nonnull Quantifier.Physical inner, @Nonnull TranslateValueFunction translateValueFunction, @Nonnull Type resultType, @Nonnull FetchIndexRecords fetchIndexRecords) {
        this.inner = inner;
        this.resultType = resultType;
        this.translateValueFunction = translateValueFunction;
        this.fetchIndexRecords = fetchIndexRecords;
        this.resultValueSupplier = Suppliers.memoize(this::computeResultValue);
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.fetchIndexRecords.fetchIndexRecords(store, this.getChild().executePlan(store, context, continuation, executeProperties).map(QueryResult::getIndexEntry), executeProperties).map(QueryResult::fromQueriedRecord);
    }

    @Nonnull
    public Quantifier.Physical getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    public boolean isReverse() {
        return this.getChild().isReverse();
    }

    @Nonnull
    public FetchIndexRecords getFetchIndexRecords() {
        return this.fetchIndexRecords;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_FETCH);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getChild().getComplexity();
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Nonnull
    public TranslateValueFunction getPushValueFunction() {
        return Objects.requireNonNull(this.translateValueFunction);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public RecordQueryFetchFromPartialRecordPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 1);
        return new RecordQueryFetchFromPartialRecordPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), Objects.requireNonNull(this.translateValueFunction), this.resultType, this.fetchIndexRecords);
    }

    @Nonnull
    public Optional<Value> pushValue(@Nonnull Value value, @Nonnull CorrelationIdentifier sourceAlias, @Nonnull CorrelationIdentifier targetAlias) {
        return Objects.requireNonNull(this.translateValueFunction).translateValue(value, sourceAlias, targetAlias);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryFetchFromPartialRecordPlan(Quantifier.physical(childRef, this.inner.getAlias()), TranslateValueFunction.unableToTranslate(), this.resultType, this.fetchIndexRecords);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValueSupplier.get();
    }

    @Nonnull
    public Value computeResultValue() {
        return new DerivedValue(ImmutableList.of(QuantifiedObjectValue.of(this.inner.getAlias(), this.resultType)), this.resultType);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalences) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryFetchFromPartialRecordPlan otherFetchPlan = (RecordQueryFetchFromPartialRecordPlan)otherExpression;
        return this.fetchIndexRecords == otherFetchPlan.fetchIndexRecords;
    }

    public boolean equals(Object o) {
        return this.structuralEquals(o);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH, this.fetchIndexRecords.name());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return 13 + 7 * this.getChild().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChild());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.FETCH_OPERATOR), childGraphs);
    }

    @Override
    @Nonnull
    public PRecordQueryFetchFromPartialRecordPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryFetchFromPartialRecordPlan.newBuilder().setInner(this.inner.toProto(serializationContext)).setResultType(this.resultType.toTypeProto(serializationContext)).setFetchIndexRecords(this.fetchIndexRecords.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setFetchFromPartialRecordPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryFetchFromPartialRecordPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryFetchFromPartialRecordPlan recordQueryFetchFromPartialRecordPlanProto) {
        return new RecordQueryFetchFromPartialRecordPlan(serializationContext, recordQueryFetchFromPartialRecordPlanProto);
    }

    public static enum FetchIndexRecords {
        PRIMARY_KEY(new FetchIndexRecordsFunction(){

            @Override
            @Nonnull
            public <M extends Message> RecordCursor<FDBQueriedRecord<M>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> store, @Nonnull RecordCursor<IndexEntry> entryRecordCursor, @Nonnull ExecuteProperties executeProperties) {
                return store.fetchIndexRecords(entryRecordCursor, IndexOrphanBehavior.ERROR, executeProperties.getState()).map(store::queriedRecord);
            }
        }),
        SYNTHETIC_CONSTITUENTS(new FetchIndexRecordsFunction(){

            @Override
            @Nonnull
            public <M extends Message> RecordCursor<FDBQueriedRecord<M>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> store, @Nonnull RecordCursor<IndexEntry> entryRecordCursor, @Nonnull ExecuteProperties executeProperties) {
                return entryRecordCursor.mapPipelined(indexEntry -> store.loadSyntheticRecord(indexEntry.getPrimaryKey()).thenApply(syntheticRecord -> FDBQueriedRecord.synthetic(indexEntry.getIndex(), indexEntry, syntheticRecord)), store.getPipelineSize(PipelineOperation.INDEX_TO_RECORD));
            }
        });

        @Nonnull
        private final FetchIndexRecordsFunction fetchIndexRecordsFunction;

        private FetchIndexRecords(FetchIndexRecordsFunction fetchIndexRecordsFunction) {
            this.fetchIndexRecordsFunction = fetchIndexRecordsFunction;
        }

        @Nonnull
        <M extends Message> RecordCursor<FDBQueriedRecord<M>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> store, @Nonnull RecordCursor<IndexEntry> entryRecordCursor, @Nonnull ExecuteProperties executeProperties) {
            return this.fetchIndexRecordsFunction.fetchIndexRecords(store, entryRecordCursor, executeProperties);
        }

        @Nonnull
        public final PFetchIndexRecords toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case PRIMARY_KEY: {
                    return PFetchIndexRecords.PRIMARY_KEY;
                }
                case SYNTHETIC_CONSTITUENTS: {
                    return PFetchIndexRecords.SYNTHETIC_CONSTITUENTS;
                }
            }
            throw new RecordCoreException("unknown fetch index records mapping. did you forget to add it?", new Object[0]);
        }

        @Nonnull
        public static FetchIndexRecords fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFetchIndexRecords fetchIndexRecordsProto) {
            switch (fetchIndexRecordsProto) {
                case PRIMARY_KEY: {
                    return PRIMARY_KEY;
                }
                case SYNTHETIC_CONSTITUENTS: {
                    return SYNTHETIC_CONSTITUENTS;
                }
            }
            throw new RecordCoreException("unknown fetch index records mapping. did you forget to add it?", new Object[0]);
        }

        public static interface FetchIndexRecordsFunction {
            @Nonnull
            public <M extends Message> RecordCursor<FDBQueriedRecord<M>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull RecordCursor<IndexEntry> var2, @Nonnull ExecuteProperties var3);
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryFetchFromPartialRecordPlan, RecordQueryFetchFromPartialRecordPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryFetchFromPartialRecordPlan> getProtoMessageClass() {
            return PRecordQueryFetchFromPartialRecordPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryFetchFromPartialRecordPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryFetchFromPartialRecordPlan recordQueryFetchFromPartialRecordPlanProto) {
            return RecordQueryFetchFromPartialRecordPlan.fromProto(serializationContext, recordQueryFetchFromPartialRecordPlanProto);
        }
    }
}

