/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryFilterPlanBase;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryFilterPlanBase
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    @Nonnull
    private final Quantifier.Physical inner;
    @Nonnull
    private static final Set<StoreTimer.Count> inCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_FILTER_GIVEN, FDBStoreTimer.Counts.QUERY_FILTER_PLAN_GIVEN);
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_FILTER);
    @Nonnull
    private static final Set<StoreTimer.Count> successCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_FILTER_PASSED, FDBStoreTimer.Counts.QUERY_FILTER_PLAN_PASSED);
    @Nonnull
    private static final Set<StoreTimer.Count> failureCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_DISCARDED);

    protected RecordQueryFilterPlanBase(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryFilterPlanBase recordQueryFilterPlanBaseProto) {
        this(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryFilterPlanBaseProto.getInner())));
    }

    protected RecordQueryFilterPlanBase(@Nonnull Quantifier.Physical inner) {
        this.inner = inner;
    }

    protected abstract boolean hasAsyncFilter();

    @Nullable
    protected abstract <M extends Message> Boolean evalFilter(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nonnull QueryResult var3);

    @Nullable
    protected abstract <M extends Message> CompletableFuture<Boolean> evalFilterAsync(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nonnull QueryResult var3);

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordCursor<QueryResult> results = this.getInnerPlan().executePlan(store, context, continuation, executeProperties.clearSkipAndLimit());
        if (this.hasAsyncFilter()) {
            return results.filterAsyncInstrumented(result -> this.evalFilterAsync(store, context, (QueryResult)result), store.getPipelineSize(PipelineOperation.RECORD_ASYNC_FILTER), (StoreTimer)store.getTimer(), inCounts, duringEvents, successCounts, failureCounts).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
        }
        return results.filterInstrumented(result -> this.evalFilter(store, context, (QueryResult)result), (StoreTimer)store.getTimer(), inCounts, duringEvents, successCounts, failureCounts).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Nonnull
    public Quantifier.Physical getInner() {
        return this.inner;
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    public boolean isReverse() {
        return this.getInnerPlan().isReverse();
    }

    @Override
    public boolean hasRecordScan() {
        return this.getInnerPlan().hasRecordScan();
    }

    @Override
    public boolean hasFullRecordScan() {
        return this.getInnerPlan().hasFullRecordScan();
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.getInnerPlan().hasIndexScan(indexName);
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return this.getInnerPlan().getUsedIndexes();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_FILTER);
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInnerPlan().getComplexity();
    }

    @Nonnull
    protected PRecordQueryFilterPlanBase toRecordQueryFilterPlanBaseProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryFilterPlanBase.newBuilder().setInner(this.inner.toProto(serializationContext)).build();
    }
}

