/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryFlatMapPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class RecordQueryFlatMapPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Flat-Map-Plan");
    @Nonnull
    private final Quantifier.Physical outerQuantifier;
    @Nonnull
    private final Quantifier.Physical innerQuantifier;
    @Nonnull
    private final Value resultValue;
    private final boolean inheritOuterRecordProperties;

    public RecordQueryFlatMapPlan(@Nonnull Quantifier.Physical outerQuantifier, @Nonnull Quantifier.Physical innerQuantifier, @Nonnull Value resultValue, boolean inheritOuterRecordProperties) {
        this.outerQuantifier = outerQuantifier;
        this.innerQuantifier = innerQuantifier;
        this.resultValue = resultValue;
        this.inheritOuterRecordProperties = inheritOuterRecordProperties;
    }

    @Nonnull
    public Quantifier.Physical getOuterQuantifier() {
        return this.outerQuantifier;
    }

    @Nonnull
    public Quantifier.Physical getInnerQuantifier() {
        return this.innerQuantifier;
    }

    public boolean isInheritOuterRecordProperties() {
        return this.inheritOuterRecordProperties;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties nestedExecuteProperties = executeProperties.clearSkipAndLimit();
        return RecordCursor.flatMapPipelined(outerContinuation -> this.outerQuantifier.getRangesOverPlan().executePlan(store, context, (byte[])outerContinuation, nestedExecuteProperties), (outerResult, innerContinuation) -> {
            EvaluationContext fromOuterContext = context.withBinding(Bindings.Internal.CORRELATION, this.outerQuantifier.getAlias(), outerResult);
            return this.innerQuantifier.getRangesOverPlan().executePlan(store, fromOuterContext, (byte[])innerContinuation, nestedExecuteProperties).map(innerResult -> {
                EvaluationContext nestedContext = fromOuterContext.withBinding(Bindings.Internal.CORRELATION, this.innerQuantifier.getAlias(), innerResult);
                Object computed = this.resultValue.eval(store, nestedContext);
                return this.inheritOuterRecordProperties ? outerResult.withComputed(computed) : QueryResult.ofComputed(computed);
            });
        }, continuation, 5).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    public int getRelationalChildCount() {
        return 2;
    }

    @Override
    public boolean canCorrelate() {
        return true;
    }

    @Override
    @Nonnull
    public List<RecordQueryPlan> getChildren() {
        return ImmutableList.of(this.outerQuantifier.getRangesOverPlan(), this.innerQuantifier.getRangesOverPlan());
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.NO_FIELDS;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.resultValue.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryFlatMapPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 2);
        Value translatedResultValue = this.resultValue.translateCorrelations(translationMap, shouldSimplifyValues);
        return new RecordQueryFlatMapPlan(translatedQuantifiers.get(0).narrow(Quantifier.Physical.class), translatedQuantifiers.get(1).narrow(Quantifier.Physical.class), translatedResultValue, this.inheritOuterRecordProperties);
    }

    @Override
    public boolean isReverse() {
        return Quantifiers.isReversed(Quantifiers.narrow(Quantifier.Physical.class, this.getQuantifiers()));
    }

    @Override
    public RecordQueryFlatMapPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return this;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        return this.semanticEqualsForResults(otherExpression, aliasMap);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue(), this.inheritOuterRecordProperties);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
    }

    @Override
    public int getComplexity() {
        return this.outerQuantifier.getRangesOverPlan().getComplexity() * this.innerQuantifier.getRangesOverPlan().getComplexity();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren(), this.inheritOuterRecordProperties, this.getResultValue());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + mode.name() + " is not supported");
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.outerQuantifier, this.innerQuantifier);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.NESTED_LOOP_JOIN_OPERATOR, ImmutableList.of("FLATMAP {{expr}}"), ImmutableMap.of("expr", Attribute.gml(this.getResultValue().toString()))), childGraphs, this.getQuantifiers());
    }

    @Override
    @Nonnull
    public PRecordQueryFlatMapPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryFlatMapPlan.newBuilder().setOuterQuantifier(this.outerQuantifier.toProto(serializationContext)).setInnerQuantifier(this.innerQuantifier.toProto(serializationContext)).setResultValue(this.resultValue.toValueProto(serializationContext)).setInheritOuterRecordProperties(this.inheritOuterRecordProperties).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setFlatMapPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryFlatMapPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryFlatMapPlan recordQueryFlatMapPlanProto) {
        Verify.verifyNotNull(recordQueryFlatMapPlanProto.hasInheritOuterRecordProperties());
        return new RecordQueryFlatMapPlan(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryFlatMapPlanProto.getOuterQuantifier())), Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryFlatMapPlanProto.getInnerQuantifier())), Value.fromValueProto(serializationContext, Objects.requireNonNull(recordQueryFlatMapPlanProto.getResultValue())), recordQueryFlatMapPlanProto.getInheritOuterRecordProperties());
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryFlatMapPlan, RecordQueryFlatMapPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryFlatMapPlan> getProtoMessageClass() {
            return PRecordQueryFlatMapPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryFlatMapPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryFlatMapPlan recordQueryFlatMapPlanProto) {
            return RecordQueryFlatMapPlan.fromProto(serializationContext, recordQueryFlatMapPlanProto);
        }
    }
}

