/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.InComparandSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.SortedInComparandSource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class RecordQueryInComparandJoinPlan
extends RecordQueryInJoinPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-In-Comparand-Join-Plan");

    protected RecordQueryInComparandJoinPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInComparandJoinPlan recordQueryInComparandJoinPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryInComparandJoinPlanProto.getSuper()));
    }

    @HeuristicPlanner
    public RecordQueryInComparandJoinPlan(@Nonnull RecordQueryPlan plan, @Nonnull String bindingName, @Nonnull Bindings.Internal internal, @Nonnull Comparisons.Comparison comparison, boolean sortValues, boolean sortReverse) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(plan))), bindingName, internal, comparison, sortValues, sortReverse);
    }

    public RecordQueryInComparandJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull String bindingName, @Nonnull Bindings.Internal internal, @Nonnull Comparisons.Comparison comparison, boolean sortValues, boolean sortReverse) {
        this(inner, sortValues ? new SortedInComparandSource(bindingName, comparison, sortReverse) : new InComparandSource(bindingName, comparison), internal);
    }

    public RecordQueryInComparandJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull InComparandSource inSource, @Nonnull Bindings.Internal internal) {
        super(inner, inSource, internal);
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryInComparandJoinPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.inComparandSource(), this.internal);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryInComparandJoinPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.inComparandSource(), this.internal);
    }

    private InComparandSource inComparandSource() {
        return (InComparandSource)this.inSource;
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        if (this.internal == Bindings.Internal.IN) {
            return super.basePlanHash(mode, BASE_HASH, this.inComparandSource());
        }
        return super.basePlanHash(mode, BASE_HASH, new Object[0]);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_IN_COMPARAND);
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph.OperatorNodeWithInfo root = new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.NESTED_LOOP_JOIN_OPERATOR);
        PlannerGraph graphForInner = Iterables.getOnlyElement(childGraphs);
        PlannerGraph.LogicalOperatorNodeWithInfo explodeNode = new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.TABLE_FUNCTION_OPERATOR, ImmutableList.of("EXPLODE({{externalBinding}})"), ImmutableMap.of("externalBinding", Attribute.gml(this.inComparandSource().getComparison().typelessString())));
        PlannerGraph.Edge fromExplodeEdge = new PlannerGraph.Edge();
        return (PlannerGraph)PlannerGraph.builder(root).addGraph(graphForInner).addNode(explodeNode).addEdge(explodeNode, root, fromExplodeEdge).addEdge((PlannerGraph.Node)graphForInner.getRoot(), root, new PlannerGraph.Edge(ImmutableSet.of(fromExplodeEdge))).build();
    }

    @Override
    @Nonnull
    public PRecordQueryInComparandJoinPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryInComparandJoinPlan.newBuilder().setSuper(this.toRecordQueryInJoinPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setInComparandJoinPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryInComparandJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInComparandJoinPlan recordQueryInComparandJoinPlanProto) {
        return new RecordQueryInComparandJoinPlan(serializationContext, recordQueryInComparandJoinPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryInComparandJoinPlan, RecordQueryInComparandJoinPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryInComparandJoinPlan> getProtoMessageClass() {
            return PRecordQueryInComparandJoinPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryInComparandJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInComparandJoinPlan recordQueryInComparandJoinPlanProto) {
            return RecordQueryInComparandJoinPlan.fromProto(serializationContext, recordQueryInComparandJoinPlanProto);
        }
    }
}

