/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryInJoinPlan;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryInJoinPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild {
    @Nonnull
    protected final Quantifier.Physical inner;
    @Nonnull
    protected final InSource inSource;
    @Nonnull
    protected final Bindings.Internal internal;

    protected RecordQueryInJoinPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInJoinPlan inJoinPlanProto) {
        this(Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(inJoinPlanProto.getPhysicalQuantifier())), InSource.fromInSourceProto(serializationContext, Objects.requireNonNull(inJoinPlanProto.getInSource())), Bindings.Internal.fromProto(serializationContext, Objects.requireNonNull(inJoinPlanProto.getInternal())));
    }

    protected RecordQueryInJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull InSource inSource, @Nonnull Bindings.Internal internal) {
        Verify.verify(internal == Bindings.Internal.IN || internal == Bindings.Internal.CORRELATION);
        this.inner = inner;
        this.inSource = inSource;
        this.internal = internal;
    }

    @Nonnull
    public Quantifier.Physical getInner() {
        return this.inner;
    }

    @Nonnull
    public InSource getInSource() {
        return this.inSource;
    }

    @Nonnull
    public CorrelationIdentifier getInAlias() {
        return CorrelationIdentifier.of(this.internal.identifier(this.inSource.getBindingName()));
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return RecordCursor.flatMapPipelined(outerContinuation -> RecordCursor.fromList(store.getExecutor(), this.getValues(context), outerContinuation), (outerValue, innerContinuation) -> {
            Object bindingValue = this.internal == Bindings.Internal.IN ? outerValue : QueryResult.ofComputed(outerValue);
            return this.getInnerPlan().executePlan(store, context.withBinding(this.inSource.getBindingName(), bindingValue), (byte[])innerContinuation, executeProperties.clearSkipAndLimit());
        }, outerObject -> {
            if (outerObject instanceof DynamicMessage) {
                return ((DynamicMessage)outerObject).toByteArray();
            }
            return Tuple.from(ScanComparisons.toTupleItem(outerObject)).pack();
        }, continuation, store.getPipelineSize(PipelineOperation.IN_JOIN)).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    public boolean isReverse() {
        if (this.inSource.isSorted()) {
            return this.inSource.isReverse();
        }
        throw new RecordCoreException("RecordQueryInJoinPlan does not have well defined reverse-ness", new Object[0]);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        Type resultType = this.inSource.getResultType();
        if (!resultType.isAny()) {
            ImmutableSet.Builder resultTypesBuilder = ImmutableSet.builder();
            resultTypesBuilder.addAll(RecordQueryPlanWithChild.super.getDynamicTypes());
            resultTypesBuilder.add(resultType);
            return resultTypesBuilder.build();
        }
        return RecordQueryPlanWithChild.super.getDynamicTypes();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        CorrelationIdentifier inAlias = this.getInAlias();
        this.inner.getCorrelatedTo().stream().filter(alias -> !alias.equals(inAlias)).forEach(builder::add);
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    public boolean canCorrelate() {
        return true;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryInJoinPlan other = (RecordQueryInJoinPlan)otherExpression;
        return this.inSource.equals(other.inSource);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return this.inSource.hashCode();
    }

    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: {
                if (this.internal == Bindings.Internal.IN) {
                    return this.getInnerPlan().planHash(mode) + this.inSource.getBindingName().hashCode() + (this.inSource.isSorted() ? 1 : 0) + (this.inSource.isReverse() ? 1 : 0);
                }
            }
            case FOR_CONTINUATION: {
                if (this.internal == Bindings.Internal.IN) {
                    return PlanHashable.objectsPlanHash(mode, baseHash, this.getInnerPlan(), this.inSource.getBindingName(), this.inSource.isSorted(), this.inSource.isReverse(), hashables);
                }
                return PlanHashable.objectsPlanHash(mode, baseHash, this.getInnerPlan(), this.inSource, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    protected List<Object> getValues(EvaluationContext context) {
        return this.inSource.getValues(context);
    }

    @Override
    public int getComplexity() {
        return 1 + this.getInnerPlan().getComplexity();
    }

    @Nonnull
    public PRecordQueryInJoinPlan toRecordQueryInJoinPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryInJoinPlan.newBuilder().setPhysicalQuantifier(this.inner.toProto(serializationContext)).setInSource(this.inSource.toInSourceProto(serializationContext)).setInternal(this.internal.toProto(serializationContext)).build();
    }
}

