/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.SortedInParameterSource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class RecordQueryInParameterJoinPlan
extends RecordQueryInJoinPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-In-Parameter-Join-Plan");

    protected RecordQueryInParameterJoinPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInParameterJoinPlan recordQueryInParameterJoinPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryInParameterJoinPlanProto.getSuper()));
    }

    @HeuristicPlanner
    public RecordQueryInParameterJoinPlan(@Nonnull RecordQueryPlan plan, @Nonnull String bindingName, @Nonnull Bindings.Internal internal, @Nonnull String externalBinding, boolean sortValues, boolean sortReverse) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(plan))), bindingName, internal, externalBinding, sortValues, sortReverse);
    }

    public RecordQueryInParameterJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull String bindingName, @Nonnull Bindings.Internal internal, @Nonnull String externalBinding, boolean sortValues, boolean sortReverse) {
        this(inner, sortValues ? new SortedInParameterSource(bindingName, externalBinding, sortReverse) : new InParameterSource(bindingName, externalBinding), internal);
    }

    public RecordQueryInParameterJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull InSource inSource, @Nonnull Bindings.Internal internal) {
        super(inner, inSource, internal);
    }

    @Nonnull
    private InParameterSource inParameterSource() {
        return (InParameterSource)this.inSource;
    }

    public String getExternalBinding() {
        return this.inParameterSource().getParameterName();
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public RecordQueryInParameterJoinPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryInParameterJoinPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.inSource, this.internal);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryInParameterJoinPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.inSource, this.internal);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                if (this.internal == Bindings.Internal.IN) {
                    return super.basePlanHash(mode, BASE_HASH, new Object[0]) + this.inParameterSource().getParameterName().hashCode();
                }
            }
            case FOR_CONTINUATION: {
                if (this.internal == Bindings.Internal.IN) {
                    return super.basePlanHash(mode, BASE_HASH, this.inParameterSource().getParameterName());
                }
                return super.basePlanHash(mode, BASE_HASH, new Object[0]);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_IN_PARAMETER);
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph.OperatorNodeWithInfo root = new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.NESTED_LOOP_JOIN_OPERATOR);
        PlannerGraph graphForInner = Iterables.getOnlyElement(childGraphs);
        PlannerGraph.LogicalOperatorNodeWithInfo explodeNode = new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.TABLE_FUNCTION_OPERATOR, ImmutableList.of("EXPLODE({{externalBinding}})"), ImmutableMap.of("externalBinding", Attribute.gml(this.inParameterSource().getParameterName())));
        PlannerGraph.Edge fromExplodeEdge = new PlannerGraph.Edge();
        return (PlannerGraph)PlannerGraph.builder(root).addGraph(graphForInner).addNode(explodeNode).addEdge(explodeNode, root, fromExplodeEdge).addEdge((PlannerGraph.Node)graphForInner.getRoot(), root, new PlannerGraph.Edge(ImmutableSet.of(fromExplodeEdge))).build();
    }

    @Override
    @Nonnull
    public PRecordQueryInParameterJoinPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryInParameterJoinPlan.newBuilder().setSuper(this.toRecordQueryInJoinPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setInParameterJoinPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryInParameterJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInParameterJoinPlan recordQueryInParameterJoinPlanProto) {
        return new RecordQueryInParameterJoinPlan(serializationContext, recordQueryInParameterJoinPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryInParameterJoinPlan, RecordQueryInParameterJoinPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryInParameterJoinPlan> getProtoMessageClass() {
            return PRecordQueryInParameterJoinPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryInParameterJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInParameterJoinPlan recordQueryInParameterJoinPlanProto) {
            return RecordQueryInParameterJoinPlan.fromProto(serializationContext, recordQueryInParameterJoinPlanProto);
        }
    }
}

