/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisonKeyValues;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordQueryInUnionOnValuesPlan
extends RecordQueryInUnionPlan
implements RecordQueryPlanWithComparisonKeyValues {
    @Nullable
    private final List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts;

    protected RecordQueryInUnionOnValuesPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInUnionOnValuesPlan recordQueryInUnionOnValuesPlanProto) {
        super(serializationContext, recordQueryInUnionOnValuesPlanProto.getSuper());
        this.comparisonKeyOrderingParts = null;
    }

    public RecordQueryInUnionOnValuesPlan(@Nonnull Quantifier.Physical inner, @Nonnull List<? extends InSource> inSources, @Nullable List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, @Nonnull List<? extends Value> comparisonKeyValues, boolean isReverse, int maxNumberOfValuesAllowed, @Nonnull Bindings.Internal internal) {
        super(inner, inSources, new RecordQuerySetPlan.ComparisonKeyFunction.OnValues(Quantifier.current(), comparisonKeyValues), isReverse, maxNumberOfValuesAllowed, internal);
        this.comparisonKeyOrderingParts = comparisonKeyOrderingParts == null ? null : ImmutableList.copyOf(comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction.OnValues getComparisonKeyFunction() {
        return (RecordQuerySetPlan.ComparisonKeyFunction.OnValues)super.getComparisonKeyFunction();
    }

    @Override
    @Nonnull
    public List<? extends Value> getRequiredValues(@Nonnull CorrelationIdentifier newBaseAlias, @Nonnull Type inputType) {
        DefaultValueSimplificationRuleSet ruleSet = DefaultValueSimplificationRuleSet.instance();
        return this.getComparisonKeyValues().stream().map(comparisonKeyValue -> comparisonKeyValue.rebase(AliasMap.ofAliases(Quantifier.current(), newBaseAlias)).simplify(ruleSet, EvaluationContext.empty(), AliasMap.emptyMap(), this.getCorrelatedTo())).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Set<KeyExpression> getRequiredFields() {
        throw new RecordCoreException("this plan does not support this getRequiredFields()", new Object[0]);
    }

    @Override
    @Nonnull
    public List<OrderingPart.ProvidedOrderingPart> getComparisonKeyOrderingParts() {
        return Objects.requireNonNull(this.comparisonKeyOrderingParts);
    }

    @Override
    @Nonnull
    public List<? extends Value> getComparisonKeyValues() {
        return this.getComparisonKeyFunction().getComparisonKeyValues();
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.getComparisonKeyValues().stream().flatMap(comparisonKeyValue -> comparisonKeyValue.getDynamicTypes().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public RecordQueryInUnionOnValuesPlan withChildrenReferences(@Nonnull List<? extends Reference> newChildren) {
        return this.withChild(Iterables.getOnlyElement(newChildren));
    }

    @Override
    @Nonnull
    public RecordQueryInUnionOnValuesPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryInUnionOnValuesPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.getInSources(), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.reverse, this.maxNumberOfValuesAllowed, this.internal);
    }

    @Override
    @Nonnull
    public RecordQueryInUnionOnValuesPlan withChild(@Nonnull Reference childRef) {
        return new RecordQueryInUnionOnValuesPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.getInSources(), this.comparisonKeyOrderingParts, this.getComparisonKeyValues(), this.reverse, this.maxNumberOfValuesAllowed, this.internal);
    }

    @Override
    @Nonnull
    public PRecordQueryInUnionOnValuesPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryInUnionOnValuesPlan.newBuilder().setSuper(this.toRecordQueryInUnionPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setInUnionOnValuesPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryInUnionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInUnionOnValuesPlan recordQueryInUnionOnValuesPlanProto) {
        return new RecordQueryInUnionOnValuesPlan(serializationContext, recordQueryInUnionOnValuesPlanProto);
    }

    @Nonnull
    public static RecordQueryInUnionOnValuesPlan inUnion(@Nonnull Quantifier.Physical inner, @Nonnull List<? extends InSource> inSources, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse, int maxNumberOfValuesAllowed, @Nonnull Bindings.Internal internal) {
        return new RecordQueryInUnionOnValuesPlan(inner, inSources, comparisonKeyOrderingParts, OrderingPart.ProvidedOrderingPart.comparisonKeyValues(comparisonKeyOrderingParts, isReverse), isReverse, maxNumberOfValuesAllowed, internal);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryInUnionOnValuesPlan, RecordQueryInUnionOnValuesPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryInUnionOnValuesPlan> getProtoMessageClass() {
            return PRecordQueryInUnionOnValuesPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryInUnionOnValuesPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInUnionOnValuesPlan recordQueryInUnionOnValuesPlanProto) {
            return RecordQueryInUnionOnValuesPlan.fromProto(serializationContext, recordQueryInUnionOnValuesPlanProto);
        }
    }
}

