/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryInUnionPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursor;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class RecordQueryInUnionPlan
extends AbstractRelationalExpressionWithChildren
implements RecordQueryPlanWithChild,
RecordQuerySetPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("In-Union-Plan");
    @Nonnull
    protected final Quantifier.Physical inner;
    @Nonnull
    private final List<? extends InSource> inSources;
    @Nonnull
    private final RecordQuerySetPlan.ComparisonKeyFunction comparisonKeyFunction;
    protected final boolean reverse;
    protected final int maxNumberOfValuesAllowed;
    @Nonnull
    protected final Bindings.Internal internal;

    protected RecordQueryInUnionPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInUnionPlan recordQueryInUnionPlanProto) {
        Verify.verify(recordQueryInUnionPlanProto.hasReverse());
        Verify.verify(recordQueryInUnionPlanProto.hasMaxNumberOfValuesAllowed());
        Bindings.Internal internal = Bindings.Internal.fromProto(serializationContext, Objects.requireNonNull(recordQueryInUnionPlanProto.getInternal()));
        Verify.verify(internal == Bindings.Internal.IN || internal == Bindings.Internal.CORRELATION);
        ImmutableList.Builder inSourcesBuilder = ImmutableList.builder();
        for (int i = 0; i < recordQueryInUnionPlanProto.getInSourcesCount(); ++i) {
            inSourcesBuilder.add(InSource.fromInSourceProto(serializationContext, recordQueryInUnionPlanProto.getInSources(i)));
        }
        this.inner = Quantifier.Physical.fromProto(serializationContext, Objects.requireNonNull(recordQueryInUnionPlanProto.getInner()));
        this.inSources = inSourcesBuilder.build();
        this.comparisonKeyFunction = RecordQuerySetPlan.ComparisonKeyFunction.fromComparisonKeyFunctionProto(serializationContext, Objects.requireNonNull(recordQueryInUnionPlanProto.getComparisonKeyFunction()));
        this.reverse = recordQueryInUnionPlanProto.getReverse();
        this.maxNumberOfValuesAllowed = recordQueryInUnionPlanProto.getMaxNumberOfValuesAllowed();
        this.internal = internal;
    }

    protected RecordQueryInUnionPlan(@Nonnull Quantifier.Physical inner, @Nonnull List<? extends InSource> inSources, @Nonnull RecordQuerySetPlan.ComparisonKeyFunction comparisonKeyFunction, boolean reverse, int maxNumberOfValuesAllowed, @Nonnull Bindings.Internal internal) {
        Verify.verify(internal == Bindings.Internal.IN || internal == Bindings.Internal.CORRELATION);
        this.inner = inner;
        this.inSources = inSources;
        this.comparisonKeyFunction = comparisonKeyFunction;
        this.reverse = reverse;
        this.maxNumberOfValuesAllowed = maxNumberOfValuesAllowed;
        this.internal = internal;
    }

    @Nonnull
    public RecordQuerySetPlan.ComparisonKeyFunction getComparisonKeyFunction() {
        return this.comparisonKeyFunction;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Nonnull
    public List<? extends InSource> getInSources() {
        return this.inSources;
    }

    @Nonnull
    public CorrelationIdentifier getInAlias(@Nonnull InSource inSource) {
        return CorrelationIdentifier.of(this.internal.identifier(inSource.getBindingName()));
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        int size = this.getValuesSize(context);
        if (size > this.maxNumberOfValuesAllowed) {
            throw new RecordCoreException("too many IN values", new Object[0]).addLogInfo("size", (Object)size);
        }
        if (size == 0) {
            return RecordCursor.empty();
        }
        RecordQueryPlan childPlan = this.getInnerPlan();
        if (size == 1) {
            EvaluationContext childContext2 = this.getValuesContexts(context).get(0);
            return childPlan.executePlan(store, childContext2, continuation, executeProperties);
        }
        ExecuteProperties childExecuteProperties = executeProperties.getSkip() > 0 ? executeProperties.clearSkipAndAdjustLimit() : executeProperties;
        List childCursorFunctions = this.getValuesContexts(context).stream().map(childContext -> childContinuation -> childPlan.executePlan(store, (EvaluationContext)childContext, (byte[])childContinuation, childExecuteProperties)).collect(Collectors.toList());
        return UnionCursor.create(this.comparisonKeyFunction.apply(store, context), this.reverse, childCursorFunctions, continuation, store.getTimer()).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Nonnull
    public RecordQueryPlan getInnerPlan() {
        return this.inner.getRangesOverPlan();
    }

    @Override
    @Nonnull
    public RecordQueryPlan getChild() {
        return this.getInnerPlan();
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_IN_UNION);
        this.getInnerPlan().logPlanStructure(timer);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet inAliases = this.getInSources().stream().map(inSource -> CorrelationIdentifier.of(Bindings.Internal.CORRELATION.identifier(inSource.getBindingName()))).collect(ImmutableSet.toImmutableSet());
        this.inner.getCorrelatedTo().stream().filter(alias -> !inAliases.contains(alias)).forEach(builder::add);
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    public boolean canCorrelate() {
        return true;
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph.OperatorNodeWithInfo root = new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.IN_UNION_OPERATOR, ImmutableList.of("COMPARE BY {{comparisonKey}}"), ImmutableMap.of("comparisonKey", Attribute.gml(this.comparisonKeyFunction.toString())));
        PlannerGraph graphForInner = Iterables.getOnlyElement(childGraphs);
        PlannerGraph.DataNodeWithInfo valuesNode = new PlannerGraph.DataNodeWithInfo(NodeInfo.VALUES_DATA, this.getResultType(), ImmutableList.of("VALUES({{values}}"), ImmutableMap.of("values", Attribute.gml(Objects.requireNonNull(this.inSources).stream().map(String::valueOf).map(Attribute::gml).collect(ImmutableList.toImmutableList()))));
        PlannerGraph.Edge fromValuesEdge = new PlannerGraph.Edge();
        return (PlannerGraph)PlannerGraph.builder(root).addGraph(graphForInner).addNode(valuesNode).addEdge(valuesNode, root, fromValuesEdge).addEdge((PlannerGraph.Node)graphForInner.getRoot(), root, new PlannerGraph.Edge(ImmutableSet.of(fromValuesEdge))).build();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Nonnull
    public Quantifier.Physical getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public abstract RecordQueryInUnionPlan withChild(@Nonnull Reference var1);

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryInUnionPlan other = (RecordQueryInUnionPlan)otherExpression;
        return this.inSources.equals(other.inSources) && this.comparisonKeyFunction.equals(other.comparisonKeyFunction);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.inSources, this.comparisonKeyFunction);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInnerPlan(), this.inSources, this.comparisonKeyFunction);
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public int getComplexity() {
        int complexity = this.getInnerPlan().getComplexity();
        for (InSource inSource : this.inSources) {
            if (!(inSource instanceof InValuesSource)) continue;
            complexity *= inSource.size(EvaluationContext.EMPTY);
        }
        return complexity;
    }

    protected int getValuesSize(@Nonnull EvaluationContext context) {
        int size = 1;
        for (InSource inSource : this.inSources) {
            size *= inSource.size(context);
        }
        return size;
    }

    @Nonnull
    protected List<EvaluationContext> getValuesContexts(@Nonnull EvaluationContext context) {
        List<EvaluationContext> parents = Collections.singletonList(context);
        for (InSource inSource : this.inSources) {
            ArrayList<EvaluationContext> children = new ArrayList<EvaluationContext>();
            for (EvaluationContext parent : parents) {
                for (Object value : inSource.getValues(parent)) {
                    Object bindingValue = this.internal == Bindings.Internal.IN ? value : QueryResult.ofComputed(value);
                    children.add(parent.withBinding(inSource.getBindingName(), bindingValue));
                }
            }
            parents = children;
        }
        return parents;
    }

    @Nonnull
    protected PRecordQueryInUnionPlan toRecordQueryInUnionPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryInUnionPlan.Builder builder = PRecordQueryInUnionPlan.newBuilder().setInner(this.inner.toProto(serializationContext));
        for (InSource inSource : this.inSources) {
            builder.addInSources(inSource.toInSourceProto(serializationContext));
        }
        return builder.setComparisonKeyFunction(this.comparisonKeyFunction.toComparisonKeyFunctionProto(serializationContext)).setReverse(this.reverse).setMaxNumberOfValuesAllowed(this.maxNumberOfValuesAllowed).setInternal(this.internal.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryInUnionOnKeyExpressionPlan from(@Nonnull Quantifier.Physical inner, @Nonnull List<? extends InSource> inSources, @Nonnull KeyExpression comparisonKey, int maxNumberOfValuesAllowed, @Nonnull Bindings.Internal internal) {
        return new RecordQueryInUnionOnKeyExpressionPlan(inner, inSources, comparisonKey, Quantifiers.isReversed(ImmutableList.of(inner)), maxNumberOfValuesAllowed, internal);
    }

    @Nonnull
    public static RecordQueryInUnionOnValuesPlan from(@Nonnull Quantifier.Physical inner, @Nonnull List<? extends InSource> inSources, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse, int maxNumberOfValuesAllowed, @Nonnull Bindings.Internal internal) {
        return RecordQueryInUnionOnValuesPlan.inUnion(inner, inSources, comparisonKeyOrderingParts, isReverse, maxNumberOfValuesAllowed, internal);
    }

    @Nonnull
    @HeuristicPlanner
    public static RecordQueryInUnionOnKeyExpressionPlan from(@Nonnull RecordQueryPlan inner, @Nonnull List<? extends InSource> inSources, @Nonnull KeyExpression comparisonKey, boolean isReverse, int maxNumberOfValuesAllowed, @Nonnull Bindings.Internal internal) {
        return new RecordQueryInUnionOnKeyExpressionPlan(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(inner))), inSources, comparisonKey, isReverse, maxNumberOfValuesAllowed, internal);
    }
}

