/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.SortedInValuesSource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class RecordQueryInValuesJoinPlan
extends RecordQueryInJoinPlan {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-In-Values-Join-Plan");

    protected RecordQueryInValuesJoinPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInValuesJoinPlan recordQueryInValuesJoinPlanProto) {
        super(serializationContext, Objects.requireNonNull(recordQueryInValuesJoinPlanProto.getSuper()));
    }

    @HeuristicPlanner
    public RecordQueryInValuesJoinPlan(RecordQueryPlan plan, @Nonnull String bindingName, @Nonnull Bindings.Internal internal, @Nonnull List<Object> values, boolean sortValues, boolean sortReverse) {
        this(Quantifier.physical(Reference.plannedOf(Debugger.verifyHeuristicPlanner(plan))), bindingName, internal, values, sortValues, sortReverse);
    }

    private RecordQueryInValuesJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull String bindingName, @Nonnull Bindings.Internal internal, @Nonnull List<Object> values, boolean sortValues, boolean sortReverse) {
        super(inner, sortValues ? new SortedInValuesSource(bindingName, values, sortReverse) : new InValuesSource(bindingName, values), internal);
    }

    public RecordQueryInValuesJoinPlan(@Nonnull Quantifier.Physical inner, @Nonnull InValuesSource inSource, @Nonnull Bindings.Internal internal) {
        super(inner, inSource, internal);
    }

    @Nonnull
    private InValuesSource inValuesSource() {
        return (InValuesSource)this.inSource;
    }

    @Override
    @Nonnull
    public List<Object> getValues(EvaluationContext context) {
        return this.getInListValues();
    }

    @Nonnull
    public List<Object> getInListValues() {
        return this.inSource.getValues();
    }

    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    @Nonnull
    public RecordQueryInValuesJoinPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new RecordQueryInValuesJoinPlan(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.Physical.class), this.inValuesSource(), this.internal);
    }

    @Override
    @Nonnull
    public RecordQueryPlanWithChild withChild(@Nonnull Reference childRef) {
        return new RecordQueryInValuesJoinPlan(Quantifier.physical(childRef, this.inner.getAlias()), this.inValuesSource(), this.internal);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                if (this.internal == Bindings.Internal.IN) {
                    return super.basePlanHash(mode, BASE_HASH, new Object[0]) + PlanHashable.iterablePlanHash(mode, this.inSource.getValues());
                }
            }
            case FOR_CONTINUATION: {
                if (this.internal == Bindings.Internal.IN) {
                    return super.basePlanHash(mode, BASE_HASH, this.inSource.getValues());
                }
                return super.basePlanHash(mode, BASE_HASH, new Object[0]);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " not supported");
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_IN_VALUES);
        this.getChild().logPlanStructure(timer);
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        PlannerGraph.OperatorNodeWithInfo root = new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.NESTED_LOOP_JOIN_OPERATOR);
        PlannerGraph graphForInner = Iterables.getOnlyElement(childGraphs);
        PlannerGraph.DataNodeWithInfo valuesNode = new PlannerGraph.DataNodeWithInfo(NodeInfo.VALUES_DATA, this.getResultType(), ImmutableList.of("VALUES({{values}}"), ImmutableMap.of("values", Attribute.gml(Objects.requireNonNull(this.getInListValues()).stream().map(String::valueOf).map(Attribute::gml).collect(ImmutableList.toImmutableList()))));
        PlannerGraph.Edge fromValuesEdge = new PlannerGraph.Edge();
        return (PlannerGraph)PlannerGraph.builder(root).addGraph(graphForInner).addNode(valuesNode).addEdge(valuesNode, root, fromValuesEdge).addEdge((PlannerGraph.Node)graphForInner.getRoot(), root, new PlannerGraph.Edge(ImmutableSet.of(fromValuesEdge))).build();
    }

    @Override
    @Nonnull
    public PRecordQueryInValuesJoinPlan toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryInValuesJoinPlan.newBuilder().setSuper(this.toRecordQueryInJoinPlanProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setInValuesJoinPlan(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryInValuesJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInValuesJoinPlan recordQueryInValuesJoinPlanProto) {
        return new RecordQueryInValuesJoinPlan(serializationContext, recordQueryInValuesJoinPlanProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryInValuesJoinPlan, RecordQueryInValuesJoinPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryInValuesJoinPlan> getProtoMessageClass() {
            return PRecordQueryInValuesJoinPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryInValuesJoinPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryInValuesJoinPlan recordQueryInValuesJoinPlanProto) {
            return RecordQueryInValuesJoinPlan.fromProto(serializationContext, recordQueryInValuesJoinPlanProto);
        }
    }
}

