/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.plans;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.FallbackCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PRecordQueryIndexPlan;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.APIVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursorBase;
import com.apple.foundationdb.record.provider.foundationdb.MultidimensionalIndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.UnsupportedRemoteFetchIndexException;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRanges;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithConstraint;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithMatchCandidate;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordQueryIndexPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren,
RecordQueryPlanWithComparisons,
RecordQueryPlanWithIndex,
PlannerGraphRewritable,
RecordQueryPlanWithMatchCandidate,
RecordQueryPlanWithConstraint {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordQueryIndexPlan.class);
    protected static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Query-Index-Plan");
    @Nonnull
    protected final String indexName;
    @Nullable
    private final KeyExpression commonPrimaryKey;
    @Nonnull
    protected final IndexScanParameters scanParameters;
    @Nonnull
    private IndexFetchMethod indexFetchMethod;
    @Nonnull
    private final RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords;
    protected final boolean reverse;
    protected final boolean strictlySorted;
    @Nonnull
    private final Optional<? extends MatchCandidate> matchCandidateOptional;
    @Nonnull
    private final Type resultType;
    @Nonnull
    private final QueryPlanConstraint constraint;
    @Nonnull
    private final Supplier<ComparisonRanges> comparisonRangesSupplier;
    @Nonnull
    private final KeyValueCursorBase.SerializationMode serializationMode;

    public RecordQueryIndexPlan(@Nonnull String indexName, @Nonnull IndexScanParameters scanParameters, boolean reverse) {
        this(indexName, null, scanParameters, IndexFetchMethod.SCAN_AND_FETCH, RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, reverse, false);
    }

    public RecordQueryIndexPlan(@Nonnull String indexName, @Nullable KeyExpression commonPrimaryKey, @Nonnull IndexScanParameters scanParameters, @Nonnull IndexFetchMethod useIndexPrefetch, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, boolean strictlySorted) {
        this(indexName, commonPrimaryKey, scanParameters, useIndexPrefetch, fetchIndexRecords, reverse, strictlySorted, Optional.empty(), new Type.Any(), QueryPlanConstraint.noConstraint());
    }

    public RecordQueryIndexPlan(@Nonnull String indexName, @Nullable KeyExpression commonPrimaryKey, @Nonnull IndexScanParameters scanParameters, @Nonnull IndexFetchMethod indexFetchMethod, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, boolean strictlySorted, @Nonnull MatchCandidate matchCandidate, @Nonnull Type.Record resultType, @Nonnull QueryPlanConstraint constraint) {
        this(indexName, commonPrimaryKey, scanParameters, indexFetchMethod, fetchIndexRecords, reverse, strictlySorted, Optional.of(matchCandidate), (Type)resultType, constraint);
    }

    protected RecordQueryIndexPlan(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIndexPlan recordQueryIndexPlanProto) {
        this(Objects.requireNonNull(recordQueryIndexPlanProto.getIndexName()), recordQueryIndexPlanProto.hasCommonPrimaryKey() ? KeyExpression.fromProto(recordQueryIndexPlanProto.getCommonPrimaryKey()) : null, IndexScanParameters.fromIndexScanParametersProto(serializationContext, Objects.requireNonNull(recordQueryIndexPlanProto.getScanParameters())), IndexFetchMethod.fromProto(serializationContext, Objects.requireNonNull(recordQueryIndexPlanProto.getIndexFetchMethod())), RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.fromProto(serializationContext, Objects.requireNonNull(recordQueryIndexPlanProto.getFetchIndexRecords())), recordQueryIndexPlanProto.getReverse(), recordQueryIndexPlanProto.getStrictlySorted(), Optional.empty(), Type.fromTypeProto(serializationContext, Objects.requireNonNull(recordQueryIndexPlanProto.getResultType())), QueryPlanConstraint.fromProto(serializationContext, Objects.requireNonNull(recordQueryIndexPlanProto.getConstraint())));
    }

    @VisibleForTesting
    public RecordQueryIndexPlan(@Nonnull String indexName, @Nullable KeyExpression commonPrimaryKey, @Nonnull IndexScanParameters scanParameters, @Nonnull IndexFetchMethod indexFetchMethod, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, boolean strictlySorted, @Nonnull Optional<? extends MatchCandidate> matchCandidateOptional, @Nonnull Type resultType, @Nonnull QueryPlanConstraint constraint) {
        this(indexName, commonPrimaryKey, scanParameters, indexFetchMethod, fetchIndexRecords, reverse, strictlySorted, matchCandidateOptional, resultType, constraint, KeyValueCursorBase.SerializationMode.TO_OLD);
    }

    @VisibleForTesting
    public RecordQueryIndexPlan(@Nonnull String indexName, @Nullable KeyExpression commonPrimaryKey, @Nonnull IndexScanParameters scanParameters, @Nonnull IndexFetchMethod indexFetchMethod, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, boolean strictlySorted, @Nonnull Optional<? extends MatchCandidate> matchCandidateOptional, @Nonnull Type resultType, @Nonnull QueryPlanConstraint constraint, @Nonnull KeyValueCursorBase.SerializationMode serializationMode) {
        this.indexName = indexName;
        this.commonPrimaryKey = commonPrimaryKey;
        this.scanParameters = scanParameters;
        this.indexFetchMethod = indexFetchMethod;
        this.fetchIndexRecords = fetchIndexRecords;
        this.reverse = reverse;
        this.strictlySorted = strictlySorted;
        this.matchCandidateOptional = matchCandidateOptional;
        this.resultType = resultType;
        if (indexFetchMethod != IndexFetchMethod.SCAN_AND_FETCH && !scanParameters.getScanType().equals(IndexScanType.BY_VALUE)) {
            this.logDebug("Index remote fetch can only be used with VALUE index scan. Falling back to regular scan.");
            this.indexFetchMethod = IndexFetchMethod.SCAN_AND_FETCH;
        }
        this.constraint = constraint;
        this.comparisonRangesSupplier = Suppliers.memoize(this::computeComparisonRanges);
        this.serializationMode = serializationMode;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        IndexFetchMethod fetchMethod = this.indexFetchMethod;
        if (this.indexFetchMethod != IndexFetchMethod.SCAN_AND_FETCH && !store.getContext().getAPIVersion().isAtLeast(APIVersion.API_VERSION_7_1)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(KeyValueLogMessage.of("Index remote fetch can only be used with API_VERSION of at least 7.1. Falling back to regular scan.", new Object[]{LogMessageKeys.PLAN_HASH, this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION)}));
            }
            fetchMethod = IndexFetchMethod.SCAN_AND_FETCH;
        }
        switch (fetchMethod) {
            case SCAN_AND_FETCH: {
                return RecordQueryPlanWithIndex.super.executePlan(store, context, continuation, executeProperties);
            }
            case USE_REMOTE_FETCH: {
                return this.executeUsingRemoteFetch(store, context, continuation, executeProperties);
            }
            case USE_REMOTE_FETCH_WITH_FALLBACK: {
                try {
                    return new FallbackCursor<QueryResult>(this.executeUsingRemoteFetch(store, context, continuation, executeProperties), lastSuccessfulResult -> this.fallBackContinueFrom(store, context, continuation, executeProperties, (RecordCursorResult<QueryResult>)lastSuccessfulResult));
                }
                catch (UnsupportedRemoteFetchIndexException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(KeyValueLogMessage.of("Remote fetch unsupported, continuing with Index scan", new Object[]{LogMessageKeys.MESSAGE, ex.getMessage(), LogMessageKeys.INDEX_NAME, this.indexName}));
                    }
                    return RecordQueryPlanWithIndex.super.executePlan(store, context, continuation, executeProperties);
                }
                catch (Exception ex) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(KeyValueLogMessage.of("Remote Fetch execution failed, falling back to Index scan", new Object[]{LogMessageKeys.PLAN_HASH, this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION)}), ex);
                    }
                    return RecordQueryPlanWithIndex.super.executePlan(store, context, continuation, executeProperties);
                }
            }
        }
        throw new RecordCoreException("Unknown useIndexPrefetch option", new Object[0]).addLogInfo("option", (Object)this.indexFetchMethod);
    }

    @Nonnull
    private <M extends Message> RecordCursor<QueryResult> executeUsingRemoteFetch(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordMetaData metaData = store.getRecordMetaData();
        Index index = metaData.getIndex(this.indexName);
        IndexScanBounds scanBounds = this.scanParameters.bind(store, index, context);
        return store.scanIndexRemoteFetch(index, scanBounds, continuation, executeProperties.asScanProperties(this.isReverse()), IndexOrphanBehavior.ERROR).map(store::queriedRecord).map(QueryResult::fromQueriedRecord);
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<IndexEntry> executeEntries(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordMetaData metaData = store.getRecordMetaData();
        Index index = metaData.getIndex(this.indexName);
        IndexScanBounds scanBounds = this.scanParameters.bind(store, index, context);
        if (!IndexScanType.BY_VALUE_OVER_SCAN.equals(this.getScanType())) {
            return store.scanIndex(index, scanBounds, continuation, executeProperties.asScanProperties(this.reverse));
        }
        if (!(scanBounds instanceof IndexScanRange)) {
            return store.scanIndex(index, scanBounds, continuation, executeProperties.asScanProperties(this.reverse));
        }
        IndexScanRange indexScanRange = (IndexScanRange)scanBounds;
        TupleRange tupleScanRange = indexScanRange.getScanRange();
        TupleRange widenedScanRange = this.widenRange(tupleScanRange);
        if (widenedScanRange == null) {
            return store.scanIndex(index, scanBounds, continuation, executeProperties.asScanProperties(this.reverse));
        }
        return this.executeEntriesWithOverScan(tupleScanRange, widenedScanRange, store, index, continuation, executeProperties);
    }

    private <M extends Message> RecordCursor<IndexEntry> executeEntriesWithOverScan(@Nonnull TupleRange tupleScanRange, @Nonnull TupleRange widenedScanRange, @Nonnull FDBRecordStoreBase<M> store, @Nonnull Index index, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        byte[] prefixBytes = RecordQueryIndexPlan.getRangePrefixBytes(tupleScanRange);
        IndexScanContinuationConvertor continuationConvertor = new IndexScanContinuationConvertor(prefixBytes, this.serializationMode);
        IndexScanRange newScanRange = new IndexScanRange(IndexScanType.BY_VALUE, widenedScanRange);
        Range originalKeyRange = tupleScanRange.toRange();
        ExecuteProperties newExecuteProperties = executeProperties.setDefaultCursorStreamingMode(CursorStreamingMode.ITERATOR);
        ScanProperties scanProperties = newExecuteProperties.asScanProperties(this.isReverse());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.of("Executing value index plan with over-scan", new Object[]{LogMessageKeys.INDEX_NAME, this.indexName, LogMessageKeys.NEXT_CONTINUATION, continuation == null ? "null" : ByteArrayUtil2.loggable(continuation), LogMessageKeys.SCAN_PROPERTIES, scanProperties.toString(), LogMessageKeys.ORIGINAL_RANGE, tupleScanRange.toString(), LogMessageKeys.WIDENED_TUPLE_RANGE, widenedScanRange.toString()}));
        }
        return store.scanIndex(index, newScanRange, continuationConvertor.unwrapContinuation(continuation), scanProperties).mapResult(result -> {
            if (!result.hasNext()) {
                RecordCursorContinuation wrappedContinuation = continuationConvertor.wrapContinuation(result.getContinuation());
                return result.withContinuation(wrappedContinuation);
            }
            IndexEntry entry = (IndexEntry)result.get();
            byte[] keyBytes = entry.getKey().pack();
            if (this.isReverse() && ByteArrayUtil.compareUnsigned(originalKeyRange.begin, keyBytes) <= 0 || !this.isReverse() && ByteArrayUtil.compareUnsigned(originalKeyRange.end, keyBytes) > 0) {
                RecordCursorContinuation wrappedContinuation = continuationConvertor.wrapContinuation(result.getContinuation());
                return result.withContinuation(wrappedContinuation);
            }
            return RecordCursorResult.exhausted();
        });
    }

    @Override
    @Nonnull
    public String getIndexName() {
        return this.indexName;
    }

    @Nonnull
    public IndexScanParameters getScanParameters() {
        return this.scanParameters;
    }

    @Nullable
    public KeyExpression getCommonPrimaryKey() {
        return this.commonPrimaryKey;
    }

    @Override
    @Nonnull
    public IndexScanType getScanType() {
        return this.scanParameters.getScanType();
    }

    @Nonnull
    public IndexFetchMethod getIndexFetchMethod() {
        return this.indexFetchMethod;
    }

    @Override
    @Nonnull
    public RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords getFetchIndexRecords() {
        return this.fetchIndexRecords;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.indexName.equals(indexName);
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return Collections.singleton(this.indexName);
    }

    @Override
    public int maxCardinality(@Nonnull RecordMetaData metaData) {
        Index index = metaData.getIndex(this.indexName);
        if (index.isUnique() && this.scanParameters.isUnique(index)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isStrictlySorted() {
        return this.strictlySorted;
    }

    @Override
    @Nonnull
    public Optional<? extends MatchCandidate> getMatchCandidateMaybe() {
        return this.matchCandidateOptional;
    }

    @Override
    public RecordQueryIndexPlan strictlySorted(@Nonnull FinalMemoizer memoizer) {
        return new RecordQueryIndexPlan(this.indexName, this.getCommonPrimaryKey(), this.scanParameters, this.getIndexFetchMethod(), this.fetchIndexRecords, this.reverse, true, this.matchCandidateOptional, this.resultType, this.constraint);
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.scanParameters.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public RecordQueryIndexPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        return this.withIndexScanParameters(this.scanParameters.translateCorrelations(translationMap, shouldSimplifyValues));
    }

    @Override
    public boolean canBeMinimized() {
        return this.matchCandidateOptional.isPresent();
    }

    @Override
    @Nonnull
    public RecordQueryIndexPlan minimize(@Nonnull List<Quantifier.Physical> newQuantifiers) {
        Verify.verify(newQuantifiers.isEmpty());
        return new RecordQueryIndexPlan(this.indexName, this.commonPrimaryKey, this.scanParameters, this.indexFetchMethod, this.fetchIndexRecords, this.reverse, this.strictlySorted, Optional.empty(), this.resultType, this.constraint);
    }

    @Nonnull
    protected RecordQueryIndexPlan withIndexScanParameters(@Nonnull IndexScanParameters newIndexScanParameters) {
        return new RecordQueryIndexPlan(this.indexName, this.commonPrimaryKey, newIndexScanParameters, this.indexFetchMethod, this.fetchIndexRecords, this.reverse, this.strictlySorted, this.matchCandidateOptional, this.resultType, this.constraint);
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(this.resultType);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        RecordQueryIndexPlan that = (RecordQueryIndexPlan)otherExpression;
        return this.reverse == that.reverse && this.strictlySorted == that.strictlySorted && this.indexFetchMethod == that.indexFetchMethod && this.fetchIndexRecords == that.fetchIndexRecords && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.scanParameters, that.scanParameters);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.indexName, this.scanParameters, this.indexFetchMethod.name(), this.fetchIndexRecords.name(), this.reverse, this.strictlySorted);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.indexName.hashCode() + this.scanParameters.planHash(mode) + (this.reverse ? 1 : 0);
            }
            case FOR_CONTINUATION: {
                int planHash = this.scanParameters instanceof IndexScanComparisons ? PlanHashable.objectsPlanHash(mode, BASE_HASH, this.indexName, this.getScanType(), this.getScanComparisons(), this.reverse, this.strictlySorted) : PlanHashable.objectsPlanHash(mode, BASE_HASH, this.indexName, this.scanParameters, this.reverse, this.strictlySorted);
                return planHash;
            }
        }
        throw new UnsupportedOperationException("Hash kind " + mode.name() + " is not supported");
    }

    @Nonnull
    public String toString() {
        return ExplainPlanVisitor.toStringForDebugging(this);
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_INDEX);
    }

    @Override
    public boolean hasScanComparisons() {
        return this.scanParameters instanceof IndexScanComparisons;
    }

    @Override
    @Nonnull
    public ScanComparisons getScanComparisons() {
        if (this.scanParameters instanceof IndexScanComparisons) {
            return ((IndexScanComparisons)this.scanParameters).getComparisons();
        }
        throw new RecordCoreException("this plan does not use ScanComparisons", new Object[0]);
    }

    @Override
    @Nonnull
    public ComparisonRanges getComparisonRanges() {
        return this.comparisonRangesSupplier.get();
    }

    @Nonnull
    private ComparisonRanges computeComparisonRanges() {
        if (this.scanParameters instanceof MultidimensionalIndexScanComparisons) {
            MultidimensionalIndexScanComparisons mdIndexScanComparisons = (MultidimensionalIndexScanComparisons)this.scanParameters;
            ImmutableList.Builder comparisonRangeBuilder = ImmutableList.builder();
            ComparisonRanges prefixComparisonRanges = ComparisonRanges.from(mdIndexScanComparisons.getPrefixScanComparisons());
            comparisonRangeBuilder.addAll(prefixComparisonRanges.getRanges());
            List dimensionComparisonRanges = mdIndexScanComparisons.getDimensionsScanComparisons().stream().flatMap(dimensionScanComparisons -> ComparisonRanges.from(dimensionScanComparisons).getRanges().stream()).collect(ImmutableList.toImmutableList());
            ComparisonRanges suffixComparisonRanges = ComparisonRanges.from(mdIndexScanComparisons.getSuffixScanComparisons());
            return new ComparisonRanges((List<ComparisonRange>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(prefixComparisonRanges.getRanges())).addAll((Iterable)dimensionComparisonRanges)).addAll(suffixComparisonRanges.getRanges())).build()));
        }
        return ComparisonRanges.from(this.getScanComparisons());
    }

    @Override
    public boolean hasComparisonRanges() {
        if (this.scanParameters instanceof MultidimensionalIndexScanComparisons) {
            return true;
        }
        return this.hasScanComparisons();
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    @Nonnull
    public PlannerGraph createIndexPlannerGraph(@Nonnull RecordQueryPlan identity, @Nonnull NodeInfo nodeInfo, @Nonnull List<String> additionalDetails, @Nonnull Map<String, Attribute> additionalAttributeMap) {
        String extendedIndexName;
        Optional<? extends MatchCandidate> matchCandidateOptional;
        ImmutableList.Builder<String> detailsBuilder = ImmutableList.builder();
        ImmutableMap.Builder<String, Attribute> attributeMapBuilder = ImmutableMap.builder();
        detailsBuilder.addAll(additionalDetails);
        attributeMapBuilder.putAll(additionalAttributeMap);
        this.scanParameters.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        if (this.reverse) {
            detailsBuilder.add((Object)"direction: {{direction}}");
            attributeMapBuilder.put("direction", Attribute.gml("reversed"));
        }
        if ((matchCandidateOptional = this.getMatchCandidateMaybe()).isPresent() && matchCandidateOptional.get() instanceof AggregateIndexMatchCandidate) {
            AggregateIndexMatchCandidate aggregateIndexMatchCandidate = (AggregateIndexMatchCandidate)matchCandidateOptional.get();
            extendedIndexName = aggregateIndexMatchCandidate.toString();
        } else {
            extendedIndexName = this.getIndexName();
        }
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(identity, nodeInfo, (List<String>)((Object)detailsBuilder.build()), attributeMapBuilder.build()), ImmutableList.of(PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.DataNodeWithInfo(NodeInfo.INDEX_DATA, this.getResultType(), ImmutableList.of(extendedIndexName)), ImmutableList.of())));
    }

    private <M extends Message> RecordCursor<QueryResult> fallBackContinueFrom(FDBRecordStoreBase<M> store, EvaluationContext context, byte[] continuation, ExecuteProperties executeProperties, RecordCursorResult<QueryResult> lastSuccessfulResult) {
        if (lastSuccessfulResult == null) {
            return RecordQueryPlanWithIndex.super.executePlan(store, context, continuation, executeProperties);
        }
        return RecordQueryPlanWithIndex.super.executePlan(store, context, lastSuccessfulResult.getContinuation().toBytes(), executeProperties);
    }

    private void logDebug(String staticMessage) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.of(staticMessage, new Object[]{LogMessageKeys.PLAN_HASH, this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION)}));
        }
    }

    @Override
    @Nonnull
    public QueryPlanConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        return this.toRecordQueryIndexPlanProto(serializationContext);
    }

    public PRecordQueryIndexPlan toRecordQueryIndexPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordQueryIndexPlan.Builder builder = PRecordQueryIndexPlan.newBuilder().setIndexName(this.indexName);
        if (this.commonPrimaryKey != null) {
            builder.setCommonPrimaryKey(this.commonPrimaryKey.toKeyExpression());
        }
        builder.setScanParameters(this.scanParameters.toIndexScanParametersProto(serializationContext));
        builder.setIndexFetchMethod(this.indexFetchMethod.toProto(serializationContext));
        builder.setFetchIndexRecords(this.fetchIndexRecords.toProto(serializationContext));
        builder.setReverse(this.reverse);
        builder.setStrictlySorted(this.strictlySorted);
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        builder.setConstraint(this.constraint.toProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordQueryPlan.newBuilder().setRecordQueryIndexPlan(this.toRecordQueryIndexPlanProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordQueryIndexPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIndexPlan recordQueryIndexPlanProto) {
        return new RecordQueryIndexPlan(serializationContext, recordQueryIndexPlanProto);
    }

    @Nullable
    private TupleRange widenRange(@Nonnull TupleRange originalRange) {
        if (originalRange.getLowEndpoint() == EndpointType.PREFIX_STRING || originalRange.getHighEndpoint() == EndpointType.PREFIX_STRING) {
            return null;
        }
        if (this.isReverse()) {
            return new TupleRange(null, originalRange.getHigh(), EndpointType.TREE_START, originalRange.getHighEndpoint());
        }
        return new TupleRange(originalRange.getLow(), null, originalRange.getLowEndpoint(), EndpointType.TREE_END);
    }

    private static byte[] getRangePrefixBytes(TupleRange tupleRange) {
        int i;
        byte[] highBytes;
        byte[] lowBytes = tupleRange.getLow() == null ? null : tupleRange.getLow().pack();
        byte[] byArray = highBytes = tupleRange.getHigh() == null ? null : tupleRange.getHigh().pack();
        if (lowBytes == null || highBytes == null) {
            return new byte[0];
        }
        for (i = 0; i < lowBytes.length && i < highBytes.length && lowBytes[i] == highBytes[i]; ++i) {
        }
        return Arrays.copyOfRange(lowBytes, 0, i);
    }

    private static class IndexScanContinuationConvertor
    implements RecordCursor.ContinuationConvertor {
        @Nonnull
        private final byte[] prefixBytes;
        @Nonnull
        private final KeyValueCursorBase.SerializationMode serializationMode;

        public IndexScanContinuationConvertor(@Nonnull byte[] prefixBytes, @Nonnull KeyValueCursorBase.SerializationMode serializationMode) {
            this.prefixBytes = prefixBytes;
            this.serializationMode = serializationMode;
        }

        @Override
        @Nullable
        public byte[] unwrapContinuation(@Nullable byte[] continuation) {
            if (continuation == null) {
                return null;
            }
            byte[] innerContinuation = KeyValueCursorBase.Continuation.getInnerContinuation(continuation);
            return new KeyValueCursorBase.Continuation(ByteArrayUtil.join(this.prefixBytes, innerContinuation), 0, this.serializationMode).toBytes();
        }

        @Override
        public RecordCursorContinuation wrapContinuation(@Nonnull RecordCursorContinuation continuation) {
            if (continuation.isEnd()) {
                return continuation;
            }
            byte[] continuationBytes = KeyValueCursorBase.Continuation.getInnerContinuation(continuation.toBytes());
            if (continuationBytes != null && ByteArrayUtil.startsWith(continuationBytes, this.prefixBytes)) {
                return new PrefixRemovingContinuation(continuation, this.prefixBytes.length, this.serializationMode);
            }
            return RecordCursorEndContinuation.END;
        }

        private static class PrefixRemovingContinuation
        implements RecordCursorContinuation {
            private final RecordCursorContinuation baseContinuation;
            private final int prefixLength;
            @Nullable
            private volatile byte[] bytes;
            @Nonnull
            private final KeyValueCursorBase.SerializationMode serializationMode;

            private PrefixRemovingContinuation(RecordCursorContinuation baseContinuation, int prefixLength, @Nonnull KeyValueCursorBase.SerializationMode serializationMode) {
                this.baseContinuation = baseContinuation;
                this.prefixLength = prefixLength;
                this.serializationMode = serializationMode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public byte[] toBytes() {
                if (this.bytes == null) {
                    PrefixRemovingContinuation prefixRemovingContinuation = this;
                    synchronized (prefixRemovingContinuation) {
                        if (this.bytes == null) {
                            this.bytes = KeyValueCursorBase.Continuation.getInnerContinuation(new KeyValueCursorBase.Continuation(KeyValueCursorBase.Continuation.getInnerContinuation(this.baseContinuation.toBytes()), this.prefixLength, this.serializationMode).toBytes());
                        }
                    }
                }
                return this.bytes;
            }

            @Override
            @Nonnull
            public ByteString toByteString() {
                byte[] bytes1 = this.toBytes();
                return bytes1 == null ? ByteString.EMPTY : ByteString.copyFrom(bytes1);
            }

            @Override
            public boolean isEnd() {
                return false;
            }
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordQueryIndexPlan, RecordQueryIndexPlan> {
        @Override
        @Nonnull
        public Class<PRecordQueryIndexPlan> getProtoMessageClass() {
            return PRecordQueryIndexPlan.class;
        }

        @Override
        @Nonnull
        public RecordQueryIndexPlan fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordQueryIndexPlan recordQueryIndexPlanProto) {
            return RecordQueryIndexPlan.fromProto(serializationContext, recordQueryIndexPlanProto);
        }
    }
}

